/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.infra.util.CMyString;

public class PageNavHelper {
    public static String makeNav(PublishPageContext context, String fileName, String fileExt, int pageCount, int currPage) {
        String currextra;
        String target = context.getExtraAttribute("NAV_TARGET");
        if (CMyString.isEmpty(target)) {
            return "";
        }
        String preid = context.getExtraAttribute("NAV_IDPRE");
        boolean zShowPreNext = "true".equals(context.getExtraAttribute("NAV_SHOWPRENEXT"));
        boolean zShowHeadTail = "true".equals(context.getExtraAttribute("NAV_SHOWHT"));
        int nPageGroupCount = 5;
        boolean zShowNavGroup = true;
        try {
            nPageGroupCount = Integer.parseInt(context.getExtraAttribute("NAV_PAGES"));
        }
        catch (Exception ex) {
            zShowNavGroup = false;
        }
        String extra = context.getExtraAttribute("NAV_EXTRA");
        if (extra == null) {
            extra = "";
        }
        if (extra.toLowerCase().indexOf("target") == -1) {
            extra = extra + "target='" + target + "'";
        }
        if ((currextra = context.getExtraAttribute("NAV_CURREXTRA")) == null) {
            currextra = "";
        }
        int currGroup = currPage / nPageGroupCount;
        StringBuffer buff = new StringBuffer(256);
        if (zShowHeadTail && currPage > 0) {
            buff.append("<a id='").append(preid).append("head");
            buff.append("' ").append(extra);
            buff.append(" href='");
            buff.append(fileName).append('.').append(fileExt);
            String head = context.getExtraAttribute("NAV_HEADDESC");
            buff.append("'>").append(head).append("</a>");
        }
        if (zShowNavGroup && currGroup > 0) {
            buff.append("<a id='").append(preid).append("pregroup");
            buff.append("' ").append(extra);
            buff.append(" href='");
            buff.append(fileName);
            buff.append('_').append(nPageGroupCount * currGroup - 1);
            buff.append('.').append(fileExt);
            buff.append("'>\u4e0a").append(nPageGroupCount).append("\u9875</a>");
        }
        if (zShowPreNext && currPage > 0) {
            buff.append("<a id='").append(preid).append(currPage - 1);
            buff.append("' ").append(extra);
            buff.append(" href='");
            buff.append(fileName);
            if (currPage - 1 > 0) {
                buff.append('_').append(currPage - 1);
            }
            buff.append('.').append(fileExt);
            String predesc = context.getExtraAttribute("NAV_PREDESC");
            buff.append("'>").append(predesc).append("</a>");
        }
        int start = nPageGroupCount * currGroup;
        for (int i = 0; i < nPageGroupCount && start < pageCount; ++start, ++i) {
            if (start == currPage) {
                buff.append("<span id='").append(preid).append(start);
                buff.append("' ").append(currextra);
                buff.append(">").append(start + 1).append("</span>");
                continue;
            }
            buff.append("<a id='").append(preid).append(start);
            buff.append("' ").append(extra);
            buff.append(" href='");
            buff.append(fileName);
            if (start > 0) {
                buff.append('_').append(start);
            }
            buff.append('.').append(fileExt);
            buff.append("'>").append(start + 1).append("</a>");
        }
        if (currPage < pageCount - 1) {
            if (zShowPreNext) {
                buff.append("<a id='").append(preid).append(currPage + 1);
                buff.append("' ").append(extra);
                buff.append(" href='");
                buff.append(fileName);
                buff.append('_').append(currPage + 1);
                buff.append('.').append(fileExt);
                String nextdesc = context.getExtraAttribute("NAV_NEXTDESC");
                buff.append("'>").append(nextdesc).append("</a>");
            }
            if (zShowNavGroup && start < pageCount) {
                buff.append("<a id='").append(preid).append("nextgroup");
                buff.append("' ").append(extra);
                buff.append(" href='");
                buff.append(fileName);
                start = (currGroup + 2) * nPageGroupCount;
                if (start > pageCount) {
                    start = pageCount;
                }
                buff.append('_').append(start - 1);
                buff.append('.').append(fileExt);
                buff.append("'>\u4e0b").append(nPageGroupCount).append("\u9875</a>");
            }
        }
        if (zShowHeadTail && currPage != pageCount - 1) {
            buff.append("<a id='").append(preid).append("tail");
            buff.append("' ").append(extra);
            buff.append(" href='");
            buff.append(fileName).append('_').append(pageCount - 1);
            buff.append('.').append(fileExt);
            String tail = context.getExtraAttribute("NAV_TAILDESC");
            buff.append("'>").append(tail).append("</a>");
        }
        return buff.toString();
    }
}

