/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.publisher;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.OrignHomePublishException;
import com.trs.components.common.publish.config.PublishServerConfigMapper;
import com.trs.components.common.publish.domain.distribute.FileDistributeShip;
import com.trs.components.common.publish.domain.publisher.IPublishEventServer;
import com.trs.components.common.publish.domain.publisher.PageNavHelper;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishSyncGlobalTuner;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagDocument;
import com.trs.components.common.publish.domain.tagparser.TagParseHelper;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateParseMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishElements;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsListImpl;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMDatainvalidException;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PageGenerator {
    private static final int RETRYTIMES_ON_WRITEFILE_ERROR = 5;
    private static Logger s_logger = Logger.getLogger(PageGenerator.class);
    private static final HashMap m_oGenerating = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] generateOutlines(PublishPageContext _pageContext) throws WCMException {
        IPublishFolder folder = (IPublishFolder)_pageContext.getPageElement();
        if (folder.isLink()) {
            String[] saLink = new String[]{folder.getLinkUrl()};
            return saLink;
        }
        Templates templates = null;
        if (_pageContext.getTemplate() != null) {
            templates = new Templates(null);
            templates.addElement(_pageContext.getTemplate());
        } else {
            templates = folder.getOutlineTemplates();
            if (templates == null || templates.isEmpty()) {
                throw new WCMDatainvalidException(230, folder.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label1", "]\u9700\u8981\u8bbe\u5b9a\u6982\u89c8\u6a21\u677f"));
            }
        }
        _pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label2", "\u751f\u6210\u6982\u89c8\u6587\u4ef6:") + folder.getInfo());
        ArrayList<String> urlList = new ArrayList<String>();
        for (int i = 0; i < templates.size(); ++i) {
            Template template = (Template)templates.getAt(i);
            if (template == null) {
                s_logger.error((Object)("Get template #[" + i + "] failed."));
                continue;
            }
            String sUrl = PageGenerator.generatePage(_pageContext, template);
            if (sUrl != null) {
                urlList.add(sUrl);
                continue;
            }
            s_logger.error((Object)("Generate page for template [" + template + "] failed."));
        }
        try {
            String[] results = new String[urlList.size()];
            urlList.toArray(results);
            String[] stringArray = results;
            return stringArray;
        }
        finally {
            urlList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String generateDetail(PublishPageContext _pageContext) throws Exception {
        IPublishContent content = (IPublishContent)_pageContext.getPageElement();
        IPublishFolder folder = content.getFolder();
        if (folder == null) {
            throw new WCMException(10, "FolderTypeConfig of current content to publish required (plz call IPublishContent.setFolder())!");
        }
        String sURL = null;
        sURL = content.getModal() == 2 ? PageGenerator.generateDetailOfLinkModalContent(_pageContext, content, folder) : PageGenerator.generateDetailOfNotLinkCotent(_pageContext, content, folder);
        if (!_pageContext.isPreview()) {
            s_logger.debug((Object)("update status of " + content + "..."));
            String sPageURL = _pageContext.getPageHttpURL();
            PageGenerator.updateContentPublishTime(content, _pageContext, sPageURL);
            PageGenerator.updateContentStatus(content, _pageContext);
            User currUser = ContextHelper.getLoginUser();
            try {
                ContextHelper.setLoginUser(_pageContext.getTaskContext().getTask().getCrUser());
                IPublishEventServer eventServer = (IPublishEventServer)DreamFactory.createObjectById("IPublishEventServer");
                eventServer.onSuccess(content, sPageURL, _pageContext);
            }
            finally {
                ContextHelper.setLoginUser(currUser);
            }
        }
        return sURL;
    }

    private static void updateContentPublishTime(IPublishContent content, PublishPageContext _pageContext, String _url) throws Exception {
        CMyDateTime _now = CMyDateTime.now();
        content.setPublishTimeAndURL(_now, _url);
        PublishTask task = _pageContext.getTaskContext().getTask();
        if (task.getPublishType() != 10) {
            return;
        }
        if (content.getModal() != 1) {
            return;
        }
        PublishElementsListImpl folders = new PublishElementsListImpl();
        if (content.getType() == 605) {
            PageGenerator.makeFoldersUseContent(content, folders);
            for (int i = folders.size() - 1; i >= 0; --i) {
                IPublishFolder folder = (IPublishFolder)folders.get(i);
                IPublishContent newContent = PublishElementFactory.makeContentFrom(content.getSubstance(), folder);
                if (newContent.getModal() != 2) continue;
                newContent.setPublishTimeAndURL(_now, _url);
            }
        }
    }

    private static String generateDetailOfNotLinkCotent(PublishPageContext _pageContext, IPublishContent content, IPublishFolder folder) throws Exception {
        boolean bPreview = _pageContext.isPreview();
        if (content.isLink()) {
            if (bPreview) {
                return content.getLinkUrl();
            }
            _pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label3", "\u5728[") + folder.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label4", "]\u4e2d\u94fe\u63a5\u6587\u6863[") + content.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label5", "]\u6570\u636e\u751f\u6210\u5b8c\u6210\uff01"));
            return null;
        }
        if (content.isFile()) {
            String url = PageGenerator.publishDocFile(_pageContext);
            if (bPreview) {
                return url;
            }
            _pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label3", "\u5728[") + folder.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label6", "]\u4e2d\u5916\u90e8\u6587\u4ef6[") + content.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label5", "]\u6570\u636e\u751f\u6210\u5b8c\u6210\uff01"));
            return null;
        }
        Template template = null;
        if (_pageContext.isPreview()) {
            template = _pageContext.getTemplate();
            if (template == null) {
                template = content.getDetailTemplate();
            }
        } else {
            template = content.getDetailTemplate();
            if (template == null) {
                template = _pageContext.getTemplate();
            }
        }
        if (template == null) {
            throw new WCMException(content.getSubstance() + I18NMessage.get(PageGenerator.class, "PageGenerator.label7", "\u6ca1\u6709\u8bbe\u7f6e\u7ec6\u89c8\u6a21\u677f\uff01"));
        }
        _pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label8", "\u751f\u6210\u7ec6\u89c8\u6587\u4ef6:") + content.getInfo());
        return PageGenerator.generatePage(_pageContext, template);
    }

    private static String generateDetailOfLinkModalContent(PublishPageContext _pageContext, IPublishContent content, IPublishFolder folder) throws Exception {
        boolean bPreview = _pageContext.isPreview();
        if (PublishServerConfigMapper.isAutoPublishDocInHomeWhenNeeded() && (bPreview || !content.isPublishedInHome())) {
            IPublishFolder oldFolder = content.getFolder();
            content.setFolder(content.getOriginalHome());
            try {
                if (bPreview) {
                    content.validateCanDoPreview();
                } else {
                    content.validateCanDoPub();
                }
            }
            catch (Throwable e) {
                throw new OrignHomePublishException(I18NMessage.get(PageGenerator.class, "PageGenerator.label9", "\u539f\u59cb\u6587\u6863[") + content.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label10", "]\u4e0d\u80fd\u6b63\u5e38\u53d1\u5e03\u5bfc\u81f4\u5728\u680f\u76ee[[") + oldFolder.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label11", "]]\u4e2d\u7684\u5f15\u7528\u53d1\u5e03\u5931\u8d25\uff01"), e);
            }
            PublishPageContext context = new PublishPageContext(content, _pageContext.getTaskContext(), _pageContext.getProgressMonitor());
            context.setRoot(content.getOriginalHome().getRoot());
            try {
                _pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label12", "\u89e6\u53d1\u53d1\u5e03\u7ec6\u89c8:") + content.getInfo());
                String sUrl = PageGenerator.generateDetail(context);
                content.setFolder(oldFolder);
                String string = sUrl;
                return string;
            }
            catch (Exception ex) {
                throw new WCMException(220, "Failed to generate the content detail page in its home folder!", ex);
            }
            finally {
                context.clear();
            }
        }
        if (bPreview) {
            return _pageContext.getPathCompass().getPreviewHttpUrl(content, 0);
        }
        _pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label3", "\u5728[") + folder.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label13", "]\u4e2d\u94fe\u63a5\u5f15\u7528[") + content.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label5", "]\u6570\u636e\u751f\u6210\u5b8c\u6210\uff01"));
        return null;
    }

    private static void updateContentStatus(IPublishContent content, PublishPageContext context) throws WCMException, Exception {
        content.setPublishStatus(50);
        PublishTask task = context.getTaskContext().getTask();
        if (task.getPublishType() != 10) {
            return;
        }
        if (content.getModal() != 1) {
            return;
        }
        PublishElementsListImpl folders = new PublishElementsListImpl();
        if (content.getType() == 605) {
            PageGenerator.makeFoldersUseContent(content, folders);
            for (int i = folders.size() - 1; i >= 0; --i) {
                IPublishFolder folder = (IPublishFolder)folders.get(i);
                IPublishContent newContent = PublishElementFactory.makeContentFrom(content.getSubstance(), folder);
                if (newContent.getModal() != 2) continue;
                newContent.setPublishStatus(50);
            }
        }
    }

    private static void makeFoldersUseContent(IPublishContent _content, IPublishElements _folders) throws WCMException, Exception {
        Document document = (Document)_content.getSubstance();
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Channels channels = documentMgr.getChannels(document, 0, null);
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            IPublishFolder folder;
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || !(folder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel)).canDoOutlinePageTask()) continue;
            _folders.add(folder);
        }
    }

    public static String generatePage(PublishPageContext _pageContext, Template _template) throws WCMException {
        return PageGenerator.generatePage(_pageContext, _template, false);
    }

    public static String generatePage(PublishPageContext _pageContext, Template _template, boolean _bDiffContent) throws WCMException {
        if (_template == null) {
            throw new WCMException(I18NMessage.get(PageGenerator.class, "PageGenerator.label14", "\u6ca1\u6709\u6307\u5b9a\u6a21\u677f\uff01"));
        }
        HashMap<String, String> variables = null;
        try {
            TemplateParseMgr parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            _pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label15", "\u89e3\u6790\u6a21\u677f:") + _template.getInfo());
            TagDocument tagDoc = parseMgr.parse(_template);
            if (tagDoc == null) {
                s_logger.fatal((Object)("Parse _template[" + _template + "]failed"));
                String string = null;
                return string;
            }
            IPublishElement publishElement = _pageContext.getPageElement();
            PublishTagContext tagContext = new PublishTagContext(_pageContext);
            _pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label16", "\u5e94\u7528\u6a21\u677f\u751f\u6210\u6587\u4ef6"));
            boolean isReservedTemplate = false;
            if (_pageContext.getTemplate() == null && _template != null) {
                _pageContext.setTemplate(_template);
                isReservedTemplate = true;
            }
            HashMap<String, String> map = new HashMap<String, String>(1);
            String tempExt = _template == null ? "html" : _template.getPropertyAsString("TEMPEXT", "html");
            map.put("html".toUpperCase(), tempExt);
            tagContext.setExtraAttributes(map);
            DebugTimer parseItemsTimer = new DebugTimer();
            if (s_logger.isDebugEnabled()) {
                parseItemsTimer.start();
            }
            String[] results = TagParseHelper.parseItems(tagDoc.getItems(), tagContext);
            if (s_logger.isDebugEnabled()) {
                parseItemsTimer.stop();
                s_logger.debug((Object)(" Parse items for template [" + _template.getInfo() + "] use [" + parseItemsTimer.getTime() + "]ms."));
            }
            if (isReservedTemplate) {
                _pageContext.setTemplate(null);
            }
            if (results == null) {
                s_logger.fatal((Object)("Parse _template[" + _template + "]failed"));
                String string = null;
                return string;
            }
            boolean bPreview = _pageContext.isPreview();
            PublishPathCompass compass = _pageContext.getPathCompass();
            String sRootPath = compass.getRootHttpPathFrom(publishElement);
            String sEncoding = publishElement.getEncoding();
            String sLocalPath = compass.getLocalPath(publishElement, bPreview);
            PublishSyncGlobalTuner.insureLocalPathExists(sLocalPath);
            String sFileName = null;
            String sFileExt = _template.getOutputFileExt();
            String sFullFileName = null;
            String sLocalFilePathName = null;
            FileDistributeShip distributeShip = null;
            String sUrlReturn = null;
            TemplateEmployMgr employMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
            boolean bNameByTemplateFile = ConfigServer.getServer().getSysConfigValue("NAME_BY_TEMPLATE_FILE", "false").equalsIgnoreCase("true");
            boolean bOnlyTemplateName = "true".equalsIgnoreCase(_pageContext.getExtraAttribute("OnlyTemplateName"));
            List wmlimgs = null;
            DebugTimer genPageTimer = new DebugTimer();
            if (s_logger.isDebugEnabled()) {
                genPageTimer.start();
            }
            for (int i = 0; i < results.length; ++i) {
                boolean bShowWhenOnePage;
                if (publishElement.isFolder()) {
                    if (sFileName == null) {
                        sFileName = _template.getOutputFileName();
                        if (!(bOnlyTemplateName || bNameByTemplateFile || _template.equals(employMgr.getDefaultOutlineTemplate((IPublishFolder)publishElement)))) {
                            sFileName = sFileName + "_" + _template.getId();
                        }
                    }
                    sFullFileName = PublishPathCompass.makePageFileName(sFileName, sFileExt, i);
                    _pageContext.incOutlinePageCount();
                } else {
                    if (sFileName == null) {
                        sFileName = PublishPathCompass.makeDetailPageFileName((IPublishContent)publishElement);
                        if (_bDiffContent) {
                            String sExt = _pageContext.getExtraAttribute("EXT");
                            if (sExt == null || "".equalsIgnoreCase(sExt)) {
                                sExt = "ext";
                            } else if ("templateid".equalsIgnoreCase(sExt)) {
                                sExt = _template.getId() + "";
                            }
                            sFileName = sFileName + "_" + sExt;
                        }
                        _pageContext.setFileName(sFileName + '.' + sFileExt);
                    }
                    sFullFileName = PublishPathCompass.makePageFileName(sFileName, sFileExt, i);
                    _pageContext.incDetailPageCount();
                }
                sLocalFilePathName = sLocalPath + sFullFileName;
                if (variables == null) {
                    variables = new HashMap<String, String>(5);
                    variables.put("ROOT_PATH", sRootPath);
                    variables.put("PAGE_COUNT", String.valueOf(results.length));
                    variables.put("PAGE_NAME", sFileName);
                    variables.put("PAGE_EXT", sFileExt);
                    variables.put("RECORD_COUNT", _pageContext.getExtraAttribute("RECORD_COUNT"));
                }
                variables.put("PAGE_INDEX", String.valueOf(i));
                variables.put("PAGE_FULL_NAME", sFullFileName);
                User user = null;
                String userName = null;
                if (_pageContext.getTaskContext() != null && _pageContext.getTaskContext().getTask() != null && _pageContext.getTaskContext().getTask().getCrUser() != null) {
                    user = _pageContext.getTaskContext().getTask().getCrUser();
                }
                if (user == null) {
                    User user2 = user = null == ContextHelper.getLoginUser() ? User.getSystem() : ContextHelper.getLoginUser();
                }
                if ((userName = user.getTrueName()) == null || userName.trim().equals("")) {
                    userName = user.getName();
                }
                variables.put("PAGE_PUBLISHER", userName);
                String sShowOnlyOne = _pageContext.getExtraAttribute("NAV_SHOWWHENONEPAGE");
                boolean bl = bShowWhenOnePage = sShowOnlyOne == null ? true : "true".equalsIgnoreCase(sShowOnlyOne);
                if (!bShowWhenOnePage && results.length == 1) {
                    variables.put("OUTLINE_NAV", "");
                } else {
                    variables.put("OUTLINE_NAV", PageNavHelper.makeNav(_pageContext, sFileName, sFileExt, results.length, i));
                }
                if (wmlimgs == null) {
                    wmlimgs = PageGenerator.makeWmlImg(_pageContext);
                }
                if (!wmlimgs.isEmpty()) {
                    int ix = i >= wmlimgs.size() ? 0 : i;
                    variables.putAll((Map)wmlimgs.get(ix));
                }
                String sContent = CMyString.parsePageVariables(results[i], variables);
                _pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label17", "\u8f93\u51fa\u672c\u5730\u6587\u4ef6:") + sLocalFilePathName);
                PageGenerator.generateFile(sLocalFilePathName, sContent, sEncoding);
                if (!bPreview) {
                    if (distributeShip == null) {
                        distributeShip = _pageContext.getFileDistributeShip();
                    }
                    _pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label18", "\u5206\u53d1\u6587\u4ef6:") + sLocalFilePathName);
                    DebugTimer distributeFileTimer = new DebugTimer();
                    if (s_logger.isDebugEnabled()) {
                        distributeFileTimer.start();
                    }
                    distributeShip.distributeFile(sLocalFilePathName, publishElement);
                    if (s_logger.isDebugEnabled()) {
                        distributeFileTimer.stop();
                        s_logger.debug((Object)("Distribute File [" + sLocalFilePathName + "] use time[" + distributeFileTimer.getTime() + "]ms"));
                    }
                }
                if (i != 0) continue;
                if (bPreview) {
                    sUrlReturn = compass.getPreviewHttpPath(publishElement) + sFullFileName;
                    sUrlReturn = sUrlReturn + "?randid=" + Math.random();
                    continue;
                }
                sUrlReturn = sLocalFilePathName;
            }
            if (s_logger.isDebugEnabled()) {
                genPageTimer.stop();
                s_logger.debug((Object)("Generate file [" + _pageContext.getPageElement().getInfo() + "]and distribute use time[" + genPageTimer.getTime() + "]ms"));
            }
            String string = sUrlReturn;
            return string;
        }
        catch (Exception ex) {
            throw new WCMException(237, I18NMessage.get(PageGenerator.class, "PageGenerator.label19", "\u751f\u6210'") + _pageContext.getPageElement().getInfo() + "(Template[" + _template.getId() + "]:" + _template.getName() + I18NMessage.get(PageGenerator.class, "PageGenerator.label20", ")'\u7684\u6587\u4ef6\u5931\u8d25"), ex);
        }
        finally {
            if (variables != null) {
                variables.clear();
            }
        }
    }

    private static List makeWmlImg(PublishPageContext context) {
        String imgs = context.getExtraAttribute("PGVAR_WCMIMG");
        if (imgs == null) {
            return new ArrayList(0);
        }
        String[] temp = imgs.split("\\|");
        ArrayList list = new ArrayList(temp.length);
        String[] img = null;
        HashMap<String, String> map = null;
        int len = temp.length;
        for (int i = 0; i < len; ++i) {
            img = temp[i].split(",");
            map = new HashMap<String, String>(2);
            map.put("PAGVAR_WMLIMG", img[0]);
            map.put("PAGVAR_WMIMGDESC", img[1]);
            list.add(map);
        }
        return list;
    }

    private static final String publishDocFile(PublishPageContext _context) throws WCMException {
        boolean bPreview = _context.isPreview();
        IPublishContent content = (IPublishContent)_context.getPageElement();
        String sFileName = content.getFileName();
        if (sFileName == null) {
            throw new WCMException(I18NMessage.get(PageGenerator.class, "PageGenerator.label21", "\u6587\u4ef6\u7c7b\u578b\u7684\u6587\u6863(") + content.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label22", ")\u6ca1\u6709\u8bbe\u7f6e\u5916\u90e8\u6587\u4ef6."));
        }
        String sSrcPath = FilesMan.getFilesMan().mapFilePath(sFileName, 0);
        String sSrcFile = sSrcPath + sFileName;
        if (!CMyFile.fileExists(sSrcFile)) {
            _context.addWarning(I18NMessage.get(PageGenerator.class, "PageGenerator.label24", "\u5916\u90e8\u6587\u4ef6"), content.getId(), I18NMessage.get(PageGenerator.class, "PageGenerator.label25", "\u6ca1\u6709\u627e\u5230\u6587\u4ef6\u7c7b\u578b ") + content.getInfo() + I18NMessage.get(PageGenerator.class, "PageGenerator.label26", " \u7684\u5916\u90e8\u6587\u4ef6[") + sFileName + "]");
            return null;
        }
        String sDstPath = _context.getPathCompass().getLocalPath(content, bPreview);
        sFileName = ((PublishContentDocumentImpl)content).getRealFileName();
        String sDstFile = sDstPath + sFileName;
        PublishSyncGlobalTuner.insureLocalPathExists(sDstPath);
        try {
            if (!CMyFile.fileExists(sDstFile)) {
                CMyFile.copyFile(sSrcFile, sDstFile);
            }
        }
        catch (CMyException e) {
            throw new WCMException(I18NMessage.get(PageGenerator.class, "PageGenerator.label27", "\u62f7\u8d1d\u6587\u4ef6\u5931\u8d25\uff01") + sSrcFile + "-->" + sDstFile);
        }
        if (bPreview) {
            return _context.getPathCompass().getPreviewHttpPath(content) + sFileName;
        }
        _context.setFileName(sFileName);
        _context.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label18", "\u5206\u53d1\u6587\u4ef6:") + sSrcFile);
        _context.getFileDistributeShip().distributeFile(sSrcFile, content, null, true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void generateFile(String sFileName, String sContent, String sEncoding) throws CMyException {
        if (!PageGenerator.testAndRegister(sFileName)) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("File '" + sFileName + "' generating."));
            }
            return;
        }
        CMyException onError = null;
        try {
            for (int retry = 0; retry < 5; ++retry) {
                try {
                    CMyFile.writeFile(sFileName, sContent, sEncoding);
                    onError = null;
                    break;
                }
                catch (CMyException ex) {
                    onError = ex;
                    s_logger.error((Object)("Failed to write file, retry: " + retry), (Throwable)ex);
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        finally {
            PageGenerator.unregister(sFileName);
        }
        if (onError != null) {
            throw onError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean testAndRegister(String sFileName) {
        if (sFileName == null) {
            return false;
        }
        HashMap hashMap = m_oGenerating;
        synchronized (hashMap) {
            if (m_oGenerating.get(sFileName) != null) {
                return false;
            }
            m_oGenerating.put(sFileName, sFileName);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final synchronized void unregister(String sFileName) {
        if (sFileName == null) {
            return;
        }
        HashMap hashMap = m_oGenerating;
        synchronized (hashMap) {
            m_oGenerating.remove(sFileName);
        }
    }

    private PageGenerator() {
    }

    private static String getPageNavigator(int nIndex, int nSize, String _strPathRoot, String _strPathExt) {
        if (nSize <= 1) {
            return "";
        }
        StringBuffer strPageNavigator = new StringBuffer(1024);
        strPageNavigator.append("<DIV style='display:none' id='idTRSNavigator' class='clsTRSNavigatorDIV'>");
        strPageNavigator.append(PageGenerator.getListNavigator(nIndex, nSize, _strPathRoot, _strPathExt));
        strPageNavigator.append("</DIV>");
        return strPageNavigator.toString();
    }

    private static String getListNavigator(int _nIndex, int _nSize, String _strPathName, String _strPathExt) {
        StringBuffer bufListNavigator = new StringBuffer(255);
        if (_nIndex != 0) {
            bufListNavigator.append("<A id='idTRSListLink' class='clsTRSListLink' href='");
            bufListNavigator.append(PageGenerator.getSlaveFilePath(0, _strPathName, _strPathExt));
            bufListNavigator.append("'>1</A>");
        } else {
            bufListNavigator.append("1");
        }
        for (int nIndex = 1; nIndex < _nSize; ++nIndex) {
            if (_nIndex != nIndex) {
                bufListNavigator.append(",<A id='idTRSListLink' class='idTRSListLink' href='");
                bufListNavigator.append(PageGenerator.getSlaveFilePath(nIndex, _strPathName, _strPathExt));
                bufListNavigator.append("'>");
                bufListNavigator.append(nIndex + 1);
                bufListNavigator.append("</A>");
                continue;
            }
            bufListNavigator.append(",");
            bufListNavigator.append(nIndex + 1);
        }
        return bufListNavigator.toString();
    }

    private static String getSlaveFilePath(int nIndex, String _strPathPrefix, String _strPathExt) {
        StringBuffer bufNewPath = new StringBuffer(255);
        bufNewPath.append(_strPathPrefix);
        if (nIndex != 0) {
            bufNewPath.append("_");
            bufNewPath.append(nIndex);
        }
        bufNewPath.append(".");
        bufNewPath.append(_strPathExt);
        return bufNewPath.toString();
    }

    public static String[] generateContent(PublishPageContext _pageContext, Template _template) throws WCMException {
        try {
            TemplateParseMgr parseMgr = (TemplateParseMgr)DreamFactory.createObjectById("TemplateParseMgr");
            _pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label28", "\u89e3\u6790\u6a21\u7248:") + _template.getInfo());
            TagDocument tagDoc = parseMgr.parse(_template);
            if (tagDoc == null) {
                s_logger.fatal((Object)("Parse _template[" + _template + "]failed"));
                return null;
            }
            PublishTagContext tagContext = new PublishTagContext(_pageContext);
            _pageContext.log2Monitor(I18NMessage.get(PageGenerator.class, "PageGenerator.label29", "\u5e94\u7528\u6a21\u7248\u53d6\u5f97\u6587\u4ef6\u5185\u5bb9"));
            String[] results = TagParseHelper.parseItems(tagDoc.getItems(), tagContext);
            if (results == null) {
                s_logger.fatal((Object)("Parse _template[" + _template + "]failed"));
                return null;
            }
            return results;
        }
        catch (Exception ex) {
            throw new WCMException(237, I18NMessage.get(PageGenerator.class, "PageGenerator.label30", "\u83b7\u5f97\u5e94\u7528\u6a21\u677f\u53d6\u5f97\u6587\u4ef6\u5185\u5bb9\u5931\u8d25:'") + _pageContext.getPageElement().getInfo() + "(Template[" + _template.getId() + "]:" + _template.getName() + ")'", ex);
        }
    }
}

