/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.job;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.job.JobWorkerType;
import com.trs.components.common.job.Schedules;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.NullValue;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.database.FieldInfo;
import java.util.ArrayList;
import java.util.List;

public class Schedule
extends CMSObj {
    public static final int OBJ_TYPE = 501;
    public static final String DB_TABLE_NAME = "WCMSCHEDULE";
    public static final String DB_ID_NAME = "SCHID";
    public static final int MODE_ONE_TIME_DAY = 1;
    public static final int MODE_MORE_TIMES_DAY = 2;
    public static final int MODE_ONE_TIME_ONLY = 3;
    public static final int STATUS_NORMAL = 1;
    public static final int STATUS_UNKNOWN = -1;
    public static final int STATUS_NOTSTART = 0;
    public static final int STATUS_WAIT = 1;
    public static final int STATUS_RUN = 5;
    public static final int STATUS_DONE = 7;
    public static final int STATUS_EXPIRED = 8;
    public static final int STATUS_FAILED = 9;
    public static final int STATUS_CANCELED = 10;
    public static final int STATUS_PARAM_INVALID = 11;
    public CMyDateTime dtAddList = CMyDateTime.now();

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 501;
    }

    public String getName() {
        return (String)this.getProperty("SCHNAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("SCHNAME", _name);
    }

    public String getDesc() {
        return (String)this.getProperty("SCHDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("SCHDESC", _desc);
    }

    public int getSenderType() {
        return this.getPropertyAsInt("SENDERTYPE", 0);
    }

    public int getSenderId() {
        return this.getPropertyAsInt("SENDERID", 0);
    }

    public boolean setSender(int _senderType, int _senderId) throws WCMException {
        return this.setProperty("SENDERTYPE", _senderType) && this.setProperty("SENDERID", _senderId);
    }

    public boolean setSender(CMSObj _sender) throws WCMException {
        if (_sender == null) {
            return this.setSender(0, 0);
        }
        if (!_sender.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label1", "\u6307\u5b9aSender\u5bf9\u8c61\u65e0\u6548(Job.setSender)"));
        }
        return this.setSender(_sender.getWCMType(), _sender.getId());
    }

    public int getStatus() {
        return this.getPropertyAsInt("SCHSTATUS", 1);
    }

    public boolean setStatus(int _status) throws WCMException {
        return this.setProperty("SCHSTATUS", _status);
    }

    public boolean isDeleted() {
        return this.getStatus() < 0;
    }

    public boolean setDeleted(boolean _bDeleted) throws WCMException {
        int nStatus = this.getStatus();
        if (nStatus < 0 == _bDeleted) {
            return false;
        }
        return this.setStatus(-nStatus);
    }

    public int getWorkerTypeId() {
        return this.getPropertyAsInt("OPTYPE", 0);
    }

    public JobWorkerType getWorkerType() throws WCMException {
        int nId = this.getWorkerTypeId();
        return JobWorkerType.findById(nId);
    }

    public boolean setWorkerType(int _nWorkerTypeId) throws WCMException {
        return this.setWorkerType(JobWorkerType.findById(_nWorkerTypeId));
    }

    public boolean setWorkerType(JobWorkerType _worker) throws WCMException {
        if (!this.isAddMode()) {
            throw new WCMException(1107, I18NMessage.get(Schedule.class, "Schedule.label2", "\u5c5e\u6027OpType\u4e0d\u5141\u8bb8\u4fee\u6539"));
        }
        if (_worker == null || !_worker.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label3", "\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u6027\u5bf9\u8c61"));
        }
        return this.setProperty("OPTYPE", _worker.getId());
    }

    public String getOperArgs() {
        return (String)this.getProperty("OPARGS");
    }

    public String getOperArgValue(String _sArgName) {
        String sOperArgs = this.getOperArgs();
        if (sOperArgs == null || sOperArgs.length() <= 0) {
            return "";
        }
        AttributesString aAttr = new AttributesString(this.getOperArgs());
        return aAttr.getAttributeValue(_sArgName);
    }

    public List getOperArgNames() {
        String sOperArgs = this.getOperArgs();
        if (sOperArgs == null || sOperArgs.length() <= 0) {
            return new ArrayList();
        }
        AttributesString aAttr = new AttributesString(this.getOperArgs());
        return aAttr.getNameList();
    }

    public boolean setOperArgs(String _sOpArgs) throws WCMException {
        return this.setProperty("OPARGS", _sOpArgs);
    }

    public int getMode() {
        return this.getPropertyAsInt("SCHMODE", 0);
    }

    public boolean setMode(int _nMode) throws WCMException {
        return this.setProperty("SCHMODE", _nMode);
    }

    public CMyDateTime getExeTime() {
        return (CMyDateTime)this.getProperty("ETime");
    }

    public boolean setExeTime(CMyDateTime _exeTime) throws WCMException {
        if (_exeTime == null || _exeTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label4", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(Schedule.setExeTime)"));
        }
        return this.setProperty("ETIME", _exeTime);
    }

    public CMyDateTime getStartTime() {
        return (CMyDateTime)this.getProperty("SDATE");
    }

    public boolean setStartTime(CMyDateTime _startTime) throws WCMException {
        if (_startTime == null || _startTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label5", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(Schedule.setStartTime)"));
        }
        return this.setProperty("SDATE", _startTime);
    }

    public CMyDateTime getEndTime() {
        return (CMyDateTime)this.getProperty("EDATE");
    }

    public boolean setEndTime(CMyDateTime _endTime) throws WCMException {
        if (_endTime == null || _endTime.isNull()) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label6", "\u65e0\u6548\u7684\u65f6\u95f4\u5bf9\u8c61(Schedule.setEndTime)"));
        }
        return this.setProperty("EDATE", _endTime);
    }

    public int getParam() {
        return this.getPropertyAsInt("PARAM", 0);
    }

    public boolean setParam(int _nParam) throws WCMException {
        return this.setProperty("PARAM", _nParam);
    }

    public CMyDateTime getLastExeTime() {
        return this.getPropertyAsDateTime("LASTEXETIME");
    }

    public boolean setLastExeTime() throws WCMException {
        return this.setProperty("LASTEXETIME", CMyDateTime.now());
    }

    public boolean setLastExeTime(CMyDateTime _time) throws WCMException {
        if (_time == null || _time.isNull()) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label7", "\u6307\u5b9a\u65f6\u95f4\u65e0\u6548(Schedule.setLastExeTime)"));
        }
        return this.setProperty("LASTEXETIME", _time.clone());
    }

    public int getLasExeResult() {
        return this.getPropertyAsInt("LASTEXERES", 0);
    }

    public boolean setLastExeResult(int _nResult) throws WCMException {
        return this.setProperty("LASTEXERES", _nResult);
    }

    public int getLastTimeUsed() {
        return this.getPropertyAsInt("LASTTIMEUSED", 0);
    }

    public boolean setLastTimeUsed(int _nTimeUsed) throws WCMException {
        if (_nTimeUsed < 0) {
            throw new WCMException(10, I18NMessage.get(Schedule.class, "Schedule.label8", "\u6307\u5b9a\u7684\u65f6\u95f4\u503c\u5c0f\u4e8e0(Schedule.setTimeUsed)"));
        }
        return this.setProperty("LASTTIMEUSED", _nTimeUsed);
    }

    @Override
    public boolean isValid() throws WCMException {
        block16: {
            String sName;
            block15: {
                sName = null;
                if (!this.isAddMode()) break block15;
                sName = (String)this.getAllProperty().get("SCHNAME");
                if (sName == null) {
                    throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label9", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(Schedule.isValid)"));
                }
                if (this.getProperty("OpType") == null) {
                    throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label10", "\u64cd\u4f5c\u7c7b\u578b\u6ca1\u6709\u8bbe\u7f6e(Schedule.isValid)"));
                }
                if (this.getProperty("SchMode") == null) {
                    throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label11", "Schedule\u6a21\u5f0f\u6ca1\u6709\u8bbe\u7f6e(Schedule.isValid)"));
                }
                switch (this.getMode()) {
                    case 2: {
                        if (this.getStartTime() == null) {
                            throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label12", "StartTime\u8bbe\u7f6e(Schedule.isValid)"));
                        }
                        if (this.getEndTime() == null) {
                            throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label13", "EndTime\u8bbe\u7f6e(Schedule.isValid)"));
                        }
                        if (this.getParam() <= 0) {
                            throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label13", "EndTime\u8bbe\u7f6e(Schedule.isValid)"));
                        }
                        break block16;
                    }
                    case 1: {
                        if (this.getExeTime() == null) {
                            throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label14", "ExeTime\u8bbe\u7f6e(Schedule.isValid)"));
                        }
                        break block16;
                    }
                    case 3: {
                        if (this.getExeTime() == null) {
                            throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label15", "ExecTime\u8bbe\u7f6e(Schedule.isValid)"));
                        }
                        break block16;
                    }
                    default: {
                        throw new WCMException(1106, I18NMessage.get(Schedule.class, "Schedule.label16", "Mode\u4e0d\u7b26\u5408\u89c4\u8303(Schedule.isValid)"));
                    }
                }
            }
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(Schedule.class, "Schedule.label17", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(Schedule.isValid)"));
            }
            sName = (String)this.getNewProperty("SCHNAME");
            if (!this.isChangeProperty("LASTEXETIME")) {
                FieldInfo fi = this.getDBManager().getFieldInfo(DB_TABLE_NAME, "LASTEXETIME");
                this.setProperty("LASTEXETIME", new NullValue(fi.getDataType().getType()));
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            if (this.getAllProperty().get("SCHSTATUS") == null) {
                this.setStatus(1);
            }
            super.insert(_currUser);
        }
    }

    public boolean logicalDelete(User _currUser) throws WCMException {
        return this.doLogicalDelete(_currUser, true);
    }

    public boolean logicalUndelete(User _currUser) throws WCMException {
        return this.doLogicalDelete(_currUser, false);
    }

    private boolean doLogicalDelete(User _currUser, boolean _bDeleted) throws WCMException {
        if (!this.isValidInstance()) {
            return false;
        }
        boolean bLockedByMe = false;
        try {
            if (this.isDeleted() == _bDeleted) {
                return true;
            }
            if (!this.canEdit(_currUser)) {
                return false;
            }
            bLockedByMe = true;
            this.setDeleted(_bDeleted);
            this.update(_currUser);
            return true;
        }
        catch (Exception ex) {
            if (bLockedByMe) {
                try {
                    this.cancelUpdate(_currUser);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new WCMException(1100, I18NMessage.get(Schedule.class, "Schedule.label18", "\u903b\u8f91\u5220\u9664\u8ba1\u5212\u5931\u8d25\uff08Schedule.logicalDelete\uff09"), ex);
        }
    }

    @Override
    public synchronized Object clone() {
        Schedule newObj = (Schedule)super.clone();
        newObj.dtAddList = (CMyDateTime)this.dtAddList.clone();
        return newObj;
    }

    public boolean isFinished() {
        return this.getStatus() >= 7;
    }

    public static final Schedule findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (Schedule)BaseObj.findById(Schedule.class, _nId);
    }

    public static final Schedule createNewInstance() throws WCMException {
        return (Schedule)BaseObj.createNewInstance(Schedule.class);
    }

    public static final Schedule findByKey(Object _oKey) throws WCMException {
        return (Schedule)BaseObj.findByKey(Schedule.class, _oKey);
    }

    public static final Schedule findBySender(int _nWorkerId, BaseObj _currSender) throws WCMException {
        String sWhere = "OpType=? and SenderType=? and SenderId=?";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.addSearchValues(_nWorkerId);
        aFilter.addSearchValues(_currSender.getWCMType());
        aFilter.addSearchValues(_currSender.getId());
        aFilter.setMaxRowNumber(1);
        Schedules aSchedules = Schedules.openWCMObjs(User.getSystem(), aFilter);
        if (aSchedules.isEmpty()) {
            return null;
        }
        return (Schedule)aSchedules.getAt(0);
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(Schedule.class, "Schedule.label19", "[\u8ba1\u5212\u4efb\u52a1-") + this.getId() + "]";
    }
}

