/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.calendar;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.calendar.Event;
import com.trs.components.common.job.Schedule;
import com.trs.components.common.job.Schedules;
import com.trs.components.common.message.MessageServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyString;

public class EventLCListenerForRemind
implements IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!this.isListening(_oObjDeleted)) {
            return;
        }
        Event event = (Event)_oObjDeleted;
        int nMsgId = event.getRemindMsgId();
        if (nMsgId <= 0) {
            return;
        }
        MessageServer.delete(this.getLoginUser(), "" + nMsgId);
        String sName = CMyString.filterForSQL(I18NMessage.get(EventLCListenerForRemind.class, "EventLCListenerForRemind.label1", "\u5b9a\u65f6\u53d1\u9001\u6d88\u606f[") + nMsgId + "]");
        Schedule schedule = this.findByName(sName);
        if (schedule != null) {
            schedule.delete(this.getLoginUser());
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        if (!this.isListening(_oObjModified)) {
            return;
        }
        Event event = (Event)_oObjModified;
        int nMsgId = event.getRemindMsgId();
        if (nMsgId <= 0) {
            return;
        }
        boolean bChangedStartime = event.isChangeProperty("ESTART");
        boolean bChangedAheadTime = event.isChangeProperty("AHEADREMDTIME");
        if (!bChangedAheadTime && !bChangedStartime) {
            return;
        }
        int aheadTime = 0;
        aheadTime = bChangedAheadTime ? event.getNewPropertyAsInt("AHEADREMDTIME", 0) : event.getAheadRemindTime();
        CMyDateTime start = null;
        start = bChangedStartime ? (CMyDateTime)event.getNewProperty("ESTART") : event.getStartTime();
        CMyDateTime excuteTime = (CMyDateTime)start.clone();
        try {
            excuteTime = excuteTime.dateAdd(5, aheadTime * -1);
        }
        catch (CMyException e) {
            e.printStackTrace();
        }
        String sName = CMyString.filterForSQL(I18NMessage.get(EventLCListenerForRemind.class, "EventLCListenerForRemind.label1", "\u5b9a\u65f6\u53d1\u9001\u6d88\u606f[") + nMsgId + "]");
        Schedule schedule = this.findByName(sName);
        if (schedule != null) {
            schedule.canEdit(this.getLoginUser());
            schedule.setExeTime(excuteTime);
            schedule.save(this.getLoginUser());
        }
    }

    private boolean isListening(BaseObj _object) {
        return _object != null && _object instanceof Event;
    }

    private Schedule findByName(String _sName) throws WCMException {
        WCMFilter aFilter = new WCMFilter("", "SCHNAME='" + _sName + "'", "");
        aFilter.setMaxRowNumber(1);
        Schedules schedules = Schedules.openWCMObjs(this.getLoginUser(), aFilter);
        if (schedules.isEmpty()) {
            return null;
        }
        return (Schedule)schedules.getAt(0);
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

