/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.comment.domain;

import com.trs.components.comment.domain.SignUtil;
import com.trs.infra.I18NMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;

public class NewsComment {
    private int m_iNewsID;
    private int m_iSiteID;
    private int m_iChannelID;
    private int m_iLimitCode;
    private String m_sNewsTitle;
    private String m_sDataWithSign;
    private int m_nTopicId;
    private String m_sTopicTitle;
    private String m_sAdditionalData;

    public NewsComment() {
        this.m_iNewsID = 0;
        this.m_iSiteID = 0;
        this.m_iChannelID = 0;
        this.m_iLimitCode = 0;
        this.m_sNewsTitle = null;
        this.m_nTopicId = 0;
        this.m_sTopicTitle = null;
        this.m_sDataWithSign = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewsComment(String s) throws Exception {
        ByteArrayInputStream bis = null;
        FilterInputStream is = null;
        try {
            byte[] buff = s.getBytes("ISO8859_1");
            SignUtil su = SignUtil.getVerify();
            buff = su.decodeRadix64(buff);
            bis = new ByteArrayInputStream(buff);
            is = new DataInputStream(bis);
            this.m_iNewsID = ((DataInputStream)is).readInt();
            this.m_iSiteID = ((DataInputStream)is).readInt();
            this.m_iChannelID = ((DataInputStream)is).readInt();
            this.m_iLimitCode = ((DataInputStream)is).readInt();
            this.m_sNewsTitle = ((DataInputStream)is).readUTF();
            this.m_nTopicId = ((DataInputStream)is).readInt();
            this.m_sTopicTitle = ((DataInputStream)is).readUTF();
            this.m_sAdditionalData = ((DataInputStream)is).readUTF();
            if (!su.verify(buff, ((DataInputStream)is).readInt())) {
                throw new Exception("sign error");
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDataWithSign() throws Exception {
        if (this.m_sDataWithSign == null) {
            if (this.m_iSiteID <= 0) {
                throw new Exception("setSiteId must call");
            }
            if (this.m_iChannelID <= 0) {
                throw new Exception("setChannelId must call");
            }
            if (this.m_sNewsTitle == null) {
                throw new Exception("setNewsTitle must call");
            }
            if (this.m_sTopicTitle == null) {
                this.m_sTopicTitle = "";
            }
            if (this.m_sAdditionalData == null) {
                this.m_sAdditionalData = "";
            }
            SignUtil su = SignUtil.getSign();
            ByteArrayOutputStream bos = null;
            FilterOutputStream dos = null;
            try {
                bos = new ByteArrayOutputStream(512);
                dos = new DataOutputStream(bos);
                ((DataOutputStream)dos).writeInt(this.m_iNewsID);
                ((DataOutputStream)dos).writeInt(this.m_iSiteID);
                ((DataOutputStream)dos).writeInt(this.m_iChannelID);
                ((DataOutputStream)dos).writeInt(this.m_iLimitCode);
                ((DataOutputStream)dos).writeUTF(this.m_sNewsTitle);
                ((DataOutputStream)dos).writeInt(this.m_nTopicId);
                ((DataOutputStream)dos).writeUTF(this.m_sTopicTitle);
                ((DataOutputStream)dos).writeUTF(this.m_sAdditionalData);
                ((DataOutputStream)dos).flush();
                byte[] buff = su.sign(bos.toByteArray());
                ((DataOutputStream)dos).writeInt(buff.length);
                dos.write(buff);
                ((DataOutputStream)dos).flush();
            }
            finally {
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (Exception exception) {}
                }
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.m_sDataWithSign = su.encodeRadix64(bos.toByteArray());
        }
        return this.m_sDataWithSign;
    }

    public static void main(String[] args) {
        try {
            NewsComment nc = new NewsComment();
            nc.setNewsId(1);
            nc.setSiteId(1);
            nc.setChannelId(1);
            nc.setLimit(1);
            nc.setNewsTitle(I18NMessage.get(NewsComment.class, "NewsComment.label1", "\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5\u6d4b\u8bd5"));
            nc.setAdditionalData("5;JS;TIME");
            String s = nc.getDataWithSign();
            System.out.println(s);
            NewsComment nc2 = new NewsComment("AAACZQAAAAEAAAAJAAAAAQAv5bm_5bee5byA5aeL56uL6aG556CU56m25a2m55Sf572R57uc6K-t6KiAYWFhZWUAAAAAAAAACTU7SlM7VElNRQAAAC4wLAIUJO1Jv44ZpJvjNJATq_8cgUyoaC8CFA7vOM4EDptmopykvACXk0AuN6oy");
            System.out.println(nc);
            System.out.println(nc2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setChannelId(int iChannelID) {
        this.m_iChannelID = iChannelID;
        this.m_sDataWithSign = null;
    }

    public void setLimit(int iLimit) {
        this.m_iLimitCode = iLimit;
        this.m_sDataWithSign = null;
    }

    public void setNewsId(int iNewsID) {
        this.m_iNewsID = iNewsID;
        this.m_sDataWithSign = null;
    }

    public void setNewsTitle(String strNewsTitle) {
        this.m_sNewsTitle = strNewsTitle;
        this.m_sDataWithSign = null;
    }

    public void setSiteId(int iSiteID) {
        this.m_iSiteID = iSiteID;
        this.m_sDataWithSign = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append("SiteID:");
        sb.append(this.m_iSiteID);
        sb.append(",ChannelID:");
        sb.append(this.m_iChannelID);
        sb.append(",NewsID:");
        sb.append(this.m_iNewsID);
        sb.append(",Limit:");
        sb.append(this.m_iLimitCode);
        sb.append(",NewsTitle:");
        sb.append(this.m_sNewsTitle);
        sb.append(",IsTopic?:");
        sb.append(this.m_nTopicId);
        sb.append(",TopicTitle:");
        sb.append(this.m_sTopicTitle);
        sb.append(",AdditionalData:");
        sb.append(this.m_sAdditionalData);
        return sb.toString();
    }

    public int getTopicId() {
        return this.m_nTopicId;
    }

    public void setTopicId(int topicId) {
        this.m_nTopicId = topicId;
    }

    public String getTopicTitle() {
        return this.m_sTopicTitle;
    }

    public void setTopicTitle(String topicTitle) {
        this.m_sTopicTitle = topicTitle;
    }

    public String getAdditionalData() {
        return this.m_sAdditionalData;
    }

    public void setAdditionalData(String additionalData) {
        this.m_sAdditionalData = additionalData;
    }

    public static boolean isValidContentType(String _sConType) {
        return (_sConType = _sConType.toUpperCase()).equals("JS") || _sConType.equals("XML") || _sConType.equals("TEXT");
    }

    public static boolean isValidTopRange(String _sTopRan) {
        return (_sTopRan = _sTopRan.toUpperCase()).equals("TIME") || _sTopRan.equals("HIT");
    }

    public class CommentEmitEnum {
        public static final String TYPE_JS = "JS";
        public static final String TYPE_XML = "XML";
        public static final String TYPE_TEXT = "TEXT";
        public static final String TYPE_DEFAULT = "JS";
        public static final String RANGE_TIME = "TIME";
        public static final String RANGE_HIT = "HIT";
        public static final String RANGE_DEFAULT = "TIME";
        public static final int STYLE_IPDISPLAY_COMPLETE = 0;
        public static final int STYLE_IPDISPLAY_HIDDENLAST = 1;
        public static final int STYLE_IPDISPLAY_HIDDENALL = 2;
        public static final int STYLE_IPDISPLAY_DEFAULT = 1;
    }
}

