/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.ckm;

import com.trs.components.ckm.TRSCKMServer;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import org.apache.log4j.Logger;

public class DocumentLCListenerForSIMSearch
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(DocumentLCListenerForSIMSearch.class);

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) {
        if (!(_oObjAdded instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForSIMSearch.class, "DocumentLCListenerForSIMSearch.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjAdded.getClass() + I18NMessage.get(DocumentLCListenerForSIMSearch.class, "DocumentLCListenerForSIMSearch.label2", "]\u7684\u65b0\u589e\uff01")));
            return;
        }
        if (!TRSCKMServer.getInstance().isEnableSimSearch()) {
            return;
        }
        Document doc = (Document)_oObjAdded;
        if (doc.getType() == 20 || doc.getType() == 10) {
            TRSCKMServer.getInstance().updateSimIndex(doc);
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) {
        if (!(_oObjDeleted instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForSIMSearch.class, "DocumentLCListenerForSIMSearch.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjDeleted.getClass() + I18NMessage.get(DocumentLCListenerForSIMSearch.class, "DocumentLCListenerForSIMSearch.label3", "]\u7684\u5220\u9664\uff01")));
            return;
        }
        if (!TRSCKMServer.getInstance().isEnableSimSearch()) {
            return;
        }
        Document doc = (Document)_oObjDeleted;
        if (doc.getType() == 20 || doc.getType() == 10) {
            TRSCKMServer.getInstance().deleteSimIndex(doc);
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) {
        if (!(_oObjModified instanceof Document)) {
            logger.error((Object)("Listener[" + this.getClass() + I18NMessage.get(DocumentLCListenerForSIMSearch.class, "DocumentLCListenerForSIMSearch.label1", "]\u4e0d\u80fd\u76d1\u542c\u5bf9\u8c61[") + _oObjModified.getClass() + I18NMessage.get(DocumentLCListenerForSIMSearch.class, "DocumentLCListenerForSIMSearch.label4", "]\u7684\u4fee\u6539\uff01")));
            return;
        }
        if (!TRSCKMServer.getInstance().isEnableSimSearch()) {
            return;
        }
        Document doc = (Document)_oObjModified;
        if (doc.getType() == 20 || doc.getType() == 10) {
            if (!doc.isChangeProperty("DOCCONTENT")) {
                return;
            }
            TRSCKMServer.getInstance().updateSimIndex(doc.getId(), doc.getNewPropertyAsString("DOCCONTENT"));
        }
    }
}

