/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.engine.FlowContentHelper;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import org.apache.log4j.Logger;

public class FlowParamers {
    private static Logger logger = Logger.getLogger(FlowParamers.class);
    private User m_oPostUser = null;
    private Users m_oToUsers = null;
    private int m_nNotifyType = -1;
    private String m_sOpinion = null;
    private FlowNode m_oNextNode = null;
    private FlowNode m_oPreNode = null;
    private int m_iDirection = 1;
    private IFlowContent m_oFlowContent = null;
    private FlowNodeBranch m_oBranch = null;
    private FlowDoc m_oCurrFlowDoc = null;

    public IFlowContent getFlowContent() {
        return this.m_oFlowContent;
    }

    public void setFlowContent(IFlowContent flowContent) throws WCMException {
        if (flowContent == null) {
            throw new WCMException(I18NMessage.get(FlowParamers.class, "FlowParamers.label1", "\u6ca1\u6709\u6307\u5b9a\u5185\u5bb9\u5bf9\u8c61\uff01"));
        }
        this.m_oFlowContent = flowContent;
    }

    public void setFlowContent(int _nContentType, int _nContentId) throws WCMException {
        this.m_oFlowContent = FlowContentHelper.createFlowContent(_nContentType, _nContentId);
    }

    public FlowNode getNextNode() {
        return this.m_oNextNode;
    }

    public void setNextNode(FlowNode nextNode) throws WCMException {
        if (nextNode == null) {
            throw new WCMException(I18NMessage.get(FlowParamers.class, "FlowParamers.label2", "\u6ca1\u6709\u6307\u5b9a\u4e0b\u4e00\u4e2a\u8282\u70b9"));
        }
        this.m_oNextNode = nextNode;
    }

    public void setNextNode(int _nNextNodeId) throws WCMException {
        this.setNextNode(FlowNode.findById(_nNextNodeId));
    }

    public FlowNode getPreNode() {
        return this.m_oPreNode;
    }

    public void setPreNode(FlowNode preNode) throws WCMException {
        if (preNode == null) {
            throw new WCMException(I18NMessage.get(FlowParamers.class, "FlowParamers.label3", "\u6ca1\u6709\u6307\u5b9a\u524d\u4e00\u4e2a\u8282\u70b9"));
        }
        this.m_oPreNode = preNode;
    }

    public void setPreNode(int _nPreNodeId) throws WCMException {
        this.setPreNode(FlowNode.findById(_nPreNodeId));
    }

    public int getDirection() {
        return this.m_iDirection;
    }

    public void setDirection(int iDirect) {
        if (iDirect == 1 || iDirect == 2) {
            this.m_iDirection = iDirect;
        }
    }

    public Users getToUsers() {
        if (this.m_oToUsers == null || this.m_oToUsers.isEmpty()) {
            try {
                this.m_oToUsers = this.m_oNextNode.getOperUsers(User.getSystem(), true);
            }
            catch (Exception e) {
                logger.error((Object)I18NMessage.get(FlowParamers.class, "FlowParamers.label4", "\u83b7\u53d6\u5904\u7406\u7528\u6237\u5931\u8d25\uff01"), (Throwable)e);
            }
        }
        return this.m_oToUsers;
    }

    public void setToUsers(Users users) {
        this.m_oToUsers = users;
    }

    public void setToUsers(String _sUserIds) throws WCMException {
        this.setToUsers(Users.findByIds(User.getSystem(), _sUserIds));
    }

    public int getNotifyType() {
        return this.m_nNotifyType;
    }

    public void setNotifyType(int _nNotifyType) {
        this.m_nNotifyType = _nNotifyType;
    }

    public String getOpinion() {
        return this.m_sOpinion;
    }

    public void setOpinion(String opinion) {
        this.m_sOpinion = opinion;
    }

    public User getPostUser() {
        return this.m_oPostUser;
    }

    public void setPostUser(User postUser) {
        this.m_oPostUser = postUser;
    }

    public void validate() throws WCMException {
        FlowNodeBranch branch;
        if (this.m_oFlowContent == null) {
            throw new WCMException(I18NMessage.get(FlowParamers.class, "FlowParamers.label5", "\u6ca1\u6709\u6307\u5b9a\u5904\u7406\u7684\u5185\u5bb9\uff01"));
        }
        if (this.m_oPostUser == null) {
            throw new WCMException(I18NMessage.get(FlowParamers.class, "FlowParamers.label6", "\u6ca1\u6709\u6307\u5b9a\u5448\u9001\u8005\uff01"));
        }
        if (this.m_oNextNode == null) {
            throw new WCMException(I18NMessage.get(FlowParamers.class, "FlowParamers.label7", "\u6ca1\u6709\u6307\u5b9a\u4e0b\u4e00\u4e2a\u8282\u70b9\uff01"));
        }
        if (!this.m_oNextNode.isStartNode() && this.m_oPreNode == null) {
            throw new WCMException(I18NMessage.get(FlowParamers.class, "FlowParamers.label8", "\u6ca1\u6709\u6307\u5b9a\u524d\u4e00\u4e2a\u8282\u70b9\uff01"));
        }
        if (this.m_oToUsers == null || this.m_oToUsers.isEmpty()) {
            this.m_oToUsers = this.m_oNextNode.getOperUsers(this.m_oPostUser, true);
        }
        if (this.m_oNextNode.isToFirst() || this.m_oNextNode.isEndNode()) {
            this.m_oToUsers.addElement(this.m_oFlowContent.getCrUser());
        }
        if (this.m_nNotifyType == -1 && this.m_oPreNode != null && (branch = this.m_oPreNode.getBranchTo(User.getSystem(), this.m_oNextNode)) != null) {
            this.m_nNotifyType = branch.getNotify();
        }
    }

    public FlowNodeBranch getBranch() throws WCMException {
        if (this.m_oBranch != null) {
            return this.m_oBranch;
        }
        if (this.getPreNode() == null) {
            return null;
        }
        this.m_oBranch = this.getPreNode().getBranchTo(User.getSystem(), this.getNextNode());
        return this.m_oBranch;
    }

    protected void setBranch(FlowNodeBranch branch) {
        this.m_oBranch = branch;
    }

    public FlowDoc getCurrFlowDoc() {
        return this.m_oCurrFlowDoc;
    }

    public void setCurrFlowDoc(FlowDoc currFlowDoc) {
        this.m_oCurrFlowDoc = currFlowDoc;
    }
}

