/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.config;

import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.IInitValueCreator;
import com.trs.cms.process.engine.IToUsersCreator;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ToUsersCreatorConfig {
    public static final String ATTRIBUTES_DILIM = ";";
    private static Logger logger = Logger.getLogger(ToUsersCreatorConfig.class);
    private Map m_mapAttributes = null;
    private String m_sName = null;
    private String m_sClassName = null;
    private Class m_oClass = null;
    private IToUsersCreator m_oCreator = null;

    public String getClassName() {
        return this.m_sClassName;
    }

    public void setClassName(String className) throws WCMException {
        if (className == null || className.length() == 0) {
            throw new WCMException(1106, I18NMessage.get(ToUsersCreatorConfig.class, "ToUsersCreatorConfig.label1", "\u6ca1\u6709\u6307\u5b9aClassName\uff01"));
        }
        this.m_sClassName = className;
        try {
            this.m_oClass = Class.forName(className);
        }
        catch (Exception e) {
            throw new WCMException(13, className + I18NMessage.get(ToUsersCreatorConfig.class, "ToUsersCreatorConfig.label2", "-->Class\u6709\u8bef\uff01"), e);
        }
        try {
            if (!(this.m_oClass.newInstance() instanceof IToUsersCreator) && !(this.m_oClass.newInstance() instanceof IInitValueCreator)) {
                throw new WCMException(2, className + I18NMessage.get(ToUsersCreatorConfig.class, "ToUsersCreatorConfig.label3", "\u4e0d\u662f") + IToUsersCreator.class.getName() + I18NMessage.get(ToUsersCreatorConfig.class, "ToUsersCreatorConfig.label4", "\u6216\u8005") + IInitValueCreator.class.getName() + I18NMessage.get(ToUsersCreatorConfig.class, "ToUsersCreatorConfig.label5", "\u7684\u5b9e\u73b0\uff01"));
            }
        }
        catch (Exception e) {
            throw new WCMException(12, className + I18NMessage.get(ToUsersCreatorConfig.class, "ToUsersCreatorConfig.label6", ".newInstance\u6709\u8bef\uff01"), e);
        }
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String name) {
        this.m_sName = name;
    }

    public void setAttribute(String _sName, String _sValue) {
        if (this.m_mapAttributes == null) {
            this.m_mapAttributes = new HashMap(1);
        }
        this.m_mapAttributes.put(_sName.toUpperCase(), _sValue);
    }

    public String getAttribute(String _sName) {
        if (this.m_mapAttributes == null) {
            return null;
        }
        return (String)this.m_mapAttributes.get(_sName.toUpperCase());
    }

    public Users getToUsers(FlowContext _context) throws WCMException {
        IToUsersCreator creator = this.getCreatorInstance();
        if (creator != null) {
            return creator.createToUsers(_context, this);
        }
        return new Users(null, 1, 1);
    }

    public Group getGroupRange(FlowContext _context) throws WCMException {
        IToUsersCreator creator = this.getCreatorInstance();
        Group result = null;
        if (creator != null && creator.isRangedFromGroup()) {
            result = creator.getGroupRange(_context, this);
        }
        return result;
    }

    private IToUsersCreator getCreatorInstance() {
        if (this.m_oCreator == null) {
            try {
                this.m_oCreator = (IToUsersCreator)this.m_oClass.newInstance();
            }
            catch (Exception ex) {
                logger.warn((Object)("Creator[" + this.m_oClass.getName() + I18NMessage.get(ToUsersCreatorConfig.class, "ToUsersCreatorConfig.label7", "]\u5b9e\u4f8b\u5316\u5931\u8d25\uff01")), (Throwable)ex);
            }
        }
        return this.m_oCreator;
    }

    public void setAttributes(String _sParams) {
        if (CMyString.isEmpty(_sParams)) {
            return;
        }
        StringTokenizer stAttributes = null;
        stAttributes = new StringTokenizer(_sParams, ATTRIBUTES_DILIM);
        while (stAttributes.hasMoreElements()) {
            String sTemp = stAttributes.nextToken();
            int nPose = sTemp.indexOf("=");
            if (nPose <= 0) continue;
            String sName = sTemp.substring(0, nPose);
            String sValue = sTemp.substring(nPose + 1);
            this.setAttribute(sName, sValue);
        }
    }
}

