/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowNotifyWorker;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodeBranchs;
import com.trs.cms.process.engine.FlowContentHelper;
import com.trs.cms.process.engine.FlowContextOld;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.cms.process.engine.FlowDocBak;
import com.trs.cms.process.engine.FlowDocBaks;
import com.trs.cms.process.engine.FlowDocs;
import com.trs.cms.process.engine.FlowParamers;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class FlowServer
extends BaseServer {
    private static Logger s_logger = Logger.getLogger(FlowServer.class);
    public static boolean IS_DEBUG = false;
    Hashtable hFlowDocs = new Hashtable();
    Hashtable hConditionBeans = new Hashtable();
    Hashtable hOperateBeans = new Hashtable();
    IFlowNotifyWorker m_oNotify = null;

    public FlowServer() {
        try {
            this.m_oNotify = (IFlowNotifyWorker)DreamFactory.createObjectById("Flow.Notify.Worker");
        }
        catch (Throwable e) {
            this.m_oNotify = null;
        }
    }

    public static FlowServer getFlowServer() throws WCMException {
        FlowServer aFlowServer = (FlowServer)DreamFactory.createObjectById("FlowServer");
        if (aFlowServer == null) {
            throw new WCMException(I18NMessage.get(FlowServer.class, "FlowServer.label1", "FlowServer\u5728\u5de5\u5382\u4e2d\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!aFlowServer.isStarted()) {
            aFlowServer.startup();
        }
        return aFlowServer;
    }

    private String makeTrialCacheKey(FlowDoc _flowDoc) {
        return this.makeTrialCacheKey(_flowDoc.getContentType(), _flowDoc.getContentId());
    }

    private String makeTrialCacheKey(int _nObjType, int _nObjId) {
        return _nObjType + "." + _nObjId;
    }

    private void putFlowDocIntoBuffer(FlowDoc _flowDoc) {
        this.hFlowDocs.put(this.makeTrialCacheKey(_flowDoc), _flowDoc);
    }

    private void putFlowDocIntoBuffer(FlowDoc _flowDoc, User _currUser) {
        IFlowContent currFlowContent = null;
        try {
            currFlowContent = FlowContentHelper.createFlowContent(_flowDoc.getContentType(), _flowDoc.getId());
        }
        catch (WCMException ex) {
            s_logger.error((Object)(I18NMessage.get(FlowServer.class, "FlowServer.label2", "\u6d41\u8f6c\u6587\u6863\u5931\u8d25\uff01\u83b7\u53d6FlowContent\u51fa\u73b0\u5f02\u5e38\uff01 Type\uff1a[") + _flowDoc.getContentType() + "] Id\uff1a[" + _flowDoc.getContentId() + "]"), (Throwable)ex);
        }
        if (currFlowContent == null) {
            s_logger.error((Object)(I18NMessage.get(FlowServer.class, "FlowServer.label3", "\u6d41\u8f6c\u6587\u6863\u5931\u8d25\uff01\u627e\u4e0d\u5230\u6307\u5b9a\u7684FlowContent Type\uff1a[") + _flowDoc.getContentType() + "] Id\uff1a[" + _flowDoc.getContentId() + "]"));
            return;
        }
        this.hFlowDocs.put(this.makeTrialCacheKey(_flowDoc), _flowDoc);
        try {
            FlowNode currNode = _flowDoc.getNode();
            User currUser = User.getSystem();
            if (_currUser != null) {
                currUser = _currUser;
            }
            FlowContextOld flowContextOld = new FlowContextOld(currFlowContent, currNode, currUser);
        }
        catch (Exception ex) {
            s_logger.error((Object)(I18NMessage.get(FlowServer.class, "FlowServer.label4", "\u5904\u7406\u8282\u70b9\u8fdb\u5165\u540e\u7684\u4e8b\u4ef6\u5931\u8d25\uff01FlowDoc\u7684ID\u4e3a[") + _flowDoc.getId() + "]"), (Throwable)ex);
        }
    }

    private FlowServer start() throws WCMException {
        return this;
    }

    public FlowDoc getFlowDoc(int _nObjType, int _nObjId) {
        FlowDoc aFlowDoc = (FlowDoc)this.hFlowDocs.get(this.makeTrialCacheKey(_nObjType, _nObjId));
        return aFlowDoc;
    }

    public FlowDoc getFlowDoc(IFlowContent _content) throws WCMException {
        if (_content == null) {
            throw new WCMException(10, I18NMessage.get(FlowServer.class, "FlowServer.label6", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61\uff08JobServer.getFlowDoc\uff09"));
        }
        return this.getFlowDoc(_content.getContentType(), _content.getSubinstanceId());
    }

    public FlowDoc removeFlowDoc(int _nObjType, int _nObjId) throws WCMException {
        return this.removeFlowDoc(_nObjType, _nObjId, User.getSystem());
    }

    public FlowDoc removeFlowDoc(int _nObjType, int _nObjId, User _currUser) throws WCMException {
        FlowDoc delFlowDoc = (FlowDoc)this.hFlowDocs.remove(this.makeTrialCacheKey(_nObjType, _nObjId));
        if (delFlowDoc == null) {
            return null;
        }
        FlowNode currNode = delFlowDoc.getNode();
        User currUser = _currUser;
        if (currUser == null) {
            currUser = User.getSystem();
        }
        String sSQL = "update WCMFlowDocBak set Flag=" + delFlowDoc.getFlag() + " where ObjType=" + delFlowDoc.getContentType() + " and Objid=" + delFlowDoc.getContentId() + " and (flag=" + 1 + " or flag=" + 2 + ")";
        DBManager.getDBManager().sqlExecuteUpdate(sSQL);
        delFlowDoc.delete(currUser);
        IFlowContent currFlowContent = FlowContentHelper.createFlowContent(_nObjType, _nObjId);
        FlowContextOld currContext = new FlowContextOld(currFlowContent, currNode, currUser);
        if (currNode != null) {
            // empty if block
        }
        return delFlowDoc;
    }

    public FlowDoc removeFlowDoc(IFlowContent _doc, User _currUser) throws WCMException {
        if (_doc == null) {
            throw new WCMException(10, I18NMessage.get(FlowServer.class, "FlowServer.label7", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61\uff08FlowServer.removeFlowDoc\uff09"));
        }
        return this.removeFlowDoc(_doc.getContentType(), _doc.getSubinstanceId(), _currUser);
    }

    public FlowDoc removeFlowDoc(IFlowContent _doc) throws WCMException {
        if (_doc == null) {
            throw new WCMException(10, I18NMessage.get(FlowServer.class, "FlowServer.label7", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61\uff08FlowServer.removeFlowDoc\uff09"));
        }
        return this.removeFlowDoc(_doc.getContentType(), _doc.getSubinstanceId(), User.getSystem());
    }

    public FlowDoc startContentInFlow(User _currUser, IFlowContent _doc) throws WCMException {
        return this.startContentInFlow(_currUser, _doc, I18NMessage.get(FlowServer.class, "FlowServer.label8", "\u7cfb\u7edf\u81ea\u52a8\u63d0\u4ea4"));
    }

    public boolean isCanInFlow(IFlowContent _content) throws WCMException {
        Flow currFlow = _content.getOwnerFlow();
        if (currFlow == null) {
            return false;
        }
        FlowDoc currFlowDoc = this.getFlowDoc(_content);
        return currFlowDoc == null;
    }

    public FlowDoc startContentInFlow(User _currUser, IFlowContent _content, String _sPostDesc) throws WCMException {
        FlowNodeBranch branch;
        if (_content == null) {
            throw new WCMException(10, I18NMessage.get(FlowServer.class, "FlowServer.label9", "\u6307\u5b9a\u6587\u6863\u5bf9\u8c61\u65e0\u6548\uff08FlowServer.addFlowDoc\uff09"));
        }
        Flow currFlow = _content.getOwnerFlow();
        if (currFlow == null) {
            return null;
        }
        FlowDoc currFlowDoc = this.getFlowDoc(_content);
        if (currFlowDoc != null) {
            s_logger.error((Object)I18NMessage.get(FlowServer.class, "FlowServer.label10", "\u5df2\u7ecf\u5728\u6d41\u8f6c\uff0c\u4e0d\u80fd\u6b63\u5e38\u5f00\u59cb\uff01"));
            return currFlowDoc;
        }
        FlowNode startNode = currFlow.getStartNode();
        FlowNodeBranchs branchs = startNode.getBranchs(_currUser);
        FlowNodeBranch flowNodeBranch = branch = branchs.isEmpty() ? null : (FlowNodeBranch)branchs.getAt(0);
        if (branch == null) {
            return null;
        }
        FlowParamers currParamers = new FlowParamers();
        currParamers.setPostUser(_currUser);
        currParamers.setFlowContent(_content);
        currParamers.setToUsers(Users.createNewInstance(_currUser));
        currParamers.setNextNode(startNode);
        currParamers.setOpinion(_sPostDesc);
        currFlowDoc = this.submitTo(currParamers);
        currParamers = new FlowParamers();
        currParamers.setPostUser(_currUser);
        currParamers.setFlowContent(_content);
        currParamers.setPreNode(startNode);
        currParamers.setNextNode(branch.getNextNode(_currUser));
        currParamers.setOpinion(_sPostDesc);
        currFlowDoc = this.submitTo(currParamers);
        return currFlowDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFlowDoc(FlowParamers _currParamers) throws WCMException {
        if (_currParamers.getNextNode().isStartNode() && _currParamers.getPreNode() == null) {
            return;
        }
        IFlowContent content = _currParamers.getFlowContent();
        FlowDoc flowDoc = null;
        try {
            flowDoc = this.getFlowDoc(content);
            if (flowDoc == null) {
                throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label11", "\u6ca1\u6709\u627e\u5230\u6587\u6863\u5bf9\u5e94\u7684FlowDoc\u5bf9\u8c61\uff08FlowServer.submitDocTo\uff09"));
            }
            if (!flowDoc.canEdit(_currParamers.getPostUser())) {
                throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label12", "\u65e0\u6cd5\u4fee\u6539FlowDoc\u5bf9\u8c61\uff0c\u53ef\u80fd\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4fee\u6539\uff08FlowServer.submitDocTo\uff09"));
            }
            flowDoc.setFlag(5);
            flowDoc.update(_currParamers.getPostUser());
            this.removeFlowDoc(_currParamers.getFlowContent(), _currParamers.getPostUser());
        }
        finally {
            if (flowDoc != null && flowDoc.isLocked()) {
                flowDoc.cancelUpdate(_currParamers.getPostUser());
            }
        }
    }

    private FlowDoc createFlowDoc(FlowParamers _currParamers) throws WCMException {
        FlowNode nextNode = _currParamers.getNextNode();
        FlowDoc newFlowDoc = null;
        newFlowDoc = nextNode.isEndNode() ? new FlowDocBak() : new FlowDoc();
        newFlowDoc.setFlowContent(_currParamers.getFlowContent());
        newFlowDoc.setFlag(nextNode.isEndNode() ? 18 : _currParamers.getDirection());
        newFlowDoc.setPreNode(_currParamers.getPreNode());
        newFlowDoc.setNode(nextNode);
        newFlowDoc.setPostUser(_currParamers.getPostUser());
        newFlowDoc.setPostTime(CMyDateTime.now());
        newFlowDoc.setPostDesc(_currParamers.getOpinion());
        newFlowDoc.setToUsers(_currParamers.getToUsers().getIdListAsString());
        newFlowDoc.insert(_currParamers.getPostUser());
        if (!nextNode.isEndNode()) {
            this.putFlowDocIntoBuffer(newFlowDoc, _currParamers.getPostUser());
        }
        try {
            FlowContextOld flowContextOld = new FlowContextOld(_currParamers.getFlowContent(), nextNode, _currParamers.getPostUser());
        }
        catch (Exception ex) {
            s_logger.error((Object)I18NMessage.get(FlowServer.class, "FlowServer.label13", "\u5904\u7406\u8282\u70b9\u8fdb\u5165\u540e\u7684\u4e8b\u4ef6\u5931\u8d25\uff01"), (Throwable)ex);
        }
        return newFlowDoc;
    }

    public FlowDoc submitTo(FlowParamers _currParamers) throws WCMException {
        if (_currParamers == null) {
            throw new WCMException(I18NMessage.get(FlowServer.class, "FlowServer.label14", "\u6ca1\u6709\u6307\u5b9a\u7684\u5904\u7406\u53c2\u6570\uff01"));
        }
        _currParamers.validate();
        User postUser = _currParamers.getPostUser();
        FlowNodeBranch branch = null;
        IFlowContent content = _currParamers.getFlowContent();
        try {
            this.updateFlowDoc(_currParamers);
            branch = _currParamers.getBranch();
            if (branch != null) {
                content.updateStatus(postUser, branch.getStatusId());
            }
            Users toUsers = _currParamers.getToUsers();
            this.doOpersOnNodeBranch(content, postUser, branch, toUsers, _currParamers.getNotifyType());
            return this.createFlowDoc(_currParamers);
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label15", "\u5448\u4ea4\u6587\u6863\u5230\u6307\u5b9a\u8282\u70b9\u5931\u8d25\uff08FlowServer.submitDocTo\uff09"), ex);
        }
    }

    private void doOpersOnNodeBranch(IFlowContent _content, User _currUser, FlowNodeBranch _branch, Users _toUsers, int _notify) throws Exception {
        if (_toUsers.isEmpty()) {
            return;
        }
        String sTitle = I18NMessage.get(FlowServer.class, "FlowServer.label16", "TRS\u4e1a\u52a1\u8868\u5355\u63d0\u9192-[") + _content.getDesc() + I18NMessage.get(FlowServer.class, "FlowServer.label17", "]\u9700\u8981\u60a8\u5904\u7406");
        String sDesc = "[" + _content.getDesc() + I18NMessage.get(FlowServer.class, "FlowServer.label18", "]\u9700\u8981\u60a8\u5904\u7406!\n\u8bf7\u70b9\u51fb\u4ee5\u4e0b\u94fe\u63a5\u53ef\u4ee5\u76f4\u63a5\u5904\u7406\uff1a\n<a href=\")test\">\u5904\u7406\u5730\u5740</a>\n\u63d0\u4ea4\u4eba\uff1a") + _currUser.getName();
        this.m_oNotify.addMsgEvent(_currUser, _toUsers, sTitle, sDesc, _notify);
    }

    public FlowDoc submitBack(User _currUser, IFlowContent _doc, String _sPostDesc) throws WCMException {
        return this.submitBack(_currUser, _doc, _sPostDesc, 3);
    }

    public FlowDoc submitBack(User _currUser, IFlowContent _content, String _sOpinion, int _nStatusId) throws WCMException {
        if (_content == null) {
            throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label20", "\u6307\u5b9a\u7684\u6587\u6863\u5bf9\u8c61\u65e0\u6548\uff08FlowServer.submitDocTo\uff09"));
        }
        if (!_content.canEdit(_currUser)) {
            throw new WCMException(1013, I18NMessage.get(FlowServer.class, "FlowServer.label21", "\u65e0\u6cd5\u4fee\u6539\u6587\u6863\uff0c\u53ef\u80fd\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4fee\u6539\uff08FlowServer.submitDocTo\uff09"));
        }
        FlowDoc currFlowDoc = null;
        FlowDoc lastFlowDoc = null;
        boolean bLockedByMe = false;
        try {
            currFlowDoc = this.getFlowDoc(_content);
            if (currFlowDoc == null) {
                throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label22", "\u5bf9\u8c61[") + _content.getDesc() + I18NMessage.get(FlowServer.class, "FlowServer.label23", "]\u4e0d\u5728\u6d41\u8f6c\u4e2d\uff01"));
            }
            int iCurNodeID = currFlowDoc.getNodeId();
            FlowDoc prevFlowDoc = currFlowDoc.getPrevious(_currUser, false);
            if (prevFlowDoc.getNodeId() == iCurNodeID) {
                while ((prevFlowDoc = (lastFlowDoc = prevFlowDoc).getPrevious(_currUser, false)).getNodeId() == iCurNodeID) {
                }
            } else {
                lastFlowDoc = currFlowDoc;
            }
            if (!currFlowDoc.canEdit(_currUser)) {
                throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label24", "\u6587\u6863\u5bf9\u5e94\u7684FlowDoc\u5bf9\u8c61\u6b63\u5728\u88ab\u5176\u4ed6\u7528\u6237\u4fee\u6539"));
            }
            bLockedByMe = true;
            currFlowDoc.setFlag(5);
            currFlowDoc.update(_currUser);
            bLockedByMe = false;
            String sBackToUsers = null;
            FlowNode prevNode = prevFlowDoc.getNode();
            if (prevNode.isNeedPostTogether()) {
                int iTogetherNodeID = prevNode.getId();
                FlowDoc firstTogetherDoc = prevFlowDoc;
                FlowDoc beforeTogetherDoc = firstTogetherDoc.getPrevious(_currUser, false);
                while (beforeTogetherDoc.getNodeId() == iTogetherNodeID) {
                    firstTogetherDoc = beforeTogetherDoc;
                    beforeTogetherDoc = firstTogetherDoc.getPrevious(_currUser, false);
                }
                sBackToUsers = firstTogetherDoc.getToUserIds();
            } else {
                sBackToUsers = String.valueOf(lastFlowDoc.getPostUser().getId());
            }
            FlowDoc newFlowDoc = new FlowDoc();
            newFlowDoc.setFlowContent(_content);
            newFlowDoc.setFlag(2);
            newFlowDoc.setPreNode(currFlowDoc.getNodeId());
            newFlowDoc.setNode(prevNode);
            newFlowDoc.setToUsers(sBackToUsers);
            newFlowDoc.setPostUser(_currUser);
            newFlowDoc.setPostDesc(_sOpinion);
            newFlowDoc.setPostTime(CMyDateTime.now());
            this.removeFlowDoc(_content, _currUser);
            newFlowDoc.insert(_currUser);
            this.putFlowDocIntoBuffer(newFlowDoc, _currUser);
            _content.updateStatus(_currUser, _nStatusId);
            this.doOpersWhenSubmitDocBack(_currUser, newFlowDoc);
            FlowDoc flowDoc = newFlowDoc;
            return flowDoc;
        }
        catch (Exception ex) {
            throw new WCMException(1100, I18NMessage.get(FlowServer.class, "FlowServer.label25", "\u6587\u6863\u6253\u56de\u5931\u8d25\uff08FlowServer.submitDocBack\uff09"), ex);
        }
        finally {
            _content.cancelUpdate(_currUser);
            if (bLockedByMe && currFlowDoc != null) {
                currFlowDoc.cancelUpdate(_currUser);
            }
        }
    }

    private void doOpersWhenSubmitDocBack(User _currUser, FlowDoc _newFlowDoc) {
    }

    public void forceDocToEnd(IFlowContent _currDoc, User _currUser) throws Exception {
        FlowDoc currFlowDoc = this.getFlowDoc(_currDoc);
        if (currFlowDoc == null) {
            return;
        }
        if (currFlowDoc.canEdit(User.getSystem())) {
            currFlowDoc.setFlag(7);
            currFlowDoc.update(User.getSystem());
        }
        this.removeFlowDoc(_currDoc, _currUser);
    }

    @Override
    protected void doShutdown() {
    }

    @Override
    protected boolean doStart() throws WCMException {
        this.start();
        return true;
    }

    public static Users getConsignUsers(User _operator, int _nModule) throws WCMException {
        String sNowTime = CMyDateTime.now().toString("yyyy-MM-dd");
        String sTimeSql = "wcmTrusteeInfo.StartTime<=" + DBManager.getDBManager().getDBType().sqlDateTime(sNowTime + " 23:59:59", "YYYY-MM-DD HH24:MI:SS") + " and wcmTrusteeInfo.EndTime>=" + DBManager.getDBManager().getDBType().sqlDateTime(sNowTime + " 00:00:00", "YYYY-MM-DD HH24:MI:SS");
        String sTrusteeWhere = "wcmTrusteeInfo.Status>0 and wcmTrusteeInfo.Trustee=" + _operator.getId() + " and " + sTimeSql + " and wcmTrusteeInfo.Module=" + _nModule;
        Users aUsers = Users.openWCMObjs(User.getSystem(), new WCMFilter("wcmTrusteeInfo", sTrusteeWhere, "", "distinct wcmTrusteeInfo.CrUserId as USERID"));
        return aUsers;
    }

    private String getFlowUserSql(User _operator) throws WCMException {
        String sUserSql = "(" + DBManager.getDBManager().getDBType().sqlConcatStr("','", "wcmFlowDoc.ToUsers", "','") + " like '%," + _operator.getId() + ",%'";
        Users aUsers = FlowServer.getConsignUsers(_operator, 1);
        for (int i = 0; i < aUsers.size(); ++i) {
            User aUser = (User)aUsers.getAt(i);
            if (aUser == null) continue;
            sUserSql = sUserSql + " or " + DBManager.getDBManager().getDBType().sqlConcatStr("','", "wcmFlowDoc.ToUsers", "','") + " like '%," + aUser.getId() + ",%'";
        }
        sUserSql = sUserSql + ")";
        return sUserSql;
    }

    public FlowDocs getFlowDocs(User _operator, int _nFlag, WCMFilter _filter) throws WCMException {
        if (_nFlag == 1 || _nFlag == 2 || _nFlag == 0) {
            String sWhere = "wcmFlowDoc.Flag=" + _nFlag;
            sWhere = sWhere + " and " + this.getFlowUserSql(_operator);
            WCMFilter aFilter = new WCMFilter("", sWhere, "FlowDocId desc");
            if (_filter != null) {
                aFilter.mergeWith(_filter);
            }
            return FlowDocs.openWCMObjs(User.getSystem(), aFilter);
        }
        String sWhere = "WCMFLOWDOCBAK.Flag=" + _nFlag;
        sWhere = sWhere + " and POSTUSER='" + CMyString.filterForSQL(_operator.getName()) + "'";
        WCMFilter aFilter = new WCMFilter("", sWhere, "FlowDocId desc");
        if (_filter != null) {
            aFilter.mergeWith(_filter);
        }
        FlowDocBaks aFlowDocBaks = new FlowDocBaks(_operator);
        aFlowDocBaks.open(aFilter);
        return aFlowDocBaks;
    }

    public FlowDocs getSubmitFlowDocs(User _operator, WCMFilter _filter) throws WCMException {
        String sWhere = " PreNodeId>0 and POSTUSER='" + CMyString.filterForSQL(_operator.getName()) + "'";
        WCMFilter aFilter = new WCMFilter("", sWhere, "FlowDocId desc");
        if (_filter != null) {
            aFilter.mergeWith(_filter);
        }
        FlowDocBaks aFlowDocBaks = new FlowDocBaks(_operator);
        aFlowDocBaks.open(aFilter);
        return aFlowDocBaks;
    }

    public int getCurrFlowFlag(int contentType, int contentId) throws WCMException {
        FlowDoc currFlowDoc = this.getFlowDoc(contentType, contentId);
        if (currFlowDoc != null) {
            return currFlowDoc.getFlag();
        }
        String SQL = "SELECT FLAG FROM WCMFLOWDOCBAK WHERE OBJTYPE=? AND OBJID=? Order by FlowDocId desc";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet aResultSet = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("SELECT FLAG FROM WCMFLOWDOCBAK WHERE OBJTYPE=? AND OBJID=? Order by FlowDocId desc");
            oPreStmt.setMaxRows(1);
            oPreStmt.setInt(1, contentType);
            oPreStmt.setInt(2, contentId);
            aResultSet = oPreStmt.executeQuery();
            if (aResultSet.next()) {
                int n = aResultSet.getInt("FLAG");
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to get Flow Flag!", ex);
        }
        finally {
            if (aResultSet != null) {
                try {
                    aResultSet.close();
                }
                catch (Exception ex) {
                    s_logger.error((Object)"Failed to close resultSet", (Throwable)ex);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    s_logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    public FlowDocs getFlowDocsOfContent(int contentType, int contentId) throws WCMException {
        String sWhere = "PreNodeId>0 and ObjType=" + contentType + " and ObjId=" + contentId;
        WCMFilter aFilter = new WCMFilter("", sWhere, "FlowDocId Desc");
        FlowDocBaks aFlowDocBaks = new FlowDocBaks(ContextHelper.getLoginUser());
        aFlowDocBaks.open(aFilter);
        return aFlowDocBaks;
    }

    public void submitAgain(User user, int flowDocId, String opinion) throws WCMException {
        FlowDoc aFlowDoc = FlowDoc.findById(flowDocId);
        if (aFlowDoc == null || aFlowDoc.getFlag() != 2) {
            return;
        }
        FlowDoc preFlowDoc = aFlowDoc.getPrevious(user, false);
        FlowParamers currParamers = new FlowParamers();
        currParamers.setPostUser(user);
        currParamers.setFlowContent(aFlowDoc.getContentType(), aFlowDoc.getContentId());
        currParamers.setToUsers(preFlowDoc.getToUserIds());
        currParamers.setPreNode(aFlowDoc.getNodeId());
        currParamers.setNextNode(aFlowDoc.getPreNodeId());
        currParamers.setOpinion(opinion);
        this.submitTo(currParamers);
    }
}

