/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process;

import com.trs.DreamFactory;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.config.FlowConfigServer;
import com.trs.cms.process.config.FlowContentTypeConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import org.apache.log4j.Logger;

public class FlowContentFactory {
    private static Logger logger = Logger.getLogger(FlowContentFactory.class);

    public static IFlowContent makeFlowContent(int _nContentType, int _nContentId) throws WCMException {
        FlowConfigServer configServer = (FlowConfigServer)DreamFactory.createObjectById("FlowConfigServer");
        FlowContentTypeConfig contentTypeConfig = configServer.findContentTypeConfig(_nContentType);
        if (contentTypeConfig == null) {
            throw new WCMException(I18NMessage.get(FlowContentFactory.class, "FlowContentFactory.label1", "\u6307\u5b9a\u7684\u7c7b\u578b\u4e0d\u662f\u53ef\u4ee5\u6d41\u8f6c\u7684\u5185\u5bb9\uff01[Type=") + _nContentType + "]");
        }
        try {
            IFlowContent flowContent = (IFlowContent)contentTypeConfig.getContentClass().newInstance();
            flowContent.loadById(_nContentId);
            return flowContent;
        }
        catch (Exception e) {
            logger.warn((Object)(I18NMessage.get(FlowContentFactory.class, "FlowContentFactory.label2", "\u8f7d\u5165\u6d41\u8f6c\u5185\u5bb9\u5931\u8d25\uff01[Type=") + _nContentType + ",Id=" + _nContentId + I18NMessage.get(FlowContentFactory.class, "FlowContentFactory.label3", "], \u539f\u56e0\u4e3a\uff1a") + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static IFlowContent makeFlowContent(CMSObj _substance) throws WCMException {
        FlowConfigServer configServer = (FlowConfigServer)DreamFactory.createObjectById("FlowConfigServer");
        FlowContentTypeConfig contentTypeConfig = configServer.findContentTypeConfig(_substance.getWCMType());
        if (contentTypeConfig == null) {
            throw new WCMException(I18NMessage.get(FlowContentFactory.class, "FlowContentFactory.label1", "\u6307\u5b9a\u7684\u7c7b\u578b\u4e0d\u662f\u53ef\u4ee5\u6d41\u8f6c\u7684\u5185\u5bb9\uff01[Type=") + _substance.getWCMType() + ", ObjectInfo=" + _substance + "]");
        }
        try {
            IFlowContent flowContent = (IFlowContent)contentTypeConfig.getContentClass().newInstance();
            flowContent.makeFrom(_substance);
            return flowContent;
        }
        catch (Exception e) {
            throw new WCMException(I18NMessage.get(FlowContentFactory.class, "FlowContentFactory.label2", "\u8f7d\u5165\u6d41\u8f6c\u5185\u5bb9\u5931\u8d25\uff01[Type=") + _substance.getWCMType() + ",Id=" + _substance.getId() + ", ObjectInfo=" + _substance + "]", e);
        }
    }
}

