/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.inherit;

import com.trs.cms.inherit.IChannelInherit;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.infra.I18NMessage;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ChannelInheritFactory {
    private static Logger logger = Logger.getLogger(ChannelInheritFactory.class);
    private static ChannelInheritFactory channelInheritFactory = null;
    private List<IChannelInherit> channelInherList = null;
    private Properties properties = null;
    private static String propertiesPath = "inherit.properties";

    private ChannelInheritFactory() {
    }

    public void inherit(BaseChannel parent, BaseChannel childChannl) {
        if (this.channelInherList == null) {
            this.init();
        }
        for (int i = 0; i < this.channelInherList.size(); ++i) {
            int inherit;
            IChannelInherit channelInherit = this.channelInherList.get(i);
            int temp = (int)Math.pow(2.0, channelInherit.getPos() - 1);
            if ((temp & (inherit = parent.getPropertyAsInt("INHERIT", 0))) == 0) continue;
            channelInherit.doInherit(parent, childChannl);
        }
    }

    private void init() {
        if (this.channelInherList == null) {
            this.channelInherList = new ArrayList<IChannelInherit>();
        }
        if (this.properties == null) {
            this.properties = this.loadProperties();
        }
        Iterator iterator = WCMDiscoveryFactory.getDiscovery().getImplementors("com.trs.cms.inherit.IChannelInherit");
        while (iterator != null && iterator.hasNext()) {
            String sClazz = (String)iterator.next();
            try {
                IChannelInherit channelInerit = (IChannelInherit)Class.forName(sClazz).newInstance();
                String classInfo = new String(this.properties.getProperty(sClazz).getBytes("iso-8859-1"), "utf-8");
                String[] tempInfo = classInfo.split(",");
                channelInerit.setPos(Integer.parseInt(tempInfo[0].trim()));
                channelInerit.setDesc(tempInfo[1]);
                this.channelInherList.add(channelInerit);
            }
            catch (Exception e) {
                logger.error((Object)I18NMessage.get(ChannelInheritFactory.class, "ChannelInheritFactory", "\u52a0\u8f7d\u7c7b\u5931\u8d25\uff01"), (Throwable)e);
            }
        }
    }

    private Properties loadProperties() {
        Properties props = new Properties();
        InputStream inputStream = ChannelInheritFactory.class.getClassLoader().getResourceAsStream(propertiesPath);
        if (inputStream == null) {
            return null;
        }
        try {
            props.load(inputStream);
            return props;
        }
        catch (IOException e) {
            logger.error((Object)I18NMessage.get(ChannelInheritFactory.class, "ChannelInheritFactory", "\u52a0\u8f7d\u7ee7\u627f\u914d\u7f6e\u6587\u4ef6\u5931\u8d25"), (Throwable)e);
            return null;
        }
    }

    public static ChannelInheritFactory newInstance() {
        if (channelInheritFactory == null) {
            channelInheritFactory = new ChannelInheritFactory();
        }
        return channelInheritFactory;
    }

    public List<IChannelInherit> getChannelInherList() {
        if (this.channelInherList == null) {
            this.init();
        }
        return this.channelInherList;
    }
}

