/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.content;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.Locker;
import com.trs.cms.content.LockerMgr;
import com.trs.cms.content.WCMHandler;
import com.trs.cms.content.WCMObjsHandler;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyJAXPXMLParser;
import com.trs.infra.util.CMyString;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WCMObjHelper {
    private static Logger logger = Logger.getLogger(WCMObjHelper.class);

    public static CMSObj toWCMObj(String _sWCMObjXMLContent, CMSObj _oWCMObj) throws WCMException {
        if (_sWCMObjXMLContent == null || _sWCMObjXMLContent.length() <= 0) {
            return null;
        }
        Reader reader = null;
        try {
            WCMHandler wcmHandler = new WCMHandler(_oWCMObj);
            reader = WCMObjHelper.getReader(CMyString.filterForJDOM(_sWCMObjXMLContent));
            WCMObjHelper.parseXMLFile(new InputSource(reader), wcmHandler, false);
            CMSObj updateObj = wcmHandler.getWCMObj();
            updateObj.removeProperty(updateObj.getIdFieldName());
            updateObj.removeProperty("CRUSER");
            updateObj.removeProperty("CRTIME");
            CMSObj cMSObj = updateObj;
            return cMSObj;
        }
        catch (Exception ex) {
            throw new WCMException(1104, I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label1", "\u8bbe\u7f6e\u5bf9\u8c61[") + _oWCMObj.getClassName(false) + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label2", "]\u5bf9\u8c61ID[") + _oWCMObj.getId() + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label3", "]\u5c5e\u6027\u65f6\u53d1\u751f\u5f02\u5e38\uff01"), ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                    reader = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    public static CMSObj toWCMObj(String _sWCMObjXMLContent, User _loginUser, int _nObjId, Class _oWCMObjClass) throws WCMException {
        if (_sWCMObjXMLContent == null || _sWCMObjXMLContent.length() <= 0) {
            return null;
        }
        CMSObj currObj = null;
        try {
            currObj = (CMSObj)BaseObj.createNewInstance(_oWCMObjClass);
        }
        catch (Exception ex) {
            throw new WCMException(2, I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label4", "\u4ea7\u751f\u6307\u5b9a\u5bf9\u8c61[") + _oWCMObjClass.getName() + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label5", "]\u7684\u5b9e\u4f8b\u5931\u8d25\uff01"), ex);
        }
        if (_nObjId > 0) {
            currObj = WCMObjHelper.findAndLockWCMObj(_loginUser, currObj, _nObjId);
        }
        try {
            return WCMObjHelper.toWCMObj(_sWCMObjXMLContent, currObj);
        }
        catch (WCMException ex) {
            if (!currObj.isAddMode()) {
                currObj.cancelUpdate(_loginUser);
            }
            throw ex;
        }
    }

    public static List toWCMObjList(String _sWCMObjsXMLContent, CMSObj _obj, User _loginUser) throws Exception {
        if (_sWCMObjsXMLContent == null || _sWCMObjsXMLContent.length() <= 0) {
            return null;
        }
        WCMObjsHandler oWCMObjsHandler = new WCMObjsHandler(_obj);
        WCMObjHelper.parseXMLFile(new InputSource(WCMObjHelper.getReader(_sWCMObjsXMLContent)), oWCMObjsHandler, false);
        List arWCMObjList = oWCMObjsHandler.getWCMObjList();
        BaseObj currObj = null;
        for (int i = arWCMObjList.size() - 1; i >= 0; --i) {
            currObj = (BaseObj)arWCMObjList.get(i);
            if (currObj.getProperty(currObj.getIdFieldName()) == null) continue;
            int nId = currObj.getPropertyAsInt(currObj.getIdFieldName(), 0);
            if (nId > 0) {
                CMSObj newObj = WCMObjHelper.findAndLockWCMObj(_loginUser, currObj, nId);
                newObj.setNewProperties(currObj.getProperties());
                arWCMObjList.remove(i);
                arWCMObjList.add(i, newObj);
                currObj = newObj;
            }
            currObj.removeProperty(currObj.getIdFieldName());
        }
        return arWCMObjList;
    }

    private static void parseXMLFile(InputSource is, DefaultHandler handler, boolean validating) throws WCMException {
        try {
            CMyJAXPXMLParser.parseXMLFile(is, handler, validating);
        }
        catch (SAXException e) {
            throw new WCMException(150, I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label6", "\u89e3\u6790\u6570\u636e\u65f6\u53d1\u751f\u5f02\u5e38\uff01") + e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            logger.debug((Object)("ParserConfigurationException:" + e.getMessage()));
        }
        catch (IOException e) {
            logger.debug((Object)("IOException:" + e.getMessage()));
        }
    }

    public static String toIdsString(List _arWCMObj) {
        return WCMObjHelper.toIdsString(_arWCMObj, ",");
    }

    public static String toIdsString(List _arWCMObj, String _sDelim) {
        if (_arWCMObj == null || _arWCMObj.isEmpty()) {
            return "";
        }
        StringBuffer sbResult = new StringBuffer(_arWCMObj.size() * (20 + _sDelim.length()));
        int nSize = _arWCMObj.size();
        for (int i = 0; i < nSize; ++i) {
            BaseObj baseObj = (BaseObj)_arWCMObj.get(i);
            if (baseObj == null) continue;
            sbResult.append(baseObj.getId());
            sbResult.append(_sDelim);
        }
        if (sbResult.length() > 0) {
            sbResult.setLength(sbResult.length() - _sDelim.length());
        }
        return sbResult.toString();
    }

    public static String concatProperties(BaseObjs _oCurrBaseObjs, String _sPropertyName) {
        return WCMObjHelper.concatProperties(_oCurrBaseObjs, _sPropertyName, ",");
    }

    public static String concatProperties(BaseObjs _oCurrBaseObjs, String _sPropertyName, String _sDelim) {
        if (_oCurrBaseObjs == null || _oCurrBaseObjs.isEmpty()) {
            return "";
        }
        StringBuffer sbResult = new StringBuffer(_oCurrBaseObjs.size() * (20 + _sDelim.length()));
        int nSize = _oCurrBaseObjs.size();
        for (int i = 0; i < nSize; ++i) {
            String sValue;
            BaseObj baseObj = _oCurrBaseObjs.getAt(i);
            if (baseObj == null || CMyString.isEmpty(sValue = baseObj.getPropertyAsString(_sPropertyName))) continue;
            sbResult.append(sValue);
            sbResult.append(_sDelim);
        }
        if (sbResult.length() > 0) {
            sbResult.setLength(sbResult.length() - _sDelim.length());
        }
        return sbResult.toString();
    }

    public static void unlock(int _nObjType, int _nObjId, User _unlockerUser) throws WCMException, CMyException {
        LockerMgr lockerMgr = (LockerMgr)DreamFactory.createObjectById("LockerMgr");
        Locker locker = lockerMgr.getLocker(_nObjType, _nObjId, false);
        if (locker == null) {
            return;
        }
        if (locker.lockUserIs(_unlockerUser)) {
            lockerMgr.removeLocker(_nObjType, _nObjId);
            return;
        }
        throw new WCMException("[" + _unlockerUser + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label7", "]\u4e0d\u80fd\u89e3\u9501[") + locker.getLockUser() + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label8", "]\u9501\u5b9a\u7684\u5bf9\u8c61[Type=") + _nObjType + ",Id=" + _nObjId + "]");
    }

    private static CMSObj findAndLockWCMObj(User _loginUser, BaseObj _currObj, int _nObjId) throws WCMException {
        CMSObj currObj = (CMSObj)BaseObj.findById(_currObj.getClass(), _nObjId);
        if (currObj == null) {
            throw new WCMException(200006, I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label9", "\u7c7b\u578b\u4e3a[") + _currObj.getClassName(false) + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label10", "],ID\u4e3a[") + _nObjId + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label11", "]\u7684\u5bf9\u8c61\u6ca1\u6709\u627e\u5230!"));
        }
        if (!currObj.canEdit(_loginUser)) {
            throw new WCMException(1013, I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label12", "\u5bf9\u8c61\u5df2\u7ecf\u88ab\u7528\u6237[") + currObj.getLockerUserName() + I18NMessage.get(WCMObjHelper.class, "WCMObjHelper.label13", "]\u9501\u5b9a\uff01\u4e0d\u80fd\u88ab\u4fee\u6539"));
        }
        return currObj;
    }

    private static Reader getReader(String _sValue) {
        return new StringReader(_sValue);
    }
}

