/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyDateTime;

public class TrusteeInfo
extends CMSObj {
    public static final int MODULE_FLOW = 1;
    public static final int OBJ_TYPE = 206;
    public static final String DB_TABLE_NAME = "WCMTRUSTEEINFO";
    public static final String DB_ID_NAME = "TRUSTEEINFOID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 206;
    }

    public int getStatus() {
        return this.getPropertyAsInt("STATUS", 1);
    }

    public boolean isCancel() {
        return this.getStatus() <= 0;
    }

    public boolean setStatus(int _nStatus) throws WCMException {
        return this.setProperty("STATUS", _nStatus);
    }

    public boolean setCancel(boolean _bCancel) throws WCMException {
        return this.setStatus(_bCancel ? 0 : 1);
    }

    public int getTrusteeId() {
        return this.getPropertyAsInt("TRUSTEE", 0);
    }

    public User getTrustee() throws WCMException {
        return User.findById(this.getTrusteeId());
    }

    public boolean setTrustee(int _nTrustee) throws WCMException {
        return this.setProperty("TRUSTEE", _nTrustee);
    }

    public CMyDateTime getStartTime() {
        return (CMyDateTime)this.getProperty("STARTTIME");
    }

    public boolean setStartTime(CMyDateTime _dtStartTime) throws WCMException {
        return this.setProperty("STARTTIME", _dtStartTime);
    }

    public CMyDateTime getEndTime() {
        return (CMyDateTime)this.getProperty("ENDTIME");
    }

    public boolean setEndTime(CMyDateTime _dtEndTime) throws WCMException {
        return this.setProperty("ENDTIME", _dtEndTime);
    }

    public int getModule() {
        return this.getPropertyAsInt("MODULE", 1);
    }

    public String getModuleName() {
        switch (this.getModule()) {
            case 1: {
                return I18NMessage.get(TrusteeInfo.class, "TrusteeInfo.label1", "\u516c\u6587\u5904\u7406");
            }
        }
        return I18NMessage.get(TrusteeInfo.class, "TrusteeInfo.label2", "\u672a\u77e5\u6a21\u5757");
    }

    public boolean setModule(int _nModule) throws WCMException {
        return this.setProperty("MODULE", _nModule);
    }

    public int getCrUserId() {
        return this.getPropertyAsInt("CRUSERID", 0);
    }

    public User getCrUserById() throws WCMException {
        return User.findById(this.getCrUserId());
    }

    public boolean setCrUserId(int _nCrUserId) throws WCMException {
        return this.setProperty("CRUSERID", _nCrUserId);
    }

    @Override
    public CMyDateTime getCrTime() {
        return (CMyDateTime)this.getProperty("CRTIME");
    }

    public boolean setCrTime(CMyDateTime _dtCrTime) throws WCMException {
        return this.setProperty("CRTIME", _dtCrTime);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("TRUSTEE") == null) {
                throw new WCMException(1106, I18NMessage.get(TrusteeInfo.class, "TrusteeInfo.label3", "\u5c5e\u6027Trustee\u6ca1\u6709\u8bbe\u7f6e(TrusteeInfo.isValid)"));
            }
            if (this.getAllProperty().get("STARTTIME") == null) {
                throw new WCMException(1106, I18NMessage.get(TrusteeInfo.class, "TrusteeInfo.label4", "\u5c5e\u6027StartTime\u6ca1\u6709\u8bbe\u7f6e(TrusteeInfo.isValid)"));
            }
            if (this.getAllProperty().get("ENDTIME") == null) {
                throw new WCMException(1106, I18NMessage.get(TrusteeInfo.class, "TrusteeInfo.label5", "\u5c5e\u6027EndTime\u6ca1\u6709\u8bbe\u7f6e(TrusteeInfo.isValid)"));
            }
            if (this.getAllProperty().get("CRUSERID") == null) {
                throw new WCMException(1106, I18NMessage.get(TrusteeInfo.class, "TrusteeInfo.label6", "\u5c5e\u6027CrUserId\u6ca1\u6709\u8bbe\u7f6e(TrusteeInfo.isValid)"));
            }
            if (this.getAllProperty().get("CRTIME") == null) {
                throw new WCMException(1106, I18NMessage.get(TrusteeInfo.class, "TrusteeInfo.label7", "\u5c5e\u6027CrTime\u6ca1\u6709\u8bbe\u7f6e(TrusteeInfo.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(TrusteeInfo.class, "TrusteeInfo.label8", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(TrusteeInfo.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getAllProperty().get("STATUS") == null) {
                this.setStatus(1);
            }
            if (this.getAllProperty().get("MODULE") == null) {
                this.setModule(1);
            }
            super.insert(_currUser);
        }
    }
}

