/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class GroupUser
extends CMSObj {
    public static final int OBJ_TYPE = -1209578322;
    public static final String DB_TABLE_NAME = "WCMGRPUSER";
    public static final String DB_ID_NAME = "GRPUSERID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return -1209578322;
    }

    public int getGroupId() {
        return this.getPropertyAsInt("GROUPID", 0);
    }

    public boolean setGroupId(int _nGroupId) throws WCMException {
        return this.setProperty("GROUPID", _nGroupId);
    }

    public int getUserId() {
        return this.getPropertyAsInt("USERID", 0);
    }

    public boolean setUserId(int _nUserId) throws WCMException {
        return this.setProperty("USERID", _nUserId);
    }

    public boolean isAdministrator() {
        return this.getPropertyAsBoolean("ISADMINISTRATOR", false);
    }

    public int getIsAdministrator() {
        return this.getPropertyAsInt("ISADMINISTRATOR", 0);
    }

    public boolean setIsAdministrator(int _nIsAdministrator) throws WCMException {
        return this.setProperty("ISADMINISTRATOR", _nIsAdministrator);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("GROUPID") == null) {
                throw new WCMException(1106, I18NMessage.get(GroupUser.class, "GroupUser.label1", "\u5c5e\u6027GroupId\u6ca1\u6709\u8bbe\u7f6e(GroupUser.isValid)"));
            }
            if (this.getAllProperty().get("USERID") == null) {
                throw new WCMException(1106, I18NMessage.get(GroupUser.class, "GroupUser.label2", "\u5c5e\u6027UserId\u6ca1\u6709\u8bbe\u7f6e(GroupUser.isValid)"));
            }
            if (this.getAllProperty().get("ISADMINISTRATOR") == null) {
                throw new WCMException(1106, I18NMessage.get(GroupUser.class, "GroupUser.label3", "\u5c5e\u6027IsAdministrator\u6ca1\u6709\u8bbe\u7f6e(GroupUser.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(GroupUser.class, "GroupUser.label4", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(GroupUser.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getAllProperty().get("CRUSER") == null) {
                this.setCrUser(_currUser);
            }
            if (this.getAllProperty().get("CRTIME") == null) {
                this.setCrTime();
            }
            super.insert(_currUser);
        }
    }

    public static final GroupUser findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (GroupUser)BaseObj.findById(GroupUser.class, _nId);
    }

    public static final GroupUser createNewInstance() throws WCMException {
        return (GroupUser)BaseObj.createNewInstance(GroupUser.class);
    }

    public static final GroupUser findByKey(Object _oKey) throws WCMException {
        return (GroupUser)BaseObj.findByKey(GroupUser.class, _oKey);
    }
}

