/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.domain;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.IRightMgr;
import com.trs.cms.auth.persistent.Right;
import com.trs.cms.auth.persistent.Rights;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMObjHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.Reports;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RightSet {
    private Logger logger = Logger.getLogger(this.getClass());

    public boolean setRights(User loginUser, IRightHost _rightHost, List _currRightList, boolean _bSetChildrenRight) throws WCMException {
        Reports reports = new Reports(I18NMessage.get(RightSet.class, "RightSet.label1", "\u8bbe\u7f6e\u6743\u9650"));
        this.setRights(loginUser, _rightHost, _currRightList, _bSetChildrenRight, reports);
        if (reports.getFailedReporter() == null || reports.getFailedReporter().isEmpty()) {
            return true;
        }
        throw new WCMException(I18NMessage.get(RightSet.class, "RightSet.label2", "\u540c\u6b65\u8bbe\u7f6e\u5b50\u680f\u76ee\u6743\u9650\u5931\u8d25\uff01\n") + reports.toString());
    }

    private boolean setRights(User loginUser, IRightHost _rightHost, List _currRightList, boolean _bSetChildrenRight, Reports _reports) throws WCMException {
        if (_rightHost == null) {
            throw new WCMException(20, I18NMessage.get(RightSet.class, "RightSet.label3", "\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u6743\u9650\uff01"));
        }
        try {
            _rightHost.validateCanDoSetRight(loginUser);
        }
        catch (Exception e) {
            _reports.addFailedReport(I18NMessage.get(RightSet.class, "RightSet.label4", "\u6ca1\u6709\u6743\u9650\u7ed9 ") + _rightHost.getInfo() + I18NMessage.get(RightSet.class, "RightSet.label5", " \u4f20\u9012\u6743\u9650\u8bbe\u7f6e"), null);
            return false;
        }
        this.deleteRights(loginUser, _rightHost.getSubstance(), WCMObjHelper.toIdsString(_currRightList));
        if (_currRightList != null) {
            for (int i = 0; i < _currRightList.size(); ++i) {
                Right currRight = (Right)_currRightList.get(i);
                if (currRight == null) {
                    this.logger.error((Object)I18NMessage.get(RightSet.class, "RightSet.label6", "\u4ece\u6743\u9650\u96c6\u5408\u5217\u8868\u4e2d\u53d6\u5f97\u5355\u72ec\u7684\u6743\u9650\u4e3a\u7a7a\uff01"));
                    continue;
                }
                if (currRight.getObjType() == 0 || currRight.getId() <= 0) {
                    currRight.setObject(_rightHost.getSubstance());
                }
                currRight.save(loginUser);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)(I18NMessage.get(RightSet.class, "RightSet.label7", "\u4fdd\u5b58[") + _rightHost.getSubstance() + "]right[" + i + "]\uff01<BR>"));
            }
        }
        if (!_bSetChildrenRight) {
            return true;
        }
        IRightHost[] pChildren = _rightHost.getChildren();
        if (pChildren == null || pChildren.length == 0) {
            return true;
        }
        for (IRightHost children : pChildren) {
            if (children == null) continue;
            this.setRights(loginUser, children, RightSet.makeNewRightList(_currRightList), true, _reports);
        }
        return true;
    }

    private boolean deleteRights(User loginUser, CMSObj _aObj, String _sCurrentRightIds) throws WCMException {
        if (_aObj == null) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(I18NMessage.get(RightSet.class, "RightSet.label8", "\u5220\u9664[") + _aObj + "][" + _sCurrentRightIds + "]rights...\n<BR>\n"));
        }
        String sWhere = "OBJTYPE=? and OBJID=?";
        if (_sCurrentRightIds.length() > 0) {
            sWhere = sWhere + " and RIGHTID not in (" + _sCurrentRightIds + ")";
        }
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.addSearchValues(0, _aObj.getWCMType());
        aFilter.addSearchValues(1, _aObj.getId());
        Rights delRights = Rights.openWCMObjs(loginUser, aFilter);
        delRights.removeAll(true);
        return true;
    }

    private static List makeNewRightList(List _currRightList) throws WCMException {
        if (_currRightList == null) {
            return null;
        }
        ArrayList<Right> newRightList = new ArrayList<Right>(_currRightList.size());
        for (int i = 0; i < _currRightList.size(); ++i) {
            Right currRight = (Right)_currRightList.get(i);
            if (currRight == null) continue;
            Right newRight = new Right();
            newRight.setValue(currRight.getValue());
            newRight.setOperator(currRight.getOperatorType(), currRight.getOperatorId());
            newRightList.add(newRight);
        }
        return newRightList;
    }

    public void inheritRights(User _loginUser, IRightHost _rightHost, boolean _bDropOldRights) throws WCMException {
        if (_rightHost == null) {
            return;
        }
        IRightHost parent = _rightHost.getParent();
        if (parent == null) {
            return;
        }
        IRightMgr aMgr = (IRightMgr)DreamFactory.createObjectById("IRightMgr");
        if (_bDropOldRights) {
            aMgr.getRights(_rightHost.getSubstance()).removeAll(true);
        }
        Rights rights = aMgr.getRights(parent.getSubstance());
        int nSize = rights.size();
        for (int i = 0; i < nSize; ++i) {
            Right right = (Right)rights.getAt(i);
            if (right == null) continue;
            Right newRight = (Right)right.cloneToNewObj();
            newRight.setObject(_rightHost.getSubstance());
            newRight.setAttribute("ISINHERIT", "true");
            newRight.insert(_loginUser);
        }
    }
}

