/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.config;

import com.trs.DreamFactory;
import com.trs.cms.auth.config.OperationConfig;
import com.trs.cms.auth.config.OperationDefineOnCurrChannelConfig;
import com.trs.cms.auth.config.OperationRelatedConfig;
import com.trs.cms.auth.config.RightHostConfig;
import com.trs.cms.auth.config.RightObjectConfig;
import com.trs.cms.auth.domain.IRightHost;
import com.trs.cms.auth.domain.IRightObj;
import com.trs.infra.BaseServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.config.TRSConfigServer;
import com.trs.infra.config.XMLConfigServer;
import com.trs.infra.util.NamesRegister;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RightConfigServer
extends BaseServer {
    private static Logger logger = Logger.getLogger(RightConfigServer.class);
    private static final int MAX_OPERATION_COUNT = 100;
    private static final int MAX_RELATE_COUNT = 100;
    private Map m_mRightObjects = null;
    private Map m_mRightHosts = null;
    private int[][] m_pSimilarIndexs = null;
    private int[][] m_pDependIndexs = null;
    private Map m_mapRightIndexsDefineOnCurrChannel = null;
    private Map m_mapTypeOperationsTemp = null;
    private NamesRegister m_mapRightIndexes = null;
    private XMLConfigServer m_oXMLConfigServer = XMLConfigServer.getInstance();

    public static RightConfigServer getInstance() {
        return (RightConfigServer)DreamFactory.createObjectById("RightConfigServer");
    }

    public IRightObj makeRightObjectInstance(int _nObjType) {
        RightObjectConfig config = (RightObjectConfig)this.getRightObjects().get(new Integer(_nObjType));
        if (config == null) {
            return null;
        }
        return config.makeNewHostInstance();
    }

    public IRightHost makeRightHostInstance(int _nHostType) {
        RightHostConfig config = (RightHostConfig)this.getRightHosts().get(new Integer(_nHostType));
        if (config == null) {
            return null;
        }
        return config.makeNewHostInstance();
    }

    public int[] getSimilarIndexs(int _nOperationIndex) {
        return this.getSimilarIndexs()[_nOperationIndex];
    }

    public int[] getDependIndexs(int _nOperationIndex) {
        return this.getDependIndexs()[_nOperationIndex];
    }

    public List getOperationConfigs(String _sTypeName) {
        if (this.m_mapTypeOperationsTemp == null) {
            this.startup();
        }
        return (ArrayList)this.m_mapTypeOperationsTemp.get(_sTypeName.toUpperCase());
    }

    public int getRightIndexByOperName(String _sOperName) {
        int nRightIndex;
        if (this.m_mapRightIndexes == null) {
            this.startup();
        }
        if ((nRightIndex = this.m_mapRightIndexes.lookup(_sOperName.toUpperCase(), -1)) == -1) {
            logger.warn((Object)(_sOperName + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label1", "\u6709\u53ef\u80fd\u6ca1\u6709\u5728\u6587\u4ef6[") + TRSConfigServer.getConfigRootPath() + "domain" + File.separatorChar + "com.trs.cms.auth" + File.separatorChar + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label2", "config.xml]\u4e2d\u5b9a\u4e49\uff01")));
        }
        return nRightIndex;
    }

    public int[] getRightIndexDefineOnCurrChannel(int _nSiteId) {
        int[] pRightIndexs;
        if (this.m_mapRightIndexsDefineOnCurrChannel == null) {
            this.startup();
        }
        if ((pRightIndexs = (int[])this.m_mapRightIndexsDefineOnCurrChannel.get(new Integer(_nSiteId))) != null) {
            return pRightIndexs;
        }
        pRightIndexs = (int[])this.m_mapRightIndexsDefineOnCurrChannel.get(new Integer(0));
        if (pRightIndexs != null) {
            return pRightIndexs;
        }
        return new int[0];
    }

    @Override
    protected void doShutdown() {
        if (this.m_mRightObjects != null) {
            this.m_mRightObjects.clear();
            this.m_mRightObjects = null;
        }
        if (this.m_mRightHosts != null) {
            this.m_mRightHosts.clear();
            this.m_mRightHosts = null;
        }
    }

    @Override
    protected boolean doStart() {
        this.initRightObjectsConfig();
        this.initRightHostsConfig();
        this.initOperationIndexConfig();
        this.initOperIndexDefineOnCurrChannelConfig();
        return true;
    }

    private synchronized void initRightHostsConfig() {
        if (this.m_mRightHosts != null) {
            return;
        }
        List listRightHostConfigs = this.m_oXMLConfigServer.getConfigObjects(RightHostConfig.class);
        if (listRightHostConfigs == null) {
            this.m_mRightHosts = new HashMap(0);
            return;
        }
        int nSize = listRightHostConfigs.size();
        HashMap<Integer, RightHostConfig> mTemp = new HashMap<Integer, RightHostConfig>(nSize);
        for (int i = 0; i < nSize; ++i) {
            RightHostConfig rightHostConfig = (RightHostConfig)listRightHostConfigs.get(i);
            if (rightHostConfig == null) continue;
            mTemp.put(new Integer(rightHostConfig.getRightHost().getType()), rightHostConfig);
        }
        this.m_mRightHosts = mTemp;
    }

    private synchronized void initRightObjectsConfig() {
        if (this.m_mRightObjects != null) {
            return;
        }
        List listRightObjConfigs = this.m_oXMLConfigServer.getConfigObjects(RightObjectConfig.class);
        int nSize = listRightObjConfigs.size();
        HashMap<Integer, RightObjectConfig> mTemp = new HashMap<Integer, RightObjectConfig>(nSize);
        for (int i = 0; i < nSize; ++i) {
            RightObjectConfig rightObjConfig = (RightObjectConfig)listRightObjConfigs.get(i);
            if (rightObjConfig == null) continue;
            mTemp.put(new Integer(rightObjConfig.getRightObject().getType()), rightObjConfig);
        }
        this.m_mRightObjects = mTemp;
    }

    private synchronized void initOperationIndexConfig() {
        if (this.m_pSimilarIndexs != null) {
            return;
        }
        int[][] pSimilarIndexTemp = new int[100][100];
        int[][] pDependIndexTemp = new int[100][100];
        HashMap hTypeOperationsTemp = new HashMap(10);
        NamesRegister pNamesRegisterTemp = new NamesRegister();
        List listOperation = this.m_oXMLConfigServer.getConfigObjects(OperationConfig.class);
        int nSize = listOperation.size();
        for (int i = 0; i < nSize; ++i) {
            OperationConfig operationConfig = (OperationConfig)listOperation.get(i);
            if (operationConfig == null) continue;
            this.initSimilarIndex(pSimilarIndexTemp, operationConfig);
            this.initDependIndex(pDependIndexTemp, operationConfig);
            this.initTypeOperations(hTypeOperationsTemp, operationConfig);
            this.initRightIndexes(pNamesRegisterTemp, operationConfig);
        }
        this.m_mapTypeOperationsTemp = hTypeOperationsTemp;
        this.m_pSimilarIndexs = pSimilarIndexTemp;
        this.m_pDependIndexs = pDependIndexTemp;
        this.m_mapRightIndexes = pNamesRegisterTemp;
    }

    private synchronized void initOperIndexDefineOnCurrChannelConfig() {
        if (this.m_mapRightIndexsDefineOnCurrChannel != null) {
            return;
        }
        List listOperation = this.m_oXMLConfigServer.getConfigObjects(OperationDefineOnCurrChannelConfig.class);
        int nSize = 0;
        if (listOperation != null) {
            nSize = listOperation.size();
        }
        if (nSize == 0) {
            this.m_mapRightIndexsDefineOnCurrChannel = new HashMap();
            return;
        }
        HashMap<Integer, int[]> mapTemp = new HashMap<Integer, int[]>(nSize);
        for (int i = 0; i < nSize; ++i) {
            ArrayList pOperationConfigs;
            OperationDefineOnCurrChannelConfig operIndexDefineOnChnlCfg = (OperationDefineOnCurrChannelConfig)listOperation.get(i);
            if (operIndexDefineOnChnlCfg == null || (pOperationConfigs = operIndexDefineOnChnlCfg.getOperations()) == null || pOperationConfigs.isEmpty()) continue;
            int[] pIndexesTemp = new int[pOperationConfigs.size()];
            int nOpertationsSize = pOperationConfigs.size();
            for (int j = 0; j < nOpertationsSize; ++j) {
                OperationConfig operationConfig = (OperationConfig)pOperationConfigs.get(j);
                if (operationConfig == null) continue;
                pIndexesTemp[j] = operationConfig.getIndex();
            }
            mapTemp.put(new Integer(operIndexDefineOnChnlCfg.getSiteId()), pIndexesTemp);
        }
        this.m_mapRightIndexsDefineOnCurrChannel = mapTemp;
    }

    private void initRightIndexes(NamesRegister _pNamesRegister, OperationConfig _operationConfig) {
        String sName = _operationConfig.getName();
        if (sName == null || sName.length() == 0) {
            logger.warn((Object)(_operationConfig + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label3", "\u5b9a\u4e49\u6709\u8bef\uff0c\u6ca1\u6709\u8bbe\u7f6eName\u5c5e\u6027\uff01")));
            return;
        }
        if (_pNamesRegister.contains(sName = sName.toUpperCase())) {
            logger.warn((Object)(I18NMessage.get(RightConfigServer.class, "RightConfigServer.label4", "\u6743\u9650[") + sName + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label5", "]\u91cd\u590d\u5b9a\u4e49!")));
        }
        _pNamesRegister.register(sName, _operationConfig.getIndex());
    }

    private void initTypeOperations(Map _hTypeOperationsTemp, OperationConfig _operationConfig) {
        String sType = _operationConfig.getType();
        if (sType == null || sType.length() == 0) {
            logger.warn((Object)(_operationConfig + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label6", "\u5b9a\u4e49\u6709\u8bef\uff0c\u6ca1\u6709\u8bbe\u7f6eType\u8282\u70b9\uff01")));
            return;
        }
        ArrayList<OperationConfig> arTemp = (ArrayList<OperationConfig>)_hTypeOperationsTemp.get(sType = sType.toUpperCase());
        if (arTemp == null) {
            arTemp = new ArrayList<OperationConfig>(20);
            _hTypeOperationsTemp.put(sType, arTemp);
        }
        arTemp.add(_operationConfig);
    }

    private void initSimilarIndex(int[][] pTemp, OperationConfig operationConfig) {
        OperationRelatedConfig depends = operationConfig.getDepends();
        if (depends == null) {
            return;
        }
        ArrayList dependOperaotors = depends.getOperations();
        OperationRelatedConfig includes = operationConfig.getIncludeOperations();
        ArrayList includeOperaotors = new ArrayList(0);
        if (includes != null) {
            includeOperaotors = includes.getOperations();
        }
        int nCurrOperationIndex = operationConfig.getIndex();
        int nSize = dependOperaotors.size();
        for (int i = 0; i < nSize; ++i) {
            OperationConfig includeOperation = (OperationConfig)dependOperaotors.get(i);
            if (includeOperation == null || includeOperaotors.contains(includeOperation)) continue;
            int nSrcIndex = includeOperation.getIndex();
            int nCurrRelateIndex = this.getCurrentIndex(pTemp[nSrcIndex]);
            if (nCurrRelateIndex < 0) {
                logger.error((Object)(I18NMessage.get(RightConfigServer.class, "RightConfigServer.label9", "\u7c7b\u4f3c\u6743\u9650\u7f13\u51b2\u5df2\u6ee1\uff01\u7c7b\u4f3c\u6743\u9650[") + operationConfig + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label7", "]\u4e0d\u80fd\u52a0\u5165\u5230\u6743\u9650[") + includeOperation + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label8", "]\u4e2d")));
                continue;
            }
            pTemp[nSrcIndex][nCurrRelateIndex] = nCurrOperationIndex;
        }
    }

    private void initDependIndex(int[][] pTemp, OperationConfig operationConfig) {
        OperationRelatedConfig depends = operationConfig.getDepends();
        if (depends == null) {
            return;
        }
        int nCurrOperationIndex = operationConfig.getIndex();
        int nCurrDependIndex = this.getCurrentIndex(pTemp[nCurrOperationIndex]);
        ArrayList elements = depends.getOperations();
        int nSize = elements.size();
        for (int i = 0; i < nSize; ++i) {
            OperationConfig dependOperation = (OperationConfig)elements.get(i);
            if (dependOperation == null) continue;
            if (nCurrDependIndex >= 100) {
                logger.error((Object)(I18NMessage.get(RightConfigServer.class, "RightConfigServer.label10", "\u6743\u9650\u7f13\u51b2\u5df2\u6ee1\uff01\u4f9d\u8d56\u6743\u9650[") + dependOperation + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label7", "]\u4e0d\u80fd\u52a0\u5165\u5230\u6743\u9650[") + operationConfig + I18NMessage.get(RightConfigServer.class, "RightConfigServer.label8", "]\u4e2d")));
                continue;
            }
            pTemp[nCurrOperationIndex][nCurrDependIndex] = dependOperation.getIndex();
            ++nCurrDependIndex;
        }
    }

    private int getCurrentIndex(int[] _pRelatedIndex) {
        for (int i = 0; i < _pRelatedIndex.length; ++i) {
            if (_pRelatedIndex[i] != 0) continue;
            return i;
        }
        return -1;
    }

    private Map getRightHosts() {
        if (this.m_mRightHosts == null) {
            this.initRightHostsConfig();
        }
        return this.m_mRightHosts;
    }

    private Map getRightObjects() {
        if (this.m_mRightObjects == null) {
            this.initRightObjectsConfig();
        }
        return this.m_mRightObjects;
    }

    public int[][] getSimilarIndexs() {
        if (this.m_pSimilarIndexs == null) {
            this.initOperationIndexConfig();
        }
        return this.m_pSimilarIndexs;
    }

    public int[][] getDependIndexs() {
        if (this.m_pDependIndexs == null) {
            this.initOperationIndexConfig();
        }
        return this.m_pDependIndexs;
    }
}

