/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth;

import com.trs.DreamFactory;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.RightCacheMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUserCacheMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.persistent.BaseObjs;
import org.apache.log4j.Logger;

public class AuthHelper {
    private static Logger logger = Logger.getLogger(AuthHelper.class);
    private static RoleUserCacheMgr roleUserCacheMgr = (RoleUserCacheMgr)DreamFactory.createObjectById("RoleUserCacheMgr");

    public static boolean hasSuperRight(User _currUser, CMSObj _currObj) throws WCMException {
        if (_currUser == null) {
            throw new WCMException(10, "\u4f20\u5165\u7684\u5bf9\u8c61\u4e3a\u7a7a,\u65e0\u6cd5\u6821\u9a8c\u6743\u9650!");
        }
        if (_currUser.isAdministrator()) {
            return true;
        }
        return _currObj != null && _currUser.getName().equalsIgnoreCase(_currObj.getCrUserName());
    }

    public static boolean hasRightOnSelf(User _currUser, CMSObj _objCurrent, int[] _pRightIndex) throws WCMException {
        if (_pRightIndex == null || _pRightIndex.length == 0) {
            return true;
        }
        if (_currUser == null) {
            throw new WCMException("\u6ca1\u6709\u6307\u5b9a\u9700\u8981\u6821\u9a8c\u7684\u7528\u6237\uff01");
        }
        if (_currUser.isSystem()) {
            logger.warn((Object)"\u5f53\u524d\u5224\u65ad\u6743\u9650\u7528\u6237\u4e3aSystem!");
            return false;
        }
        if (_objCurrent == null) {
            return _currUser.isAdministrator();
        }
        if (AuthHelper.hasSuperRight(_currUser, _objCurrent)) {
            return true;
        }
        BaseObjs roles = null;
        BaseObjs groups = null;
        RightCacheMgr rightCacheMgr = (RightCacheMgr)DreamFactory.createObjectById("RightCacheMgr");
        try {
            boolean bl;
            int i;
            boolean[] pHasRight = new boolean[_pRightIndex.length];
            for (int i2 = 0; i2 < pHasRight.length; ++i2) {
                pHasRight[i2] = false;
            }
            long lRightValue = rightCacheMgr.getRightValue(_objCurrent.getWCMType(), _objCurrent.getId(), 204, _currUser.getId(), -1L);
            if (lRightValue == WCMRightTypes.VALUE_ONLY_BROWSER) {
                boolean bHasRight = AuthHelper.hasRight(lRightValue, _pRightIndex, pHasRight);
                if (bHasRight) {
                    boolean bl2 = true;
                    return bl2;
                }
            } else if (lRightValue != -1L) {
                int nRightIndexNo;
                for (nRightIndexNo = 0; nRightIndexNo < _pRightIndex.length; ++nRightIndexNo) {
                    int nRightIndex = _pRightIndex[nRightIndexNo];
                    if (AuthServer.hasRight(lRightValue, nRightIndex)) continue;
                    boolean bl3 = false;
                    return bl3;
                }
                nRightIndexNo = 1;
                return nRightIndexNo != 0;
            }
            groups = _currUser.getGroups();
            block14: for (i = 0; i < groups.size(); ++i) {
                Group group = (Group)groups.getAt(i);
                if (group == null) continue;
                lRightValue = rightCacheMgr.getRightValue(_objCurrent.getWCMType(), _objCurrent.getId(), 201, groups.getIdAt(i), -1L);
                if (lRightValue == -1L) {
                    for (Group parentGroup = group.getParent(); parentGroup != null && groups.indexOf(parentGroup.getId()) < 0; parentGroup = parentGroup.getParent()) {
                        lRightValue = rightCacheMgr.getRightValue(_objCurrent.getWCMType(), _objCurrent.getId(), 201, parentGroup.getId(), -1L);
                        if (lRightValue == -1L) continue;
                        boolean bHasRight = AuthHelper.hasRight(lRightValue, _pRightIndex, pHasRight);
                        if (!bHasRight) continue block14;
                        boolean bl4 = true;
                        return bl4;
                    }
                    continue;
                }
                boolean bHasRight = AuthHelper.hasRight(lRightValue, _pRightIndex, pHasRight);
                if (!bHasRight) continue;
                bl = true;
                return bl;
            }
            roles = roleUserCacheMgr.getRoles(_currUser, RightValue.getSite(_objCurrent.getWCMType(), _objCurrent.getId()));
            for (i = 0; i < roles.size(); ++i) {
                boolean bHasRight;
                Role role = (Role)roles.getAt(i);
                if (role == null) {
                    logger.error((Object)("The cache is error? The role[ID=" + roles.getIdAt(i) + "] of user[" + _currUser.getName() + "] not exists!"));
                    continue;
                }
                lRightValue = role.isSystemRole() ? role.getRightValue() : rightCacheMgr.getRightValue(_objCurrent.getWCMType(), _objCurrent.getId(), 203, roles.getIdAt(i), -1L);
                if (lRightValue == -1L || !(bHasRight = AuthHelper.hasRight(lRightValue, _pRightIndex, pHasRight))) continue;
                bl = true;
                return bl;
            }
        }
        catch (WCMException ex) {
            throw new WCMException(1100, "\u53d6\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25(RightValue.load)", ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, "\u53d6\u7528\u6237\u6743\u9650\u503c\u65f6\u5931\u8d25(RightValue.load)", ex);
        }
        finally {
            if (roles != null) {
                roles.clear();
            }
            if (groups != null) {
                groups.clear();
            }
        }
        return false;
    }

    private static boolean hasRight(long _lRightValue, int[] _pRightIndex, boolean[] _pHasRight) {
        boolean bHasRight = true;
        for (int nRightIndexNo = 0; nRightIndexNo < _pRightIndex.length; ++nRightIndexNo) {
            if (_pHasRight[nRightIndexNo]) continue;
            int nRightIndex = _pRightIndex[nRightIndexNo];
            if (AuthServer.hasRight(_lRightValue, nRightIndex)) {
                _pHasRight[nRightIndexNo] = true;
                continue;
            }
            bHasRight = false;
        }
        return bHasRight;
    }
}

