/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.ext.wcm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.trs.cluster.ext.wcm.ClusterProxyFilter;
import com.trs.cluster.ext.wcm.MemberServiceChecker;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.MemberListener;
import com.trs.infra.cluster.util.AtomicInteger;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.email.CMyEmail;
import com.trs.infra.util.email.CMyMailException;
import com.trs.infra.util.email.TRSMailer;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class MemberShipNotifier
implements MemberListener {
    private static final Logger LOG = Logger.getLogger(MemberShipNotifier.class);
    private AtomicInteger m_oCounter = new AtomicInteger();
    private static final long WAIT_CYCLE = 120000L;
    private Map m_oNotifiers;
    private Member localMember;

    public MemberShipNotifier(Member localMember) {
        this.localMember = localMember;
        this.m_oNotifiers = new ConcurrentHashMap(4);
    }

    public void memberFailed(Member member) {
        this.proxyIfNeed(member);
        Notifier notifier = new Notifier(member);
        this.m_oNotifiers.put(member._guid(), notifier);
        new Thread(notifier).start();
    }

    private void proxyIfNeed(Member member) {
        if (MemberServiceChecker.isAlive(member)) {
            this.m_oCounter.incrementAndGet();
            ClusterProxyFilter.setProxyAll(true);
        }
    }

    private void sendNotifyMail(Member member) {
        CMyEmail mail = new CMyEmail();
        mail.setMailFormat(0);
        mail.setFromUser("wcm-alert");
        mail.setSubject("[\u96c6\u7fa4\u8b66\u62a5]\u53d1\u73b0\u8282\u70b9\u6210\u5458\u5de5\u4f5c\u4e0d\u6b63\u5e38,\u8bf7\u68c0\u67e5.");
        StringBuffer buff = new StringBuffer(256);
        buff.append("\u96c6\u7fa4\u6210\u5458[");
        buff.append(this.localMember);
        buff.append("]\u53d1\u73b0\u65e0\u6cd5\u4e0e\u6210\u5458[");
        buff.append(member);
        buff.append("]\u6b63\u5e38\u901a\u4fe1,\u8bf7\u68c0\u67e5.\n\u672c\u90ae\u4ef6\u4e0d\u9700\u8981\u56de\u590d,\u8c22\u8c22.");
        buff.append("\n\n" + CMyDateTime.now());
        mail.setBody(buff.toString());
        String to = this.getEmailList();
        if (to.length() == 0) {
            LOG.warn((Object)"No admin user to notify?.");
            return;
        }
        mail.setTo(to);
        TRSMailer mailer = new TRSMailer();
        try {
            mailer.send(mail);
        }
        catch (CMyMailException e) {
            LOG.error((Object)"failed to notify the administrators.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEmailList() {
        try {
            String mail = ConfigServer.getServer().getSysConfigValue("cluster.extra.maillist", null);
            if (mail != null && mail.trim().length() > 0) {
                return mail;
            }
        }
        catch (Exception mail) {
            // empty catch block
        }
        String sql = "select u.email from wcmuser u, wcmroleuser ru where ru.roleid=1 and ru.userid=u.userid";
        DBManager dbman = DBManager.getDBManager();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        StringBuffer buff = new StringBuffer(128);
        try {
            conn = dbman.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String email = rs.getString(1);
                if (email == null) continue;
                buff.append(';').append(email);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to query administrators.", (Throwable)ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbman.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
        if (buff.length() == 0) {
            return "";
        }
        return buff.substring(1).intern();
    }

    public void memberJoined(Member member) {
        Notifier notifier;
        int c = this.m_oCounter.get();
        if (c > 0 && (c = this.m_oCounter.decrementAndGet()) == 0) {
            ClusterProxyFilter.setProxyAll(false);
        }
        if ((notifier = (Notifier)this.m_oNotifiers.remove(member._guid())) != null) {
            notifier.cancle();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("cancle a failed notify for: " + member));
            }
        }
    }

    public void memberLeft(Member member) {
    }

    private class Notifier
    implements Runnable {
        private Member member = null;
        private boolean cancled = false;

        public Notifier(Member member) {
            this.member = member;
        }

        @Override
        public synchronized void run() {
            try {
                this.wait(120000L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                this.cancled = true;
            }
            if (!this.cancled) {
                MemberShipNotifier.this.sendNotifyMail(this.member);
            }
        }

        public synchronized void cancle() {
            this.cancled = true;
            this.notifyAll();
        }
    }
}

