/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster;

import com.trs.DreamFactory;
import com.trs.cluster.IClusterMsgCenter;
import com.trs.cluster.IClusterMsgReceiver;
import com.trs.cluster.TRSWCMClusterServer;
import com.trs.cms.ObjectTypeServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.cache.ICachedPOMgr;
import com.trs.infra.util.WCMDiscoveryFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ClusterMsgCenterImpl
implements IClusterMsgCenter {
    private static Logger logger = Logger.getLogger(ClusterMsgCenterImpl.class);
    private HashMap m_hReceiversOfWCMObjOnAdd = null;
    private HashMap m_hReceiversOfWCMObjOnModify = null;
    private HashMap m_hReceiversOfWCMObjOnDel = null;
    private HashMap m_hReceiversOfMessage = null;
    private TRSWCMClusterServer m_oClusterServer = null;
    private boolean m_bStartCluster = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterMsgCenterImpl() {
        Class<ClusterMsgCenterImpl> clazz = ClusterMsgCenterImpl.class;
        synchronized (ClusterMsgCenterImpl.class) {
            this.initClusterServer();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void receive(int _nObjType, int _nObjId, int _nEventType) throws Exception {
        Class currClass;
        if (logger.isDebugEnabled()) {
            StringBuffer buff = new StringBuffer(128);
            buff.append("Cluster Msg Received: ObjType=");
            buff.append(_nObjType);
            buff.append(", ObjId=");
            buff.append(_nObjId);
            buff.append(", Event=");
            buff.append(_nEventType);
            logger.debug((Object)buff);
            buff.setLength(0);
        }
        if (this.m_hReceiversOfWCMObjOnAdd == null) {
            this.loadConfigs();
        }
        if ((currClass = ObjectTypeServer.get(_nObjType)) == null) {
            throw new WCMException(I18NMessage.get(BaseObj.class, "BaseObj.label45", "\u6307\u5b9a\u7c7b\u578b[") + _nObjType + I18NMessage.get(BaseObj.class, "BaseObj.label46", "]\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01"));
        }
        ICachedPOMgr currCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
        boolean bIsCachePO = currCachedPOMgr.isCached(currClass);
        BaseObj currObj = this.makeCurrPOObject(currClass, _nObjId, _nEventType);
        if (bIsCachePO) {
            switch (_nEventType) {
                case 1: {
                    currCachedPOMgr.notifyOnAddObj(currObj);
                    break;
                }
                case 3: {
                    currCachedPOMgr.notifyOnDelObj(currObj, 4);
                }
            }
        }
        IClusterMsgReceiver[] pReceivers = this.findReceiversByWCMObj(_nObjType, _nEventType);
        for (int i = 0; pReceivers != null && i < pReceivers.length; ++i) {
            pReceivers[i].receive(currObj, _nEventType);
        }
        if (bIsCachePO && _nEventType == 2) {
            Hashtable<String, Object> oldProps = currObj.getProperties();
            oldProps.clear();
            Hashtable<String, Object> newProps = currObj.getNewProperties();
            oldProps.putAll(newProps);
            newProps.clear();
        }
    }

    @Override
    public void receive(int _nObjType, int _nObjId, int _nEventType, Hashtable _hProperties) throws Exception {
        if (logger.isDebugEnabled()) {
            StringBuffer buff = new StringBuffer(256);
            buff.append("Cluster Msg Received: ObjType=");
            buff.append(_nObjType);
            buff.append(", ObjId=");
            buff.append(_nObjId);
            buff.append(", Event=");
            buff.append(_nEventType);
            buff.append(". ObjProps=");
            buff.append(_hProperties);
            logger.debug((Object)buff);
            buff.setLength(0);
        }
        if (this.m_hReceiversOfWCMObjOnDel == null) {
            this.loadConfigs();
        }
        if (_hProperties == null) {
            throw new WCMException("\u4f20\u5165\u7684\u6570\u636e\u4e0d\u5bf9\uff01");
        }
        Class currClass = ObjectTypeServer.get(_nObjType);
        if (currClass == null) {
            throw new WCMException(I18NMessage.get(BaseObj.class, "BaseObj.label45", "\u6307\u5b9a\u7c7b\u578b[") + _nObjType + I18NMessage.get(BaseObj.class, "BaseObj.label46", "]\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01"));
        }
        BaseObj currObj = this.makeCurrPOFromProperties(currClass, _nObjId, _nEventType, _hProperties);
        IClusterMsgReceiver[] pReceivers = this.findReceiversByWCMObj(_nObjType, _nEventType);
        for (int i = 0; pReceivers != null && i < pReceivers.length; ++i) {
            pReceivers[i].receive(currObj, _nEventType);
        }
        if (2 == _nEventType) {
            currObj.getProperties().clear();
            currObj.setProperties(currObj.getNewProperties());
            currObj.getNewProperties().clear();
        }
    }

    @Override
    public void receive(String _sContent, String[] _pParameters) throws Exception {
        int i;
        if (logger.isDebugEnabled()) {
            StringBuffer buff = new StringBuffer(128);
            buff.append("Cluster Msg Received: MsgType=");
            buff.append(_sContent);
            buff.append(", Params=");
            if (_pParameters != null && _pParameters.length > 0) {
                buff.append(_pParameters[0]);
                int len = _pParameters.length;
                for (i = 1; i < len; ++i) {
                    buff.append(", ").append(_pParameters[i]);
                }
            } else {
                buff.append("None");
            }
            logger.debug((Object)buff);
            buff.setLength(0);
        }
        IClusterMsgReceiver[] pReceivers = this.findReceiversByMessage(_sContent);
        for (i = 0; pReceivers != null && i < pReceivers.length; ++i) {
            pReceivers[i].receive(_sContent, _pParameters);
        }
    }

    private void send(int _nObjType, int _nObjId, int _nEventType) throws Exception {
        if (!this.m_bStartCluster) {
            return;
        }
        if (this.m_oClusterServer == null) {
            this.initClusterServer();
        }
        if (!this.isNeedSendMsg(_nObjType, _nEventType)) {
            return;
        }
        int[] pArgs = new int[]{_nObjType, _nObjId, _nEventType};
        if (logger.isDebugEnabled()) {
            StringBuffer buff = new StringBuffer(128);
            buff.append("Cluster Msg Send: ObjType=");
            buff.append(_nObjType);
            buff.append(", ObjId=");
            buff.append(_nObjId);
            buff.append(", Event=");
            buff.append(_nEventType);
            logger.debug((Object)buff, (Throwable)new Exception("For call stack inspect."));
            buff.setLength(0);
        }
        this.m_oClusterServer.sendMsg((Serializable)pArgs);
    }

    @Override
    public void send(int _nObjType, int _nObjId, int _nEventType, Hashtable _hProperties) throws Exception {
        if (!this.isClusterRunning()) {
            return;
        }
        if (_hProperties == null || this.isCached(_nObjType)) {
            this.send(_nObjType, _nObjId, _nEventType);
            return;
        }
        if (this.findReceiversByWCMObj(_nObjType, _nEventType) == null) {
            return;
        }
        Object[] pArgs = new Object[4];
        pArgs[0] = new Integer(_nObjType);
        pArgs[1] = new Integer(_nObjId);
        pArgs[2] = new Integer(_nEventType);
        Hashtable props = new Hashtable(_hProperties.size());
        props.putAll(_hProperties);
        pArgs[3] = props;
        if (logger.isDebugEnabled()) {
            StringBuffer buff = new StringBuffer(128);
            buff.append("Cluster Msg Send: ObjType=");
            buff.append(_nObjType);
            buff.append(", ObjId=");
            buff.append(_nObjId);
            buff.append(", Event=");
            buff.append(_nEventType);
            buff.append(". ObjProps=");
            buff.append(_hProperties);
            logger.debug((Object)buff, (Throwable)new Exception("For call stack inspect."));
            buff.setLength(0);
        }
        this.m_oClusterServer.sendMsg((Serializable)pArgs);
    }

    private boolean initClusterServer() {
        this.m_oClusterServer = (TRSWCMClusterServer)DreamFactory.createObjectById("TRSWCMClusterServer");
        if (this.m_oClusterServer == null || this.m_oClusterServer.getContext() == null) {
            this.m_bStartCluster = false;
            return false;
        }
        this.m_bStartCluster = this.m_oClusterServer.getContext().getConfig().isEnabled();
        return this.m_bStartCluster;
    }

    private boolean isNeedSendMsg(int _nObjType, int _nEventType) throws Exception {
        if (this.isCached(_nObjType)) {
            return true;
        }
        return this.findReceiversByWCMObj(_nObjType, _nEventType) != null;
    }

    private boolean isCached(int _nObjType) throws WCMException {
        Class currClass = ObjectTypeServer.get(_nObjType);
        if (currClass == null) {
            return false;
        }
        ICachedPOMgr currCachedPOMgr = (ICachedPOMgr)DreamFactory.createObjectById("ICachedPOMgr");
        return currCachedPOMgr.isCached(currClass);
    }

    @Override
    public void send(String _sContent, String[] _pParameters) throws Exception {
        this.send(_sContent, _pParameters, false);
    }

    @Override
    public void send(String _sContent, String[] _pParameters, boolean _bPersistent) throws Exception {
        if (!this.isClusterRunning()) {
            return;
        }
        if (this.findReceiversByMessage(_sContent) == null) {
            return;
        }
        String[] pArgs = new String[1 + _pParameters.length];
        pArgs[0] = _sContent;
        System.arraycopy(_pParameters, 0, pArgs, 1, _pParameters.length);
        if (logger.isDebugEnabled()) {
            StringBuffer buff = new StringBuffer(128);
            buff.append("Cluster Msg Send: MsgType=");
            buff.append(_sContent);
            buff.append(", Params=");
            if (_pParameters != null && _pParameters.length > 0) {
                buff.append(_pParameters[0]);
                int len = _pParameters.length;
                for (int i = 1; i < len; ++i) {
                    buff.append(", ").append(_pParameters[i]);
                }
            } else {
                buff.append("None");
            }
            logger.debug((Object)buff, (Throwable)new Exception("For call stack inspect."));
            buff.setLength(0);
        }
        this.m_oClusterServer.sendMsg((Serializable)pArgs, _bPersistent);
    }

    @Override
    public synchronized void loadConfigs() throws Exception {
        Iterator itConvertos = WCMDiscoveryFactory.getDiscovery().getImplementors(IClusterMsgReceiver.class.getName());
        HashMap hTempOfAdd = new HashMap();
        HashMap hTempOfModify = new HashMap();
        HashMap hTempOfDel = new HashMap();
        HashMap hTempOfMessage = new HashMap();
        while (itConvertos.hasNext()) {
            String sReceiverClassName = (String)itConvertos.next();
            Class<?> receiverClass = Class.forName(sReceiverClassName);
            IClusterMsgReceiver receiver = (IClusterMsgReceiver)receiverClass.newInstance();
            this.registerReceiversOfWCMObj(receiver, receiver.registerMoniterWCMObjTypesOnAdd(), hTempOfAdd);
            this.registerReceiversOfWCMObj(receiver, receiver.registerMoniterWCMObjTypesOnModify(), hTempOfModify);
            this.registerReceiversOfWCMObj(receiver, receiver.registerMoniterWCMObjTypesOnDel(), hTempOfDel);
            this.registerReceiversOfMessage(receiver, hTempOfMessage);
        }
        if (this.m_hReceiversOfWCMObjOnAdd != null) {
            this.m_hReceiversOfWCMObjOnAdd.clear();
            this.m_hReceiversOfWCMObjOnAdd = null;
        }
        this.m_hReceiversOfWCMObjOnAdd = hTempOfAdd;
        if (this.m_hReceiversOfWCMObjOnModify != null) {
            this.m_hReceiversOfWCMObjOnModify.clear();
            this.m_hReceiversOfWCMObjOnModify = null;
        }
        this.m_hReceiversOfWCMObjOnModify = hTempOfModify;
        if (this.m_hReceiversOfWCMObjOnDel != null) {
            this.m_hReceiversOfWCMObjOnDel.clear();
            this.m_hReceiversOfWCMObjOnDel = null;
        }
        this.m_hReceiversOfWCMObjOnDel = hTempOfDel;
        if (this.m_hReceiversOfMessage != null) {
            this.m_hReceiversOfMessage.clear();
        }
        this.m_hReceiversOfMessage = null;
        this.m_hReceiversOfMessage = hTempOfMessage;
    }

    IClusterMsgReceiver[] findReceiversByWCMObj(int _nObjType, int _nEventType) throws Exception {
        HashMap hReveivers = null;
        switch (_nEventType) {
            case 1: {
                hReveivers = this.m_hReceiversOfWCMObjOnAdd;
                break;
            }
            case 3: {
                hReveivers = this.m_hReceiversOfWCMObjOnDel;
                break;
            }
            case 2: {
                hReveivers = this.m_hReceiversOfWCMObjOnModify;
            }
        }
        if (hReveivers == null) {
            this.loadConfigs();
        }
        if (hReveivers == null) {
            return null;
        }
        Integer iKey = new Integer(_nObjType);
        return (IClusterMsgReceiver[])hReveivers.get(iKey);
    }

    IClusterMsgReceiver[] findReceiversByMessage(String _sMessage) throws Exception {
        if (this.m_hReceiversOfMessage == null) {
            this.loadConfigs();
        }
        return (IClusterMsgReceiver[])this.m_hReceiversOfMessage.get(_sMessage.toUpperCase());
    }

    private void registerReceiversOfWCMObj(IClusterMsgReceiver _receiver, int[] pMoniterWCMObjTypes, HashMap _hReceivers) {
        if (pMoniterWCMObjTypes == null) {
            return;
        }
        for (int i = 0; i < pMoniterWCMObjTypes.length; ++i) {
            Integer iKey = new Integer(pMoniterWCMObjTypes[i]);
            Class currClass = ObjectTypeServer.get(iKey);
            if (currClass == null) {
                logger.error((Object)("\u6307\u5b9a\u7c7b\u578b[" + iKey + "]\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u6ce8\u518c\u6d88\u606f\u76d1\u542c\u5668[" + _receiver.getClass().getName() + "]\u5931\u8d25\uff01"));
                continue;
            }
            IClusterMsgReceiver[] pReceivers = (IClusterMsgReceiver[])_hReceivers.get(iKey);
            if (pReceivers == null) {
                pReceivers = new IClusterMsgReceiver[1];
            } else {
                IClusterMsgReceiver[] pReceiversTemp = new IClusterMsgReceiver[pReceivers.length + 1];
                System.arraycopy(pReceivers, 0, pReceiversTemp, 0, pReceivers.length);
                pReceivers = pReceiversTemp;
            }
            pReceivers[pReceivers.length - 1] = _receiver;
            _hReceivers.put(iKey, pReceivers);
        }
    }

    private void registerReceiversOfMessage(IClusterMsgReceiver _receiver, HashMap _hReceivers) {
        String[] pMoniterWCMObjTypes = _receiver.registerMoniterMessages();
        if (pMoniterWCMObjTypes == null) {
            return;
        }
        for (int i = 0; i < pMoniterWCMObjTypes.length; ++i) {
            String sKey = pMoniterWCMObjTypes[i].toUpperCase();
            IClusterMsgReceiver[] pReceivers = (IClusterMsgReceiver[])_hReceivers.get(sKey);
            if (pReceivers == null) {
                pReceivers = new IClusterMsgReceiver[1];
            } else {
                IClusterMsgReceiver[] pReceiversTemp = new IClusterMsgReceiver[pReceivers.length + 1];
                System.arraycopy(pReceivers, 0, pReceiversTemp, 0, pReceivers.length);
                pReceivers = pReceiversTemp;
            }
            pReceivers[pReceivers.length - 1] = _receiver;
            _hReceivers.put(sKey, pReceivers);
        }
    }

    private BaseObj makeCurrPOObject(Class _currPOClass, int _nObjId, int _nEventType) throws InstantiationException, IllegalAccessException, WCMException {
        BaseObj currObj = null;
        switch (_nEventType) {
            case 1: {
                currObj = (BaseObj)_currPOClass.newInstance();
                currObj.loadById(_nObjId, "*");
                break;
            }
            case 2: {
                currObj = BaseObj.findById(_currPOClass, _nObjId);
                if (currObj == null) break;
                currObj.loadById(_nObjId, "*", true);
                break;
            }
            case 3: {
                currObj = BaseObj.findById(_currPOClass, _nObjId);
                break;
            }
            default: {
                throw new WCMException("unkown the message type![ID=" + _nEventType + "]");
            }
        }
        if (currObj == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5bf9\u8c61\u5728DB\u4e2d\u4e0d\u5b58\u5728\uff01[Class=" + _currPOClass + ", ID=" + _nObjId + "]");
        }
        return currObj;
    }

    private BaseObj makeCurrPOFromProperties(Class _currPOClass, int _nObjId, int _nEventType, Hashtable _hProperties) throws InstantiationException, IllegalAccessException, WCMException {
        BaseObj currObj = null;
        switch (_nEventType) {
            case 1: 
            case 3: {
                currObj = (BaseObj)_currPOClass.newInstance();
                currObj.setId(_nObjId);
                currObj.setProperties(_hProperties);
                break;
            }
            case 2: {
                currObj = BaseObj.findById(_currPOClass, _nObjId);
                if (currObj == null) break;
                currObj.setNewProperties(currObj.getProperties());
                currObj.setProperties(_hProperties);
                break;
            }
            default: {
                throw new WCMException("unkown the message type![ID=" + _nEventType + "]");
            }
        }
        if (currObj == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u5bf9\u8c61\u5728DB\u4e2d\u4e0d\u5b58\u5728\uff01[Class=" + _currPOClass + ", ID=" + _nObjId + "]");
        }
        return currObj;
    }

    @Override
    public boolean isStarted() {
        return this.m_bStartCluster;
    }

    @Override
    public void send(BaseObj _obj, int _nEventType) throws Exception {
        if (!this.isClusterRunning()) {
            return;
        }
        int nObjType = _obj.getWCMType();
        int nObjId = _obj.getId();
        if (_obj.isCached()) {
            this.send(nObjType, nObjId, _nEventType);
        } else {
            if (this.findReceiversByWCMObj(nObjType, _nEventType) == null) {
                return;
            }
            if (_nEventType == 2 && !_obj.isModified(true)) {
                return;
            }
            Hashtable<String, Object> props = _obj.getProperties();
            if (props == null) {
                props = new Hashtable(2);
            }
            this.send(nObjType, nObjId, _nEventType, props);
        }
    }

    protected boolean isClusterRunning() {
        if (!this.m_bStartCluster) {
            return false;
        }
        return this.m_oClusterServer != null || this.initClusterServer();
    }
}

