/*
 * Decompiled with CFR 0.152.
 */
package com.trs.bigfile;

import com.sun.star.auth.UnsupportedException;
import com.trs.bigfile.BigFile;
import com.trs.bigfile.BigFileRoleAuth;
import com.trs.bigfile.BigFiles;
import com.trs.bigfile.FileUploadHelper;
import com.trs.bigfile.PartData;
import com.trs.bigfile.Result;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BigFileServiceProvider
implements IGlueServiceProvider {
    private static final Logger LOG = Logger.getLogger(BigFileServiceProvider.class);

    @Override
    public void delete(MethodContext _context) throws Throwable {
        int count;
        User user = this.getUserAndAssertRight();
        int nId = _context.getObjectId();
        BigFile bigFile = BigFile.findById(nId);
        if (bigFile != null && (count = bigFile.delete(user)) == 1) {
            FileService file = new FileService(this.getBigFileDir(), bigFile.getURL());
            file.delete();
        }
    }

    private FileService getBigFileDir() {
        ConfigServer server = ConfigServer.getServer();
        String dir = server.getInitProperty("BF");
        if (dir == null) {
            dir = "";
            LOG.fatal((Object)"Error, the bigfiles dir did not config properly.");
        }
        FileService bfDir = new FileService(dir);
        return bfDir;
    }

    private User getUserAndAssertRight() throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        if (!BigFileRoleAuth.hasRight(loginUser)) {
            throw new WCMException(1002, I18NMessage.get(BigFileServiceProvider.class, "BigFileServiceProvider.label1", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u6b64\u670d\u52a1\u3002"));
        }
        return loginUser;
    }

    @Override
    public Object query(MethodContext _context) throws Throwable {
        User user = this.getUserAndAssertRight();
        WCMFilter filter = new WCMFilter("", "TOPDIR=? and SUBDIR=?", "");
        String topdir = CMyString.showNull(_context.getValue("TOPDIR"), "");
        filter.addSearchValues(topdir);
        String subdir = CMyString.showNull(_context.getValue("SUBDIR"), "");
        filter.addSearchValues(subdir);
        String orderby = CMyString.showNull(_context.getValue("OrderBy"), "CRTIME desc");
        filter.setOrder(orderby);
        filter.mergeWith(_context.getExtraWCMFilter());
        BigFiles files = new BigFiles(user);
        files.open(filter);
        return files;
    }

    @Override
    public int save(MethodContext _context) throws Throwable {
        User user = this.getUserAndAssertRight();
        int nId = _context.getObjectId();
        if (nId == 0) {
            boolean zOK;
            BigFile bigFile = new BigFile();
            String originalName = _context.getValue("ORIGINALNAME");
            bigFile.setOriginalName(CMyFile.extractFileName(originalName, null));
            bigFile.setTopDir(_context.getValue("TOPDIR"));
            bigFile.setSubDir(_context.getValue("SUBDIR"));
            String fileName = _context.getValue("FILENAME");
            if (CMyString.isEmpty(fileName)) {
                FileUploadHelper helper = FileUploadHelper.getInstance();
                fileName = helper.getSavedFileName(user.getId(), originalName);
            }
            bigFile.setFileName(fileName);
            bigFile.setDesc(_context.getValue("FILEDESC"));
            bigFile.save(user);
            nId = bigFile.getId();
            FileService dir = this.getBigFileDir();
            FileService uploadedFile = new FileService(dir, fileName);
            FileService dest = new FileService(dir, bigFile.getURL());
            if (!dest.getParentFileStore().exists()) {
                dest.getParentFileStore().mkdirs();
            }
            if (!(zOK = uploadedFile.renameTo(dest))) {
                throw new WCMException(56, I18NMessage.get(BigFileServiceProvider.class, "BigFileServiceProvider.label2", "\u4fdd\u5b58\u6587\u4ef6\u5931\u8d25."));
            }
        } else {
            BigFile bigFile = BigFile.findById(nId);
            String fileDesc = CMyString.showNull(_context.getValue("FILEDESC"));
            bigFile.setDesc(fileDesc);
            bigFile.save(user);
        }
        return nId;
    }

    @Override
    public Object findById(MethodContext _context) throws Throwable {
        throw new UnsupportedException("Unimplemented.");
    }

    @Override
    public Object findByIds(MethodContext _context) throws Throwable {
        throw new UnsupportedException("Unimplemented.");
    }

    public Object startUpload(MethodContext _context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        String flag = null;
        Object cmd = null;
        if (!BigFileRoleAuth.hasRight(loginUser)) {
            flag = "0";
            cmd = Result.UNLOGINED_ERROR.getMessage();
        } else {
            String filename = _context.getValue("filename");
            FileUploadHelper helper = FileUploadHelper.getInstance();
            if (!helper.allowUploadFile(filename)) {
                flag = "0";
                cmd = Result.FORBIDDEN_ERROR.getMessage();
            } else if (this.fileExists(helper.getSavedFileName(loginUser.getId(), filename))) {
                flag = "0";
                cmd = Result.EXIST_ERROR.getMessage();
            } else {
                flag = "1";
                HashMap<String, String> result = new HashMap<String, String>(4);
                cmd = result;
                result.put("filename", filename);
                result.put("partSize", String.valueOf(524288));
                long fileSize = _context.getValue("fileSize", 0L);
                String fileDigest = _context.getValue("fileDigest");
                String[] parts = helper.determinUploadedPart(loginUser, filename, fileDigest, fileSize, false);
                result.put("partIndex", parts[0]);
                result.put("totalPartCount", parts[1]);
            }
        }
        _context.setReturnJSON(true);
        if (cmd instanceof String) {
            return this.toJsonString(flag, (String)cmd);
        }
        return BigFileServiceProvider.toJsonString(flag, (Map)cmd);
    }

    private String toJsonString(String flag, String cmd) {
        StringBuffer buff = new StringBuffer(256);
        buff.append('{');
        buff.append("flag:");
        buff.append(flag);
        buff.append(",cmd:'");
        buff.append(cmd);
        buff.append("'");
        buff.append('}');
        return buff.toString();
    }

    private static String toJsonString(String flag, Map cmd) {
        StringBuffer buff = new StringBuffer(256);
        buff.append('{');
        buff.append("flag:");
        buff.append(flag);
        buff.append(",cmd:{'_dummy_':'leafgray'");
        for (Map.Entry entry : cmd.entrySet()) {
            buff.append(",'");
            buff.append(entry.getKey());
            buff.append("':'");
            buff.append(entry.getValue());
            buff.append("'");
        }
        buff.append('}');
        buff.append('}');
        return buff.toString();
    }

    public Object upload(MethodContext _context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        String flag = null;
        Object cmd = null;
        if (!BigFileRoleAuth.hasRight(loginUser)) {
            flag = "0";
            cmd = Result.UNLOGINED_ERROR.getMessage();
        } else {
            String filename = _context.getValue("filename");
            FileUploadHelper helper = FileUploadHelper.getInstance();
            if (!helper.allowUploadFile(filename)) {
                flag = "0";
                cmd = Result.FORBIDDEN_ERROR.getMessage();
            } else {
                flag = "1";
                HashMap<String, String> result = new HashMap<String, String>(4);
                cmd = result;
                result.put("filename", filename);
                result.put("partSize", String.valueOf(524288));
                PartData partData = new PartData();
                partData.partIndex = _context.getValue("partIndex", 0);
                partData.filename = filename;
                partData.partDigest = _context.getValue("partDigest");
                partData.data = _context.getValue("data");
                String[] parts = helper.saveData2File(loginUser, partData);
                result.put("partIndex", parts[0]);
                result.put("totalPartCount", parts[1]);
            }
        }
        _context.setReturnJSON(true);
        if (cmd instanceof String) {
            return this.toJsonString(flag, (String)cmd);
        }
        return BigFileServiceProvider.toJsonString(flag, (Map)cmd);
    }

    private boolean fileExists(String _filename) throws Throwable {
        String sFileName = CMyFile.extractFileName(_filename);
        String sWhere = "SERVFILENAME=?";
        String sSelect = "count(XWCMBIGFILE.SERVFILENAME)";
        WCMFilter filter = new WCMFilter("XWCMBIGFILE", sWhere, "", sSelect);
        filter.addSearchValues(0, sFileName);
        LOG.debug((Object)("[WCMFilter]: " + filter));
        DBManager currDBManager = DBManager.getDBManager();
        if (currDBManager == null) {
            throw new WCMException(10, I18NMessage.get(BigFileServiceProvider.class, "BigFileServiceProvider.label21", "DBManaer\u914d\u7f6e\u4e0d\u6b63\u786e\uff01"));
        }
        if (!currDBManager.isStarted()) {
            throw new WCMException(10, I18NMessage.get(BigFileServiceProvider.class, "BigFileServiceProvider.label22", "DBManaer\u6ca1\u6709\u542f\u52a8\uff01"));
        }
        int nCount = currDBManager.sqlExecuteIntQuery(filter);
        System.out.println("");
        return nCount > 0;
    }
}

