/*
 * Decompiled with CFR 0.152.
 */
package com.trs.bigfile;

import com.trs.bigfile.FileUploadHelper;
import com.trs.bigfile.PartData;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.jfree.util.Log;

public class BFPartDataHelper {
    private String BF_FOLDER = "BigFileTemp";
    private String BF_PART_FOLDER = "BigFilePart";
    public String BF_PATH = null;
    public String BF_INDEX_PATH = null;

    public BFPartDataHelper(String _sFileName) {
        ConfigServer server = ConfigServer.getServer();
        String dir = server.getInitProperty("BF");
        _sFileName = CMyFile.extractMainFileName(_sFileName);
        this.BF_PATH = dir + File.separator + this.BF_FOLDER + File.separator + _sFileName;
        this.BF_INDEX_PATH = this.BF_PATH + File.separator + this.BF_PART_FOLDER + File.separator;
    }

    public int getPartCount(PartData partData) throws WCMException {
        return Integer.parseInt(this.getBFPartInfo(partData).get("PartCount"));
    }

    public int getTryUploadCount(PartData partData) throws WCMException {
        return Integer.parseInt(this.getBFPartInfo(partData).get("TryUploadCount"));
    }

    public String getPartDigest(PartData partData) throws WCMException {
        return this.getBFPartInfo(partData).get("PartDigest");
    }

    public Map<String, String> getBFPartInfo(PartData partData) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        FileUploadHelper helper = FileUploadHelper.getInstance();
        String sSavedFileName = helper.getSavedFileName(loginUser.getId(), partData.filename);
        return this.getBFPartInfo(sSavedFileName, partData.partIndex);
    }

    public Map<String, String> getBFPartInfo(String _sSavedFileName, int _nPartIndex) throws WCMException {
        String sBFIndexFilePath = CMyString.setStrEndWith(this.BF_PATH, File.separatorChar) + CMyFile.extractMainFileName(_sSavedFileName) + ".properties";
        String sPartFilePath = this.BF_INDEX_PATH + _nPartIndex + ".properties";
        Properties propIndex = new Properties();
        Properties propPart = new Properties();
        InputStream fisIndexFile = null;
        InputStream fisPartFile = null;
        try {
            fisIndexFile = new FileService(sBFIndexFilePath).getInputStream();
            propIndex.load(fisIndexFile);
            if (CMyFile.fileExists(sPartFilePath)) {
                fisPartFile = new FileService(sPartFilePath).getInputStream();
                fisPartFile = new FileService(sPartFilePath).getInputStream();
                propPart.load(fisPartFile);
            }
        }
        catch (IOException e) {
            throw new WCMException("\u8bfb\u6587\u4ef6\u9519\u8bef", e);
        }
        finally {
            try {
                if (fisIndexFile != null) {
                    fisIndexFile.close();
                }
                if (fisPartFile != null) {
                    fisPartFile.close();
                }
            }
            catch (Exception exception) {}
        }
        propIndex.putAll((Map<?, ?>)propPart);
        return propIndex;
    }

    public void saveBFParted(PartData partData) throws WCMException {
        this.saveBigFilePart(partData, 0, 1);
    }

    public void saveBFPartFail(PartData partData, int nTryUploadCount) throws WCMException {
        this.saveBigFilePart(partData, nTryUploadCount, 0);
    }

    public void saveBigFilePart(PartData partData, int nTryUploadCount, int nUploaded) throws WCMException {
        this.saveBigFilePart(partData.filename, partData.partIndex, partData.partDigest, nTryUploadCount, nUploaded);
    }

    public void saveBigFilePart(String sFileName, int nPartIndex, String sPartDigiest, int nTryUploadCount, int nUploaded) throws WCMException {
        OutputStream out = null;
        Properties properties = new Properties();
        properties.put("PartDigest", sPartDigiest);
        properties.put("TryUploadCount", String.valueOf(nTryUploadCount));
        properties.put("Uploaded", String.valueOf(nUploaded));
        try {
            out = new FileService(this.BF_INDEX_PATH, nPartIndex + ".properties").getOutputStream();
            properties.store(out, null);
        }
        catch (IOException ex) {
            throw new WCMException("\u5199\u6587\u4ef6\u5f02\u5e38", ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void deleteBigFilePart() throws WCMException {
        try {
            CMyFile.deleteDir(this.BF_PATH);
        }
        catch (Exception e) {
            Log.error((Object)"\u4e0a\u4f20\u6587\u4ef6\u5b8c\u6210\uff01\u5220\u9664\u4e34\u65f6\u788e\u7247\u65f6\u5b58\u5728\u95ee\u9898\uff0c\u8bf7\u624b\u5de5\u5220\u9664...", (Exception)e);
        }
    }
}

