/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.ajaxservice.xmlconvertors.BaseWCMObjectToXML;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Status;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class ViewDocumentToXML
extends BaseWCMObjectToXML {
    private static Logger logger = Logger.getLogger(ViewDocumentToXML.class);
    private static final int DOCCHANNEL = 1;
    private static final int DOCSTATUS = 2;
    private static final int DOCHTMLCON = 3;
    private static final int DOCTYPE = 4;
    private static final int DOCSOURCE = 5;
    private static final int CHNLID = 6;

    public ViewDocumentToXML() {
        this.m_bToXMLDependsOnSelectFields = false;
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("DOCCHANNEL", 1);
        this.registerHostSpecialProperty("DOCSTATUS", 2);
        this.registerHostSpecialProperty("DOCHTMLCON", 3);
        this.registerHostSpecialProperty("DOCTYPE", 4);
        this.registerHostSpecialProperty("DOCSOURCE", 5);
        this.registerHostSpecialProperty("CHNLID", 6);
    }

    @Override
    protected String[][] getSpecialProperty(MethodContext _methodContext, BaseObj _currObj, int _nPropertyId, Object _currValue) throws ConvertException {
        ViewDocument viewdocument = (ViewDocument)_currObj;
        try {
            switch (_nPropertyId) {
                case 1: {
                    return this.makeChannelValue(viewdocument.getDocChannel());
                }
                case 2: {
                    return this.makeStatus(viewdocument.getStatus());
                }
                case 3: {
                    return this.makeHTMLCon(viewdocument);
                }
                case 4: {
                    return new String[][]{{"Type", _currValue.toString()}, {"Name", viewdocument.getTypeString()}};
                }
                case 5: {
                    return this.makeDocSource(viewdocument.getSource(), _currValue);
                }
                case 6: {
                    if (viewdocument.getChannel() == null) {
                        return new String[][]{{"Name", I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label1", "\u672a\u77e5")}};
                    }
                    return new String[][]{{"Name", viewdocument.getChannel().getDispDesc()}};
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)(I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label2", "\u8f6c\u6362\u5bf9\u8c61[") + _currObj + I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label3", "]\u6570\u636e[") + _nPropertyId + I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label4", "]\u5931\u8d25\uff01")), (Throwable)e);
            throw new ConvertException(I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label5", "\u8f6c\u6362\u6570\u636e[") + _nPropertyId + I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label4", "]\u5931\u8d25\uff01"), e);
        }
        return null;
    }

    private String[][] makeDocSource(Source source, Object _value) {
        if (source == null) {
            return new String[][]{{"Id", _value.toString()}, {"Name", I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label1", "\u672a\u77e5")}};
        }
        return new String[][]{{"Id", String.valueOf(source.getId())}, {"Name", source.getName()}};
    }

    private String[][] makeHTMLCon(ViewDocument _viewdocument) throws WCMException {
        switch (_viewdocument.getPropertyAsInt("DOCTYPE", 0)) {
            case 20: {
                return new String[][]{{_viewdocument.getHtmlContentWithImgFilter(null, false)}};
            }
            case 10: {
                return new String[][]{{CMyString.transDisplay(_viewdocument.getContent(), false)}};
            }
            case 40: {
                return new String[][]{{I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label6", "\u5916\u90e8\u6587\u4ef6")}};
            }
            case 30: {
                return new String[][]{{I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label7", "\u94fe\u63a5\u6587\u6863")}};
            }
        }
        return new String[][]{{I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label8", "\u672a\u77e5\u7c7b\u578b\u6587\u6863[Type=") + _viewdocument.getType() + "]"}};
    }

    private String[][] makeStatus(Status status) {
        if (status == null) {
            return new String[][]{{"ID", "0"}, {"NAME", I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label1", "\u672a\u77e5")}};
        }
        return new String[][]{{"ID", status.getKey().toString()}, {"NAME", status.getDisp()}};
    }

    private String[][] makeChannelValue(Channel _channel) throws WCMException {
        if (_channel == null) {
            return new String[][]{{"ID", "0"}, {"NAME", I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label1", "\u672a\u77e5")}, {"RIGHTVALUE", "0"}, {"CHANNELTYPE", "0"}};
        }
        String rightValue = "";
        User loginUser = ContextHelper.getLoginUser();
        rightValue = loginUser.isAdministrator() || loginUser.equals(_channel.getCrUser()) ? RightValue.getAdministratorValues() : AuthServer.getRightValue((CMSObj)_channel, loginUser).toString();
        return new String[][]{{"ID", _channel.getKey().toString()}, {"NAME", _channel.getDispDesc()}, {"RIGHTVALUE", rightValue}, {"CHANNELTYPE", String.valueOf(_channel.getType())}};
    }

    @Override
    public String[] registerTargetClassName() {
        return new String[]{ViewDocuments.class.getName(), ViewDocument.class.getName()};
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObjs objects) throws ConvertException {
        ViewDocuments viewDocuments = (ViewDocuments)objects;
        try {
            return new String[][]{{"CanSort", String.valueOf(viewDocuments.canSort())}};
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label9", "\u6784\u9020\u6587\u6863\u6839\u8282\u70b9\u5c5e\u6027\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    protected String[][] getSpecialRootAttributes(MethodContext context, BaseObj object) throws ConvertException {
        ViewDocument viewDocument = (ViewDocument)object;
        try {
            return new String[][]{{"CanEdit", String.valueOf(viewDocument.hasRight(ContextHelper.getLoginUser(), 32))}};
        }
        catch (WCMException e) {
            throw new ConvertException(I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label9", "\u6784\u9020\u6587\u6863\u6839\u8282\u70b9\u5c5e\u6027\u5931\u8d25\uff01"), e);
        }
    }

    @Override
    protected String[][] getSpecialElementAttributes(MethodContext _methodContext, BaseObj object) throws ConvertException {
        ViewDocument viewDocument = (ViewDocument)object;
        String[] sRightInfo = null;
        if (_methodContext.getValue("ContainsRight", false)) {
            try {
                User loginUser = ContextHelper.getLoginUser();
                sRightInfo = new String[]{"Right", viewDocument.getRightValue(loginUser).toString()};
            }
            catch (Exception e) {
                throw new ConvertException(I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label10", "\u6784\u9020[") + viewDocument + I18NMessage.get(ViewDocumentToXML.class, "ViewDocumentToXML.label11", "]\u6743\u9650\u4fe1\u606f\u5931\u8d25!"), e);
            }
        }
        String[] sTopedInfo = null;
        try {
            sTopedInfo = new String[]{"Topped", String.valueOf(viewDocument.isTopped())};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String[][]{sTopedInfo, sRightInfo};
    }

    @Override
    protected Hashtable[] getPropertiesArray(BaseObj _baseObj, boolean _bLoadText) {
        ViewDocument viewDocument = (ViewDocument)_baseObj;
        Hashtable<String, Object> properties = _bLoadText ? viewDocument.getAllProperty() : viewDocument.getProperties();
        Hashtable chnlDocProperties = viewDocument.getChnlDocProperties();
        if (chnlDocProperties == null) {
            return new Hashtable[]{properties};
        }
        String sKey = "CRUSER";
        String sNewKey = "CHNLDOCCRUSER";
        if (chnlDocProperties.containsKey("CRUSER")) {
            Hashtable chnlDocPropertiesNew = (Hashtable)chnlDocProperties.clone();
            Object value = chnlDocPropertiesNew.get("CRUSER");
            chnlDocPropertiesNew.remove("CRUSER");
            chnlDocPropertiesNew.put("CHNLDOCCRUSER", value);
            return new Hashtable[]{properties, chnlDocPropertiesNew};
        }
        return new Hashtable[]{properties, chnlDocProperties};
    }

    @Override
    protected Element makeElementFromBaseObj(MethodContext _methodContext, String _sTagName, BaseObj _baseObj, boolean _bLoadText, String[] _pSelectFields) throws ConvertException {
        boolean bLoadText = _bLoadText || _methodContext.getValue("LoadText", false);
        return super.makeElementFromBaseObj(_methodContext, _sTagName, _baseObj, bLoadText, _pSelectFields);
    }
}

