/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.FlowContentFactory;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.IFlowServer;
import com.trs.cms.process.definition.Flow;
import com.trs.cms.process.definition.FlowNode;
import com.trs.cms.process.definition.FlowNodeBranch;
import com.trs.cms.process.definition.FlowNodes;
import com.trs.cms.process.engine.ContentProcessInfo;
import com.trs.cms.process.engine.FlowContext;
import com.trs.cms.process.engine.FlowDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.presentation.locale.LocaleServer;
import com.trs.webframework.context.MethodContext;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class WCMProcessServiceHelper {
    public static final String PARAM_FORCE_START = "force2start";

    public static void startDocumentInFlow(User _postUser, Document _document, MethodContext _oMethodContext) throws WCMException {
        int nFlowId;
        boolean bDocIntoFlow = "true".equals(_oMethodContext.getValue(PARAM_FORCE_START));
        if (!bDocIntoFlow) {
            String sDocIntoFlow = ConfigServer.getServer().getSysConfigValue("DOCADD_INTO_FLOW", "true");
            bDocIntoFlow = "true".equalsIgnoreCase(sDocIntoFlow);
        }
        String mark = _document.getPropertyAsString("FLOWPREOPERATIONMARK");
        String values = ConfigServer.getServer().getSysConfigValue("WORKFLOW_REPEATCHECK", "TRUE");
        if (!CMyString.isEmpty(mark) && "FAlSE".equalsIgnoreCase(values)) {
            return;
        }
        if (!bDocIntoFlow) {
            return;
        }
        IFlowContent content = FlowContentFactory.makeFlowContent(605, _document.getId());
        boolean bCanIntoFlow = false;
        if (content != null) {
            IFlowServer m_oFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
            ContentProcessInfo oProcessInfo = m_oFlowServer.getProcessInfoOfContent(content);
            boolean bl = bCanIntoFlow = (oProcessInfo.canInFlow() || oProcessInfo.canReInFlow()) && _document.getStatusId() != 1028;
        }
        if (!bCanIntoFlow && (nFlowId = _oMethodContext.getValue("FlowId", 0)) > 0) {
            bCanIntoFlow = true;
        }
        if (bCanIntoFlow) {
            WCMProcessServiceHelper.startDocumentInFlow(_postUser, _document, null, _oMethodContext);
        }
    }

    public static void startDocumentInFlow(User _postUser, Document _document, Flow _oFlow, MethodContext _oMethodContext) throws WCMException {
        IFlowServer flowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        IFlowContent flowContent = FlowContentFactory.makeFlowContent(_document);
        int nFlowId = _oMethodContext.getValue("FlowId", 0);
        if (_oFlow == null && nFlowId > 0) {
            _oFlow = Flow.findById(nFlowId);
            _document.setAttribute("FlowId", String.valueOf(nFlowId));
            _document.save();
        }
        if (_oFlow != null) {
            flowContent.setFlow(_oFlow);
        }
        FlowContext flowContext = null;
        String reflow = _oMethodContext.getValue("reflow");
        String startInFlow = _oMethodContext.getValue("startInFlow");
        if (_oMethodContext.getValue("DefaultFlowModal", true)) {
            if (flowContent.getOwnerFlow() == null) {
                if (reflow != null && reflow.equals("true") || startInFlow != null && startInFlow.equals("true")) {
                    throw new WCMException(I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label13", "\u6587\u6863\u6240\u5728\u7684\u680f\u76ee\u6ca1\u6709\u914d\u7f6e\u5de5\u4f5c\u6d41\uff01"));
                }
                return;
            }
            String oToUserIds = _oMethodContext.getValue("ToUserIds");
            String _sPostDesc = _oMethodContext.getValue("PostDesc");
            String sNotifyTypes = _oMethodContext.getValue("NotifyTypes");
            if (reflow != null && reflow.equals("true") || startInFlow != null && startInFlow.equals("true")) {
                String[] toUserId = null;
                if (!oToUserIds.equals("")) {
                    toUserId = oToUserIds.split(",");
                }
                Users oUsers = new Users(null);
                if (toUserId != null) {
                    for (int i = 0; i < toUserId.length; ++i) {
                        User oUser = User.findById(Integer.parseInt(toUserId[i]));
                        oUsers.addElement(oUser);
                    }
                }
                flowContext = new FlowContext(_postUser, flowContent, _sPostDesc, oUsers, null);
                flowContext.setNotifyTypes(sNotifyTypes);
            } else {
                flowContext = new FlowContext(_postUser, flowContent);
            }
        } else {
            throw new WCMException("Not Implement!");
        }
        flowContext.setPostDesc(I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label1", "\u7cfb\u7edf\u6839\u636e\u680f\u76ee\u5de5\u4f5c\u6d41\u914d\u7f6e\u81ea\u52a8\u9a71\u52a8\u6d41\u8f6c\uff01"));
        flowServer.submitTo(flowContext);
    }

    public static void startDocumentInFlow(User _postUser, Document _document, boolean _bUseDefaultFlowMode) throws WCMException {
        if (!_bUseDefaultFlowMode) {
            throw new WCMException("Not Implement!");
        }
        WCMProcessServiceHelper.startDocumentInFlow(_postUser, _document, new HashMap(0));
    }

    public static void startDocumentInFlow(User _postUser, Document _document, Map _hFlowContextInfo) throws WCMException {
        IFlowServer flowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        IFlowContent flowContent = FlowContentFactory.makeFlowContent(_document);
        FlowContext flowContext = null;
        if (_hFlowContextInfo == null || _hFlowContextInfo.size() == 0) {
            if (flowContent.getOwnerFlow() == null) {
                return;
            }
            flowContext = new FlowContext(_postUser, flowContent);
            flowContext.setPostDesc(I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label1", "\u7cfb\u7edf\u6839\u636e\u680f\u76ee\u5de5\u4f5c\u6d41\u914d\u7f6e\u81ea\u52a8\u9a71\u52a8\u6d41\u8f6c\uff01"));
        } else {
            flowContext = WCMProcessServiceHelper.createFlowContextFrom(_hFlowContextInfo, _postUser, flowContent);
        }
        flowServer.submitTo(flowContext);
    }

    private static FlowContext createFlowContextFrom(Map _hFlowContextInfo, User _loginUser, IFlowContent _content) throws WCMException {
        Users toUsers = null;
        String sToUserIds = (String)_hFlowContextInfo.get("ToUserIds");
        if (sToUserIds != null && sToUserIds.length() != 0) {
            toUsers = Users.findByIds(null, sToUserIds);
        }
        FlowContext context = new FlowContext(_loginUser, _content);
        context.setCurrUser(_loginUser);
        context.setPostUser(_loginUser);
        context.setPostDesc((String)_hFlowContextInfo.get("PostDesc"));
        context.setToUsers(toUsers);
        context.setNotifyTypes((String)_hFlowContextInfo.get("NotifyTypes"));
        return context;
    }

    public static void validateWorkFlowRight(User _loginUser, BaseObj _content, int _nFlowDocId, int _nActionIndex, String _sOperDesc) throws WCMException {
        FlowNode currNode;
        FlowDoc flowDoc = FlowDoc.findById(_nFlowDocId);
        if (flowDoc == null) {
            throw new WCMException(200006, I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label3", "\u6307\u5b9a\u7684\u8f68\u8ff9\u4e0d\u5b58\u5728\uff01[FlowDocId=") + _nFlowDocId + "]");
        }
        if (_content == null) {
            throw new WCMException(200006, I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label4", "\u6307\u5b9a\u7684\u5185\u5bb9\u4e0d\u5b58\u5728\uff01[FlowDocId=") + _nFlowDocId + "]");
        }
        if (_content.getId() == 0) {
            _content = flowDoc.getFlowContent().getSubinstance();
        }
        if (flowDoc.getContentType() != _content.getWCMType() || flowDoc.getContentId() != _content.getId()) {
            throw new WCMException(I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label5", "\u60a8\u662f\u641e\u9b3c\uff0c\u90a3\u662f\u4e0d\u53ef\u80fd\u7684\uff01[FlowDocId=") + flowDoc.getId() + ",Type=" + flowDoc.getContentType() + ",Id=" + flowDoc.getId() + "][ContentType=" + _content.getWCMType() + ", Id=" + _content.getId() + "]");
        }
        if (flowDoc.getToUserId() != _loginUser.getId()) {
            if (_nActionIndex >= 0) {
                throw new WCMException(I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label6", "\u4e8b\u52a1\u5df2\u7ecf\u88ab\u5904\u7406,\u60a8\u4e0d\u80fd\u518d\u8fdb\u884c\u3010") + _sOperDesc + I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label7", "\u3011\u64cd\u4f5c"));
            }
            if (!flowDoc.getPostUserName().equals(_loginUser.getName())) {
                throw new WCMException(I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label8", "\u8fd9\u4e2a\u4e8b\u52a1\u4e0d\u662f\u60a8\u5904\u7406\u7684\uff01[") + flowDoc.getToUserId() + "]");
            }
        }
        if ((currNode = flowDoc.getNode()) == null) {
            throw new WCMException(200006, I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label9", "\u6307\u5b9a\u7684\u8282\u70b9\u4e0d\u5b58\u5728\uff01[NodeId=") + flowDoc.getNodeId() + "]");
        }
        try {
            if (currNode.isStartNode() && _content.getPropertyAsString("CRUSER").equalsIgnoreCase(flowDoc.getToUserNames())) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (_nActionIndex >= 0 && !currNode.isCanDoWithDoc(_nActionIndex)) {
            throw new WCMException(1002, I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label10", "\u60a8\u4e0d\u80fd\u8fdb\u884c[") + _sOperDesc + I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label11", "]\u64cd\u4f5c\uff01"));
        }
    }

    public static boolean hasFlowingActionRight(User _loginUser, int _nFlowdocId, int _nRightIndex) throws WCMException {
        FlowNode currNode;
        FlowDoc flowDoc = FlowDoc.findById(_nFlowdocId);
        if (flowDoc == null) {
            return false;
        }
        int nActionIndex = -1;
        switch (_nRightIndex) {
            case 34: {
                nActionIndex = -1;
                break;
            }
            case 32: {
                nActionIndex = 0;
                break;
            }
            case 33: {
                nActionIndex = 1;
                break;
            }
            case 39: {
                nActionIndex = 2;
                break;
            }
            default: {
                return false;
            }
        }
        if (flowDoc.getToUserId() != _loginUser.getId()) {
            if (nActionIndex >= 0) {
                return false;
            }
            if (!flowDoc.getPostUserName().equals(_loginUser.getName())) {
                return false;
            }
        }
        if ((currNode = flowDoc.getNode()) == null) {
            return false;
        }
        return nActionIndex < 0 || currNode.isCanDoWithDoc(nActionIndex);
    }

    public static Map makeFlowContextInfoMap(String _sFlowContextInfo) {
        if (CMyString.isEmpty(_sFlowContextInfo)) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(5);
        StringTokenizer stAttributes = null;
        stAttributes = new StringTokenizer(_sFlowContextInfo, ";");
        while (stAttributes.hasMoreElements()) {
            String sTemp = stAttributes.nextToken();
            int nPose = sTemp.indexOf("=");
            if (nPose <= 0) continue;
            String sName = sTemp.substring(0, nPose);
            String sValue = sTemp.substring(nPose + 1);
            result.put(sName, sValue);
        }
        return result;
    }

    public static String makeFlowContextInfo(Flow _flow) throws WCMException {
        String sToUsersCreator;
        FlowNodeBranch branch;
        if (_flow == null) {
            return "";
        }
        FlowNode stNode = FlowNode.findByName(_flow.getId(), _flow.getStartNodeName());
        FlowNodes nodes = stNode.getNextNodes(null);
        FlowNode firstNode = null;
        if (nodes == null || nodes.size() == 0 || (firstNode = (FlowNode)nodes.getAt(0)) == null) {
            throw new WCMException(_flow.toString() + I18NMessage.get(WCMProcessServiceHelper.class, "WCMProcessServiceHelper.label12", "\u6ca1\u6709\u7b2c\u4e00\u4e2a\u63a5\u6536\u8282\u70b9\uff0c\u6587\u6863\u65e0\u6cd5\u6295\u5165\u6d41\u8f6c\uff01"));
        }
        StringBuffer sb = new StringBuffer();
        sb.append(WCMProcessServiceHelper.makeXMLNode("FirstNodeName", firstNode.getName()));
        Users users = firstNode.getOperUsers(null, true);
        if (users != null && users.size() > 0) {
            String sUsersInfo = "";
            for (int i = 0; i < users.size(); ++i) {
                User user = (User)users.getAt(i);
                sUsersInfo = sUsersInfo + "<User TrueName=\"" + user.getTrueName() + "\" UserName=\"" + user.getName() + "\" UserId=\"" + user.getId() + "\"/>";
            }
            sb.append(WCMProcessServiceHelper.makeXMLNode("Users", sUsersInfo, false));
        }
        if ((branch = stNode.getBranchTo(null, firstNode)) != null) {
            sb.append(WCMProcessServiceHelper.makeXMLNode("NotifyStyles", branch.getNotifyTypes()));
        }
        if (!CMyString.isEmpty(sToUsersCreator = firstNode.getPropertyAsString("ToUsersCreator"))) {
            sb.append(WCMProcessServiceHelper.makeXMLNode("UsersCreator", sToUsersCreator));
        }
        String result = WCMProcessServiceHelper.makeXMLNode("FlowContextInfo", sb.toString(), false);
        sb.setLength(0);
        return result;
    }

    public static String makeXMLNode(String _sNodeName, String _sVal) {
        return WCMProcessServiceHelper.makeXMLNode(_sNodeName, _sVal, true);
    }

    public static String makeXMLNode(String _sNodeName, String _sVal, boolean _bWithCdata) {
        String result = "<" + _sNodeName + ">";
        result = result + (_bWithCdata ? "<![CDATA[" + CMyString.showNull(_sVal) + "]]>" : CMyString.showNull(_sVal));
        result = result + "</" + _sNodeName + ">";
        return result;
    }

    public static ContentProcessInfo makeContentProcessInfo(int _nObjType, int _nObjId) throws WCMException {
        if (_nObjType == 0 || _nObjId == 0) {
            throw new WCMException("\u4f20\u5165\u7684\u53c2\u6570\u65e0\u6548\uff01");
        }
        IFlowContent content = FlowContentFactory.makeFlowContent(_nObjType, _nObjId);
        if (content == null) {
            throw new WCMException(200006, CMyString.format(LocaleServer.getString("document.detail.show.tracing", "\u6307\u5b9a\u7684\u5185\u5bb9[Type={0} , Id={1},]\u6ca1\u6709\u627e\u5230"), new String[]{WCMTypes.getLowerObjName(_nObjType), String.valueOf(_nObjId)}));
        }
        IFlowServer m_oFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        ContentProcessInfo oProcessInfo = m_oFlowServer.getProcessInfoOfContent(content);
        return oProcessInfo;
    }

    public static boolean validCanEditProcessObject(int _nObjType, int _nObjId, User _currUser) throws WCMException {
        Users toUsers;
        String sNeedValidAuditing = ConfigServer.getServer().getSysConfigValue("NEED_VALID_IFORNOT_IN_AUDIT", "true");
        if (!"true".equalsIgnoreCase(sNeedValidAuditing)) {
            return true;
        }
        ContentProcessInfo processInfo = WCMProcessServiceHelper.makeContentProcessInfo(_nObjType, _nObjId);
        if (processInfo == null || processInfo.isEnd()) {
            return true;
        }
        String sCanEdit = ConfigServer.getServer().getSysConfigValue("CANEDITDOC_IF_IN_FIRST_FLOWNODE", "true");
        if ("true".equalsIgnoreCase(sCanEdit)) {
            FlowNode oPreNode;
            IFlowContent content = processInfo.getContent();
            if (content == null) {
                throw new WCMException(200006, CMyString.format(LocaleServer.getString("document.detail.show.tracing", "\u6307\u5b9a\u7684\u5185\u5bb9[Type={0} , Id={1},]\u6ca1\u6709\u627e\u5230"), new String[]{WCMTypes.getLowerObjName(_nObjType), String.valueOf(_nObjId)}));
            }
            FlowDoc currFlowdoc = content.getFlowDoc();
            if (currFlowdoc != null && (oPreNode = currFlowdoc.getPreNode()) != null && oPreNode.isStartNode()) {
                return true;
            }
        }
        return (toUsers = processInfo.getCurrToUses()) != null && toUsers.getById(_currUser.getId()) != null;
    }

    public static void startContentInFlow(User _currUser, CMSObj _currObj, Flow _oFlow) throws WCMException {
        WCMProcessServiceHelper.startContentInFlow(_currUser, _currObj, _oFlow, new HashMap(0));
    }

    public static void startContentInFlow(User _currUser, CMSObj _currObj) throws WCMException {
        WCMProcessServiceHelper.startContentInFlow(_currUser, _currObj, null, new HashMap(0));
    }

    public static void startContentInFlow(User _currUser, CMSObj _currObj, Map _hFlowContextInfo) throws WCMException {
        WCMProcessServiceHelper.startContentInFlow(_currUser, _currObj, null, _hFlowContextInfo);
    }

    public static void startContentInFlow(User _currUser, CMSObj _currObj, Flow _oFlow, Map _hFlowContextInfo) throws WCMException {
        IFlowServer flowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        IFlowContent flowContent = FlowContentFactory.makeFlowContent(_currObj);
        if (_oFlow != null) {
            flowContent.setFlow(_oFlow);
        }
        if (flowContent.getOwnerFlow() == null) {
            return;
        }
        FlowContext flowContext = null;
        if (_hFlowContextInfo == null || _hFlowContextInfo.size() == 0) {
            flowContext = new FlowContext(_currUser, flowContent);
            flowContext.setPostDesc("\u7cfb\u7edf\u6839\u636e\u5de5\u4f5c\u6d41\u914d\u7f6e\u81ea\u52a8\u9a71\u52a8\u6d41\u8f6c\uff01");
        } else {
            flowContext = WCMProcessServiceHelper.createFlowContextFrom(_hFlowContextInfo, _currUser, flowContent);
        }
        flowServer.submitTo(flowContext);
    }

    public static void startContentInFlow(User _postUser, CMSObj _currObj, MethodContext _oMethodContext) throws WCMException {
        boolean bDocIntoFlow = "true".equals(_oMethodContext.getValue(PARAM_FORCE_START));
        if (!bDocIntoFlow) {
            String sDocIntoFlow = ConfigServer.getServer().getSysConfigValue("ADD_INTO_FLOW", "true");
            bDocIntoFlow = "true".equalsIgnoreCase(sDocIntoFlow);
        }
        if (!bDocIntoFlow) {
            return;
        }
        WCMProcessServiceHelper.startContentInFlow(_postUser, _currObj, null, _oMethodContext);
    }

    public static void startContentInFlow(User _postUser, CMSObj _currObj, Flow _oFlow, MethodContext _oMethodContext) throws WCMException {
        IFlowServer flowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
        IFlowContent flowContent = FlowContentFactory.makeFlowContent(_currObj);
        int nFlowId = _oMethodContext.getValue("FlowId", 0);
        if (_oFlow == null && nFlowId > 0) {
            _oFlow = Flow.findById(nFlowId);
        }
        if (_oFlow != null) {
            flowContent.setFlow(_oFlow);
        }
        FlowContext flowContext = null;
        String reflow = _oMethodContext.getValue("reflow");
        String startInFlow = _oMethodContext.getValue("startInFlow");
        if (flowContent.getOwnerFlow() == null) {
            throw new WCMException("\u5f53\u524d\u6d41\u8f6c\u5bf9\u8c61[type:" + _currObj.getWCMType() + ",id:" + _currObj.getId() + "]\u6ca1\u6709\u8bbe\u7f6e\u5de5\u4f5c\u6d41");
        }
        String oToUserIds = _oMethodContext.getValue("ToUserIds");
        String _sPostDesc = _oMethodContext.getValue("PostDesc");
        String sNotifyTypes = _oMethodContext.getValue("NotifyTypes");
        if (reflow != null && reflow.equals("true") || startInFlow != null && startInFlow.equals("true")) {
            String[] toUserId = null;
            if (!oToUserIds.equals("")) {
                toUserId = oToUserIds.split(",");
            }
            Users oUsers = new Users(null);
            if (toUserId != null) {
                for (int i = 0; i < toUserId.length; ++i) {
                    User oUser = User.findById(Integer.parseInt(toUserId[i]));
                    oUsers.addElement(oUser);
                }
            }
            flowContext = new FlowContext(_postUser, flowContent, _sPostDesc, oUsers, null);
            flowContext.setNotifyTypes(sNotifyTypes);
        } else {
            flowContext = new FlowContext(_postUser, flowContent);
            flowContext.setPostDesc("\u7cfb\u7edf\u6839\u636e\u5de5\u4f5c\u6d41\u914d\u7f6e\u81ea\u52a8\u9a71\u52a8\u6d41\u8f6c\uff01");
        }
        flowServer.submitTo(flowContext);
    }

    public static boolean canDocumentIntoFlow(int _nDocumentId) throws WCMException {
        if (_nDocumentId <= 0) {
            return false;
        }
        Document _document = Document.findById(_nDocumentId);
        if (_document == null) {
            return false;
        }
        IFlowContent content = FlowContentFactory.makeFlowContent(605, _document.getId());
        boolean bCanIntoFlow = false;
        if (content != null) {
            IFlowServer m_oFlowServer = (IFlowServer)DreamFactory.createObjectById("IFlowServer");
            ContentProcessInfo oProcessInfo = m_oFlowServer.getProcessInfoOfContent(content);
            bCanIntoFlow = (oProcessInfo.canInFlow() || oProcessInfo.canReInFlow()) && _document.getStatusId() != 1028;
        }
        return bCanIntoFlow;
    }
}

