/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ContentExtendValues;
import com.trs.ajaxservice.DocumentPublishHelper;
import com.trs.ajaxservice.DocumentServiceProvider;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.ajaxservice.WCMDocumentHelper;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.ajaxservice.WebSiteHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.RightValue;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSBaseObjs;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.ExtendedField;
import com.trs.cms.content.ExtendedFields;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.element.PublishElementsListImpl;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.ContentExtFieldMgr;
import com.trs.components.wcm.content.domain.DocReplyMgr;
import com.trs.components.wcm.content.domain.DocumentExporter;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.domain.SiteMemberMgr;
import com.trs.components.wcm.content.domain.auth.DocumentAuthServer;
import com.trs.components.wcm.content.domain.transmit.IDocumentTransmitor;
import com.trs.components.wcm.content.domain.transmit.IDocumentTransmitorFactory;
import com.trs.components.wcm.content.persistent.Appendix;
import com.trs.components.wcm.content.persistent.Appendixes;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.ContentExtField;
import com.trs.components.wcm.content.persistent.ContentExtFields;
import com.trs.components.wcm.content.persistent.ContentLink;
import com.trs.components.wcm.content.persistent.ContentLinks;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.content.persistent.Relations;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.content.trsserver.DatasFromTRSServer;
import com.trs.components.wcm.resource.DocLevel;
import com.trs.components.wcm.resource.Status;
import com.trs.index.LuceneContext;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMRightTypes;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.config.ConfigConstants;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMy3WLib;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.service.ISearcherService;
import com.trs.service.impl.SearcherTool;
import com.trs.wcm.photo.IImageLibMgr;
import com.trs.wcm.publish.PreviewURLSign;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IDeleteServiceProvider;
import com.trs.webframework.provider.IFindByIdServiceProvider;
import com.trs.webframework.provider.IQueryServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ViewDocumentServiceProvider
implements ISelfDefinedServiceProvider,
IDeleteServiceProvider,
IQueryServiceProvider,
IFindByIdServiceProvider {
    private static Logger logger = Logger.getLogger(ViewDocumentServiceProvider.class);
    private DocumentMgr m_oDocumentMgr = null;
    private PublishServer m_oPublishServer = PublishServer.getInstance();
    private static final int TRANSMIT_COPY = 1;
    private static final int TRANSMIT_QUOTE = 2;
    private static final int TRANSMIT_MIRROR = 3;
    private static final String GET_CRUSER_SQL = "select CrUser from WCMDocument where DocId=?";
    private RelationMgr m_oRelationMgr = null;
    private AppendixMgr m_oAppendixMgr = null;
    private DocReplyMgr m_oDocReplyMgr = null;
    private ContentExtFieldMgr m_oExtFieldMgr = null;
    private IImageLibMgr m_oImageLibMgr = null;
    private IDocumentTransmitorFactory m_oDocumentTransmitorFactory = null;
    private static String sQueryLeafChannelMode = "QUERY_LEAF_CHANNEL_MODE";
    public static final String KEY_PRIVATE_PREVIEW_ACCESS = ConfigConstants.DIR_APPROOT + "private_platform_log.key";

    public ViewDocumentServiceProvider() {
        this.m_oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        this.m_oRelationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");
        this.m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        this.m_oDocReplyMgr = (DocReplyMgr)DreamFactory.createObjectById("DocReplyMgr");
        this.m_oExtFieldMgr = (ContentExtFieldMgr)DreamFactory.createObjectById("ContentExtFieldMgr");
        this.m_oImageLibMgr = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
        this.m_oDocumentTransmitorFactory = (IDocumentTransmitorFactory)DreamFactory.createObjectById("IDocumentTransmitorFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeStatus(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Status status = Status.findById(_methodContext.getValue("StatusId", 0));
        if (status == null) {
            throw new WCMException(1100, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label1", "\u6307\u5b9a\u7684\u6587\u6863\u72b6\u6001\u4e0d\u5b58\u5728\uff01"));
        }
        this.validateRight(loginUser, _methodContext.getObjectIds(), status.getRightIndex(), I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label2", "\u6539\u53d8\u6587\u6863\u72b6\u6001\u4e3a[") + status.getDisp() + "]");
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        boolean bExcludeTrashed = _methodContext.getValue("ExcludeTrashed", false);
        ContextParameters.set0(chnlDocs.size() > 1);
        try {
            int nSize = chnlDocs.size();
            for (int i = 0; i < nSize; ++i) {
                ChnlDoc chnldoc = (ChnlDoc)chnlDocs.getAt(i);
                if (chnldoc == null || chnldoc.getStatusId() == 1028) continue;
                if (bExcludeTrashed && chnldoc.getStatusId() < 0) {
                    throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label3", "[\u6587\u6863-") + chnldoc.getId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label4", "]\u5c1a\u5728\u5e9f\u7a3f\u7bb1\u4e2d\uff0c\u60a8\u6682\u65f6\u65e0\u6cd5\u5bf9\u5176\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01"));
                }
                this.m_oDocumentMgr.changeStatus(status.getId(), chnldoc);
            }
        }
        finally {
            ContextParameters.get0();
        }
    }

    public Reports copy(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sToChannelIds = _methodContext.getValue("ToChannelIds");
        Channels toChannels = Channels.findByIds(loginUser, sToChannelIds);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        return this.transmit(loginUser, chnlDocs, toChannels, 1);
    }

    public Reports quote(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sToChannelIds = _methodContext.getValue("ToChannelIds");
        String isPhoto = _methodContext.getValue("isPhoto");
        Channels toChannels = Channels.findByIds(loginUser, sToChannelIds);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        return this.transmit(loginUser, chnlDocs, toChannels, 2, isPhoto);
    }

    public Reports mirror(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sToChannelIds = _methodContext.getValue("ToChannelIds");
        Channels toChannels = Channels.findByIds(loginUser, sToChannelIds);
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        return this.transmit(loginUser, chnlDocs, toChannels, 3);
    }

    public Reports move(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel toChannel = this.findChannelById(_methodContext.getValue("ToChannelId", 0));
        String isPhoto = _methodContext.getValue("isPhoto");
        String sEntryName = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label19", "\u6587\u6863");
        if (isPhoto != null && isPhoto.trim().equals("true")) {
            sEntryName = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label74", "\u56fe\u7247");
        }
        boolean bIsCluster = false;
        bIsCluster = toChannel.isCluster();
        String sChnlInfo = toChannel.getId() + ",Name=" + toChannel.getDispDesc();
        if (!bIsCluster && !this.hasRight(loginUser, toChannel, 31)) {
            throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label5", "\u79fb\u52a8\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u76ee\u6807\u680f\u76ee\u4e0b\u521b\u5efa{1}[ID={0}]!"), new String[]{sChnlInfo, sEntryName}), null);
        }
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        ContextParameters.set0(chnlDocs.size() > 1);
        return this.move(loginUser, chnlDocs, toChannel, isPhoto);
    }

    private ContentLinks getContentLinks(User loginUser, Channel channel) throws Throwable {
        this.validateRight(loginUser, channel, 13, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label6", "\u83b7\u53d6\u5185\u5bb9\u8d85\u94fe\u63a5\u7684\u4fe1\u606f"));
        int nLinkType = 0;
        try {
            String sLinkType = channel.getAttributeValue("ContentLinkType");
            nLinkType = Integer.parseInt(sLinkType);
        }
        catch (NumberFormatException sLinkType) {
            // empty catch block
        }
        ContentLinks links = new ContentLinks(loginUser);
        if (nLinkType <= 0) {
            return links;
        }
        WCMFilter filter = new WCMFilter("", "ContentLinkType=?", "");
        filter.addSearchValues(0, nLinkType);
        links.open(filter);
        return links;
    }

    public Reports replaceContentLink(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        this.validateRight(loginUser, _methContext.getObjectIds(), 33, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label7", "\u5220\u9664"));
        ChnlDocs chnldocs = ChnlDocs.findByIds(loginUser, _methContext.getObjectIds());
        Reports reports = new Reports(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label8", "\u6587\u6863\u70ed\u8bcd\u66ff\u6362"));
        HashMap<Integer, Object[]> oCachedInfos = new HashMap<Integer, Object[]>(1);
        int nSize = chnldocs.size();
        for (int i = 0; i < nSize; ++i) {
            Object[] contentLinksInfo;
            ChnlDoc chnldoc;
            block11: {
                Channel channel;
                chnldoc = (ChnlDoc)chnldocs.getAt(i);
                if (chnldoc == null || (channel = chnldoc.getChannel()) == null) continue;
                Integer oKey = new Integer(channel.getId());
                contentLinksInfo = (Object[])oCachedInfos.get(oKey);
                if (contentLinksInfo == null) {
                    try {
                        ContentLinks links = this.getContentLinks(loginUser, channel);
                        if (links.size() == 0) {
                            reports.addSucessedReport(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label9", "[\u680f\u76ee-") + channel.getId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label10", "]\u4e0a\u6ca1\u6709\u70ed\u8bcd\uff0c\u4e0d\u9700\u8981\u66ff\u6362."));
                            oCachedInfos.put(oKey, new Object[1]);
                            continue;
                        }
                        contentLinksInfo = new Object[2];
                        String sRegExp = "";
                        HashMap<String, ContentLink> oHashTmp = new HashMap<String, ContentLink>();
                        for (int mIdx = 0; mIdx < links.size(); ++mIdx) {
                            ContentLink oContentLink = (ContentLink)links.getAt(i);
                            if (mIdx != 0) {
                                sRegExp = sRegExp + '|';
                            }
                            sRegExp = sRegExp + oContentLink.getName();
                            oHashTmp.put(oContentLink.getName().toUpperCase(), oContentLink);
                        }
                        contentLinksInfo[0] = "(?im)(" + sRegExp + ')';
                        contentLinksInfo[1] = oHashTmp;
                        oCachedInfos.put(oKey, contentLinksInfo);
                        break block11;
                    }
                    catch (Throwable tx) {
                        reports.addFailedReport(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label11", "\u60a8\u5728[\u680f\u76ee-") + channel.getId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label12", "]\u4e0a\u6ca1\u6709\u83b7\u53d6\u66ff\u6362\u70ed\u8bcd\u7684\u6743\u9650."), tx);
                        oCachedInfos.put(oKey, new Object[0]);
                        continue;
                    }
                }
                if (contentLinksInfo.length == 0) {
                    reports.addFailedReport(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label11", "\u60a8\u5728[\u680f\u76ee-") + channel.getId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label12", "]\u4e0a\u6ca1\u6709\u83b7\u53d6\u66ff\u6362\u70ed\u8bcd\u7684\u6743\u9650."), null);
                    continue;
                }
                if (contentLinksInfo.length == 1) {
                    reports.addSucessedReport(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label9", "[\u680f\u76ee-") + channel.getId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label10", "]\u4e0a\u6ca1\u6709\u70ed\u8bcd\uff0c\u4e0d\u9700\u8981\u66ff\u6362."));
                    continue;
                }
            }
            Document document = chnldoc.getDocument();
            if (document == null) continue;
            String sHtml = document.getHtmlContent();
            sHtml = this.doCLReplace(sHtml, contentLinksInfo);
            document.setHtmlContent(sHtml);
            try {
                document.validCanEditAndLock(loginUser);
                this.m_oDocumentMgr.save(document);
                reports.addSucessedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label14", "\u6587\u6863[{0}]\u66ff\u6362\u70ed\u8bcd\u6210\u529f."), new String[]{document.getTitle()}));
                continue;
            }
            catch (WCMException ex) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label15", "\u6587\u6863[{0}]\u66ff\u6362\u70ed\u8bcd\u5931\u8d25."), new String[]{document.getTitle()}), ex);
            }
        }
        return reports;
    }

    private String doCLReplace(String _sOrigHtml, Object[] _oContentLinksInfo) {
        Pattern oPattern = Pattern.compile((String)_oContentLinksInfo[0]);
        Matcher oMatcher = oPattern.matcher(_sOrigHtml);
        String sRetVal = "";
        int nLastStartIndex = 0;
        HashMap oHash = (HashMap)_oContentLinksInfo[1];
        while (oMatcher.find()) {
            int nStartIndex = oMatcher.start();
            int nEndIndex = oMatcher.end();
            sRetVal = sRetVal + _sOrigHtml.substring(nLastStartIndex, nStartIndex);
            String sKey = oMatcher.group(0);
            ContentLink oContentLink = (ContentLink)oHash.get(sKey.toUpperCase());
            sRetVal = oContentLink != null ? sRetVal + "<a name=\"AnchorAddByWCM\" href=\"" + oContentLink.getLinkUrl() + "\" _href=\"" + oContentLink.getLinkUrl() + "\" title=\"" + oContentLink.getLinkTitle() + "\" target=\"_blank\">" + sKey + "</a>" : sRetVal + sKey;
            nLastStartIndex = nEndIndex;
        }
        sRetVal = sRetVal + _sOrigHtml.substring(nLastStartIndex);
        return _sOrigHtml;
    }

    @Override
    public void delete(MethodContext _methContext) throws Throwable {
        ChnlDocs chnldocs;
        User loginUser = this.getLoginUser();
        boolean bDrop = _methContext.getValue("Drop", false);
        int nFlowDocId = _methContext.getValue("FlowDocId", 0);
        if (nFlowDocId <= 0) {
            this.validateRight(loginUser, _methContext.getObjectIds(), 33, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label7", "\u5220\u9664"));
        }
        ContextParameters.set0((chnldocs = ChnlDocs.findByIds(loginUser, _methContext.getObjectIds())).size() > 1);
        int nSize = chnldocs.size();
        for (int i = 0; i < nSize; ++i) {
            Document document;
            Channel channel;
            ChnlDoc chnldoc = (ChnlDoc)chnldocs.getAt(i);
            if (chnldoc == null || (channel = chnldoc.getChannel()) == null || (document = chnldoc.getDocument()) == null) continue;
            if (nFlowDocId > 0) {
                WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, 1, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label7", "\u5220\u9664"));
            }
            this.m_oDocumentMgr.delete(document, channel, bDrop);
            if (document.getType() != 20 || !bDrop) continue;
            this.m_oImageLibMgr.deleteDocumentQuoteImage(document.getId());
        }
    }

    public String export(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sExportFields = _methodContext.getValue("ExportFields");
        boolean bExportExtFields = _methodContext.getValue("ExportExtFields", false);
        boolean bExportAppendix = _methodContext.getValue("ExportAppendix", false);
        boolean bExportAll = _methodContext.getValue("ExportAll", false);
        DBManager dbmanager = DBManager.getDBManager();
        if (bExportExtFields) {
            ExtendedFields fields = new ExtendedFields(loginUser);
            WCMFilter filter = new WCMFilter("", "TableName=?", "EXTFIELDID asc", "EXTFIELDID,FIELDNAME");
            filter.addSearchValues(0, "WCMDOCUMENT");
            fields.open(filter);
            StringBuffer buff = new StringBuffer(256);
            if (!CMyString.isEmpty(sExportFields)) {
                buff.append(sExportFields).append(",");
            }
            ExtendedField field = null;
            String sTableName = "WCMDOCUMENT";
            int p = fields.size();
            for (int i = 0; i < p; ++i) {
                field = (ExtendedField)fields.getAt(i);
                if (field == null || dbmanager.getFieldInfo("WCMDOCUMENT", field.getName()) == null) continue;
                buff.append(field.getName());
                buff.append(",");
            }
            sExportFields = buff.substring(0, buff.length() - 1);
        }
        Documents documents = null;
        WCMFilter oSelectFieldsFilter = new WCMFilter("", "", "", sExportFields);
        int nRightIndex = 34;
        if (bExportAll) {
            BaseChannel oSiteOrChannel = this.makeCurrChannelOrSite(_methodContext);
            this.validateRight(loginUser, oSiteOrChannel, nRightIndex, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label16", "\u5bfc\u51fa\u6587\u6863"));
            ViewDocuments viewDocuments = null;
            viewDocuments = (ViewDocuments)this.query(_methodContext);
            String sIds = "";
            for (int i = 0; i < viewDocuments.size(); ++i) {
                ViewDocument viewDocument = (ViewDocument)viewDocuments.getAt(i);
                if (viewDocument == null) continue;
                int nViewDocId = viewDocument.getId();
                sIds = sIds == "" ? sIds + nViewDocId : sIds + "," + nViewDocId;
            }
            documents = Documents.findByIds(loginUser, sIds);
            int[] docIdParam = new int[1];
            int nDocId = 0;
            String sCrUser = null;
            String loginUserName = loginUser.getName();
            RightValue rightValue = new RightValue();
            for (int i = documents.size() - 1; i >= 0; --i) {
                nDocId = documents.getIdAt(i);
                if (!DocumentAuthServer.isDefineRightOnDocument(nDocId)) continue;
                rightValue.load(loginUser, 605, nDocId, true);
                if (rightValue.isHasRight(nRightIndex)) continue;
                docIdParam[0] = nDocId;
                sCrUser = dbmanager.sqlExecuteStringQuery(GET_CRUSER_SQL, docIdParam);
                if (loginUserName.equals(sCrUser)) continue;
                documents.removeAt(i, false);
            }
        } else {
            String sObjIds = _methodContext.getObjectIds();
            if (CMyString.isEmpty(sObjIds)) {
                throw new WCMException(10, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label17", "\u6ca1\u6709\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u6587\u6863"));
            }
            this.validateRight(loginUser, sObjIds, nRightIndex, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label16", "\u5bfc\u51fa\u6587\u6863"));
            documents = this.findDocumentsByChnlDocIds(loginUser, sObjIds);
            documents.setFilter(oSelectFieldsFilter);
        }
        if (documents.isEmpty()) {
            return "no-available-documents";
        }
        DocumentExporter exporter = (DocumentExporter)DreamFactory.createObjectById("DocumentExporter");
        String sExportFile = exporter.export(documents, sExportFields, bExportAppendix);
        _methodContext.setContentTypeIsHTML();
        return sExportFile;
    }

    public Reports publish(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        ChnlDocs chnldocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        int nPublishType = _methodContext.getValue("PublishType", 8);
        String sIsPhoto = _methodContext.getValue("isPhoto");
        String sIsVideo = _methodContext.getValue("isVideo");
        String sTitle = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label18", "\u53d1\u5e03");
        String sEntryName = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label23", "\u6587\u6863");
        String sEntryNameLower = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label19", "\u6587\u6863");
        if (sIsPhoto != null && sIsPhoto.trim().equals("true")) {
            sEntryName = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label74", "\u56fe\u7247");
            sEntryNameLower = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label75", "\u56fe\u7247");
        } else if (sIsVideo != null && sIsVideo.trim().equals("true")) {
            sEntryName = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label76", "\u89c6\u9891");
            sEntryNameLower = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label77", "\u89c6\u9891");
        }
        Reports reports = new Reports(sTitle + sEntryName);
        boolean bWithdrawAll = _methodContext.getValue("withdrawall", false);
        Map<Channel, List<Document>> documentMap = this.groupByChannel(chnldocs);
        ArrayList<Document> hasRightDocuments = new ArrayList<Document>();
        StringBuffer buffNoRightTitles = new StringBuffer();
        String titleSeperator = ", ";
        for (Channel channel : documentMap.keySet()) {
            List<Document> documents = documentMap.get(channel);
            StringBuffer buffHasRightTitles = new StringBuffer();
            hasRightDocuments.clear();
            for (int index = 0; index < documents.size(); ++index) {
                Document document = documents.get(index);
                if (this.hasRight(loginUser, channel, document, 39)) {
                    hasRightDocuments.add(document);
                    buffHasRightTitles.append(document.getTitle());
                    buffHasRightTitles.append(", ");
                    continue;
                }
                buffNoRightTitles.append(document.getTitle());
                buffNoRightTitles.append(", ");
            }
            if (hasRightDocuments.isEmpty()) continue;
            if (nPublishType == 8) {
                reports = this.publishMyselfOnly(loginUser, channel, documents, nPublishType, bWithdrawAll, reports, sEntryNameLower);
                continue;
            }
            buffHasRightTitles.setLength(buffHasRightTitles.length() - ", ".length());
            try {
                boolean bResult = hasRightDocuments.size() == 1 ? this.publishDocument(loginUser, channel, (Document)hasRightDocuments.get(0), nPublishType, bWithdrawAll) : this.publishDocuments(loginUser, channel, hasRightDocuments, nPublishType, bWithdrawAll);
                if (bResult) {
                    reports.addSucessedReport(this.getI18nPublishResult(buffHasRightTitles.toString(), sEntryNameLower, true));
                    continue;
                }
                reports.addFailedReport(this.getI18nPublishResult(buffHasRightTitles.toString(), sEntryNameLower, false) + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label80", "\u53ef\u80fd\u662f\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u53d1\u5e03\uff01"), null);
            }
            catch (Exception e) {
                String errorMsg = this.getI18nPublishResult(buffHasRightTitles.toString(), sEntryNameLower, false);
                logger.error((Object)errorMsg, (Throwable)e);
                reports.addFailedReport(errorMsg + this.extractErrorMsg(e), null);
            }
        }
        if (buffNoRightTitles.length() >= 2) {
            buffNoRightTitles.setLength(buffNoRightTitles.length() - 2);
            reports.addFailedReport(this.getI18nPublishResult(buffNoRightTitles.toString(), sEntryNameLower, false) + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label80", "\u53ef\u80fd\u662f\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u53d1\u5e03\uff01"), null);
        }
        return reports;
    }

    private Reports publishMyselfOnly(User _loginUser, Channel _channel, List<Document> _documents, int _nPublishType, boolean _bWithdrawAll, Reports _reports, String _sEntryNameLower) throws Exception {
        if (_nPublishType != 8 || _documents == null || _documents.isEmpty() || _channel == null) {
            return _reports;
        }
        int len = _documents.size();
        for (int i = 0; i < len; ++i) {
            Document doc = _documents.get(i);
            if (doc == null) continue;
            try {
                boolean bResult = this.publishDocument(_loginUser, _channel, doc, _nPublishType, _bWithdrawAll);
                if (bResult) {
                    _reports.addSucessedReport(this.getI18nPublishResult(doc.getTitle(), _sEntryNameLower, true));
                    continue;
                }
                _reports.addFailedReport(this.getI18nPublishResult(doc.getTitle(), _sEntryNameLower, false) + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label80", "\u53ef\u80fd\u662f\u6ca1\u6709\u6743\u9650\u8fdb\u884c\u53d1\u5e03\uff01"), null);
                continue;
            }
            catch (Exception e) {
                String errorMsg = this.getI18nPublishResult(doc.getTitle(), _sEntryNameLower, false);
                logger.error((Object)errorMsg, (Throwable)e);
                _reports.addFailedReport(errorMsg + this.extractErrorMsg(e), null);
            }
        }
        return _reports;
    }

    private String getI18nPublishResult(String _title, String _entryName, boolean isSuccess) {
        if (isSuccess) {
            return CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label20", "\u53d1\u5e03{1}[{0}]\u6210\u529f."), new String[]{_title, _entryName});
        }
        return CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label72", "\u53d1\u5e03{1}[{0}]\u5931\u8d25\uff01"), new String[]{_title, _entryName});
    }

    private String extractErrorMsg(Exception _ex) {
        String sDetailMsg = _ex.getMessage();
        int nPos = sDetailMsg.lastIndexOf("[ERR-");
        if (nPos >= 0 && (nPos = sDetailMsg.indexOf(93, nPos + 1)) > 0) {
            sDetailMsg = sDetailMsg.substring(nPos + 1);
        }
        return sDetailMsg;
    }

    private Map<Channel, List<Document>> groupByChannel(ChnlDocs _chnldocs) throws WCMException {
        HashMap<Channel, List<Document>> documentMap = new HashMap<Channel, List<Document>>();
        int nSize = _chnldocs.size();
        for (int i = 0; i < nSize; ++i) {
            Document document;
            Channel channel;
            ChnlDoc chnldoc = (ChnlDoc)_chnldocs.getAt(i);
            if (chnldoc == null || (channel = chnldoc.getChannel()) == null || (document = chnldoc.getDocument()) == null) continue;
            ArrayList<Document> documents = (ArrayList<Document>)documentMap.get(channel);
            if (documents == null) {
                documents = new ArrayList<Document>();
                documentMap.put(channel, documents);
            }
            documents.add(document);
        }
        return documentMap;
    }

    private boolean publishDocument(User loginUser, Channel _channel, Document _document, int _nPublishType, boolean _bWithAll) throws WCMException {
        if (!this.hasRight(loginUser, _channel, _document, 39)) {
            return false;
        }
        if (_nPublishType == 7) {
            Documents documents = new Documents(loginUser, 1, 1);
            documents.addElement(_document);
            DocumentPublishHelper.delete(documents, _channel, _bWithAll);
            return true;
        }
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_channel);
        IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(_document);
        content.setFolder(folder);
        this.m_oPublishServer.publishContent(content, _nPublishType);
        return true;
    }

    private boolean publishDocuments(User loginUser, Channel _channel, List<Document> _documents, int _nPublishType, boolean _bWithAll) throws Exception {
        PublishElementsListImpl list = new PublishElementsListImpl();
        Documents toRecallPublishDocs = new Documents(loginUser, _documents.size(), _documents.size());
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_channel);
        for (int index = 0; index < _documents.size(); ++index) {
            Document document = _documents.get(index);
            if (!this.hasRight(loginUser, _channel, document, 39)) continue;
            if (_nPublishType == 7) {
                toRecallPublishDocs.addElement(document);
                continue;
            }
            IPublishContent content = (IPublishContent)PublishElementFactory.makeElementFrom(document);
            content.setFolder(folder);
            list.add(content);
        }
        if (_nPublishType == 7) {
            DocumentPublishHelper.delete(toRecallPublishDocs, _channel, _bWithAll);
        } else {
            this.m_oPublishServer.publishContents(list, folder, _nPublishType);
        }
        return true;
    }

    private Reports transmit(User _loginUser, ChnlDocs _chnldocs, Channels _toChannels, int _nTransmitType) throws WCMException {
        return this.transmit(_loginUser, _chnldocs, _toChannels, _nTransmitType, "false");
    }

    private Reports transmit(User _loginUser, ChnlDocs _chnldocs, Channels _toChannels, int _nTransmitType, String _sIsPhoto) throws WCMException {
        String sTransmitDesc = this.makeTransmitDesc(_nTransmitType);
        String sEntryName = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label23", "\u6587\u6863");
        String sEntryNameLower = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label19", "\u6587\u6863");
        if (_sIsPhoto != null && _sIsPhoto.trim().equals("true")) {
            sEntryName = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label74", "\u56fe\u7247");
            sEntryNameLower = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label75", "\u56fe\u7247");
        }
        Reports reports = new Reports(sTransmitDesc + sEntryName);
        if (!_loginUser.isAdministrator()) {
            for (int j = _toChannels.size() - 1; j >= 0; --j) {
                Channel toChannel = (Channel)_toChannels.getAt(j);
                if (toChannel == null) {
                    reports.addFailedReport(sTransmitDesc + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label24", "\u5931\u8d25:\u680f\u76ee[ID=") + _toChannels.getIdAt(j) + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label25", "]\u6ca1\u6709\u627e\u5230!"), null);
                    _toChannels.removeAt(j, false);
                    continue;
                }
                if (toChannel.isCluster() || AuthServer.hasRight(_loginUser, (CMSObj)toChannel, 31)) continue;
                reports.addFailedReport(sTransmitDesc + CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label26", "\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u5728\u680f\u76ee\u4e0b\u521b\u5efa{0}["), new String[]{sEntryNameLower}) + toChannel + "].", null);
                _toChannels.removeAt(j, false);
            }
        }
        for (int i = _chnldocs.size() - 1; i >= 0; --i) {
            ChnlDoc chnldoc = (ChnlDoc)_chnldocs.getAt(i);
            if (chnldoc == null) {
                reports.addFailedReport(sTransmitDesc + CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label27", "\u5931\u8d25:{0}[ID="), new String[]{sEntryName}) + _chnldocs.getIdAt(i) + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label25", "]\u6ca1\u6709\u627e\u5230!"), null);
                continue;
            }
            Channel fromChannel = chnldoc.getChannel();
            if (fromChannel == null) {
                reports.addFailedReport(sTransmitDesc + CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label28", "\u5931\u8d25:{0}\u7684\u680f\u76ee[Id="), new String[]{sEntryName}) + chnldoc.getChannelId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label29", "]\u4e0d\u5b58\u5728!"), null);
                continue;
            }
            Document fromDocument = chnldoc.getDocument();
            if (fromDocument == null) {
                reports.addFailedReport(sTransmitDesc + CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label30", "\u5931\u8d25:{0}[Id="), new String[]{sEntryName}) + chnldoc.getDocId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label29", "]\u4e0d\u5b58\u5728!"), null);
                continue;
            }
            if (!this.hasRight(_loginUser, fromChannel, fromDocument, 34)) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label31", "\u5f15\u7528\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u6d4f\u89c8{0}[Id="), new String[]{sEntryNameLower}) + fromDocument.getId() + ",Title=" + fromDocument.getTitle() + "]!", null);
                continue;
            }
            int nChannelCount = _toChannels.size();
            for (int j = 0; j < nChannelCount; ++j) {
                Channel toChannel = (Channel)_toChannels.getAt(j);
                if (toChannel == null) {
                    reports.addFailedReport(sTransmitDesc + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label24", "\u5931\u8d25:\u680f\u76ee[ID=") + _toChannels.getIdAt(j) + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label25", "]\u6ca1\u6709\u627e\u5230!"), null);
                    continue;
                }
                this.transmit(fromChannel, fromDocument, toChannel, _nTransmitType, reports, _sIsPhoto);
            }
        }
        return reports;
    }

    private void transmit(Channel _fromChannel, Document _fromDocument, Channel _toChannel, int _nTransmitType, Reports reports) {
        this.transmit(_fromChannel, _fromDocument, _toChannel, _nTransmitType, reports, "false");
    }

    private void transmit(Channel _fromChannel, Document _fromDocument, Channel _toChannel, int _nTransmitType, Reports reports, String _sIsPhoto) {
        String sEntryName = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label19", "\u6587\u6863");
        if (_sIsPhoto != null && _sIsPhoto.trim().equals("true")) {
            sEntryName = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label75", "\u56fe\u7247");
        }
        String sTransmitDesc = this.makeTransmitDesc(_nTransmitType);
        if (_toChannel.isVirtual()) {
            sTransmitDesc = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label32", "\u5f15\u7528");
        }
        try {
            IDocumentTransmitor transmitor = this.m_oDocumentTransmitorFactory.getTransmitor(_fromDocument);
            Report report = null;
            switch (_nTransmitType) {
                case 1: {
                    report = transmitor.copy(_fromChannel, _fromDocument, _toChannel);
                    reports.addReport(report);
                    break;
                }
                case 2: {
                    report = transmitor.quote(_fromChannel, _fromDocument, _toChannel);
                    reports.addReport(report);
                    break;
                }
                case 3: {
                    report = transmitor.mirror(_fromChannel, _fromDocument, _toChannel);
                    reports.addReport(report);
                }
            }
        }
        catch (Throwable e) {
            reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label73", "{0}{4}[{1}]\u5230\u680f\u76ee[{2}][ID={3}]\u5931\u8d25!"), new String[]{sTransmitDesc, _fromDocument.getTitle(), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId()), sEntryName}), e);
        }
    }

    private String makeTransmitDesc(int _nTransmitType) {
        String sTransmitDesc = null;
        switch (_nTransmitType) {
            case 1: {
                sTransmitDesc = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label37", "\u590d\u5236");
                break;
            }
            case 2: {
                sTransmitDesc = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label32", "\u5f15\u7528");
                break;
            }
            case 3: {
                sTransmitDesc = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label38", "\u955c\u50cf");
            }
        }
        return sTransmitDesc;
    }

    private Reports move(User _loginUser, ChnlDocs _chnldocs, Channel _toChannel, String _sIsPhoto) throws WCMException {
        String sTitle = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label39", "\u79fb\u52a8");
        String sEntryName = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label23", "\u6587\u6863");
        String sEntryNameLower = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label19", "\u6587\u6863");
        if (_sIsPhoto != null && _sIsPhoto.trim().equals("true")) {
            sEntryName = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label74", "\u56fe\u7247");
            sEntryNameLower = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label75", "\u56fe\u7247");
        }
        Reports reports = new Reports(sTitle + sEntryName);
        for (int i = _chnldocs.size() - 1; i >= 0; --i) {
            ChnlDoc chnldoc = (ChnlDoc)_chnldocs.getAt(i);
            if (chnldoc == null) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label40", "\u79fb\u52a8\u5931\u8d25:{1}[ID={0}]\u6ca1\u6709\u627e\u5230!"), new String[]{String.valueOf(_chnldocs.getIdAt(i)), sEntryNameLower}), null);
                continue;
            }
            Channel fromChannel = chnldoc.getChannel();
            if (fromChannel == null) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label41", "\u79fb\u52a8\u5931\u8d25:\u5f85\u79fb\u52a8\u7684{1}\u7684\u680f\u76ee[Id={0}]\u4e0d\u5b58\u5728!"), new String[]{String.valueOf(chnldoc.getChannelId()), sEntryNameLower}), null);
                continue;
            }
            Document fromDocument = chnldoc.getDocument();
            if (fromDocument == null) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label42", "\u79fb\u52a8\u5931\u8d25:\u5f85\u79fb\u52a8\u7684{1}[Id={0}]\u4e0d\u5b58\u5728!"), new String[]{String.valueOf(chnldoc.getDocId()), sEntryNameLower}), null);
                continue;
            }
            String sDocInfo = fromDocument.getId() + ", Title=" + fromDocument.getTitle();
            if (!this.hasRight(_loginUser, fromChannel, fromDocument, WCMRightTypes.DOC_MOVE)) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label43", "\u79fb\u52a8\u5931\u8d25:\u6ca1\u6709\u6743\u9650\u79fb\u52a8{1}[Id={0}]!"), new String[]{sDocInfo, sEntryNameLower}), null);
                continue;
            }
            try {
                reports.addReport(this.m_oDocumentMgr.moveTo(fromDocument, fromChannel, _toChannel, _sIsPhoto));
                continue;
            }
            catch (Throwable e) {
                reports.addFailedReport(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label44", "\u79fb\u52a8{3}[{0}]\u5230\u680f\u76ee[{1}][ID={2}]\u5931\u8d25!"), new String[]{fromDocument.getTitle(), _toChannel.getDispDesc(), String.valueOf(_toChannel.getId()), sEntryNameLower}), e);
            }
        }
        return reports;
    }

    @Override
    public Object query(MethodContext _methContext) throws Exception {
        String methodname;
        User loginUser = this.getLoginUser();
        CMSBaseObjs objects = null;
        String sChannelIds = _methContext.getValue("ChannelIds");
        String sSiteIds = _methContext.getValue("SiteIds");
        int nSiteType = _methContext.getValue("SiteType", -1);
        boolean bInChannelsHost = false;
        int nRightIndex = 30;
        if (sChannelIds != null && sChannelIds.length() > 0) {
            objects = Channels.findByIds(loginUser, sChannelIds);
            bInChannelsHost = true;
        } else if (sSiteIds != null && sSiteIds.length() > 0) {
            objects = WebSites.findByIds(loginUser, sSiteIds);
        } else if (nSiteType >= 0) {
            objects = WebSiteHelper.getWebSitesByType(loginUser, nSiteType, null);
        } else {
            WebSites webSites = WebSites.openWCMObjs(ContextHelper.getLoginUser(), null);
            SiteMemberMgr siteMgr = (SiteMemberMgr)DreamFactory.createObjectById("SiteMemberMgr");
            for (int i = 0; i < webSites.size(); ++i) {
                WebSite webSite = (WebSite)webSites.getAt(i);
                if (siteMgr.isVisible(ContextHelper.getLoginUser(), webSite)) continue;
                webSites.remove(webSite, false);
            }
            objects = webSites;
        }
        Channels oQueryChannels = null;
        boolean bAdminstrator = loginUser.isAdministrator();
        if (bInChannelsHost) {
            boolean bContainsChildren = false;
            if (_methContext.containsParameter("ContainsChildren")) {
                bContainsChildren = _methContext.getValue("ContainsChildren", false);
            } else if (objects.size() == 1) {
                bContainsChildren = ((Channel)objects.getAt(0)).isContainsChildren();
            }
            oQueryChannels = this.makeChannelsWithRightOfChannels(loginUser, bAdminstrator, objects, nRightIndex, bContainsChildren);
        } else {
            oQueryChannels = this.makeChildChannelsWithRightOfSites(loginUser, bAdminstrator, nRightIndex, objects);
        }
        if (oQueryChannels.isEmpty()) {
            return new ViewDocuments(loginUser, 1, 1);
        }
        String isearcherSericeClass = ConfigServer.getServer().getSysConfigValue("TRS_SEARCHER", "SearchByTRSServerService");
        if ("SearchByLuceneService".equalsIgnoreCase(isearcherSericeClass)) {
            int i;
            List<String> list = LuceneContext.getInstance().getIndexConfig().getQuickSearchFieldList();
            ArrayList<Channel> removeChannel = new ArrayList<Channel>();
            boolean flag = false;
            for (i = oQueryChannels.size() - 1; i >= 0; --i) {
                Channel channel = (Channel)oQueryChannels.getAt(i);
                if (CMyString.isEmpty(channel.getQuery())) continue;
                oQueryChannels.remove(channel, false);
                removeChannel.add(channel);
            }
            if (oQueryChannels.size() == 0) {
                flag = true;
                for (i = 0; i < removeChannel.size(); ++i) {
                    oQueryChannels.addElement((BaseObj)removeChannel.get(i));
                }
            }
            if (flag) {
                isearcherSericeClass = "SearchBySqlService";
            } else {
                flag = true;
                for (i = 0; i < list.size(); ++i) {
                    if (CMyString.isEmpty(_methContext.getValue(list.get(i)))) continue;
                    flag = false;
                    break;
                }
                if (flag) {
                    isearcherSericeClass = "SearchBySqlService";
                }
            }
        }
        if ("QUICKQUERY".equalsIgnoreCase(methodname = _methContext.getMethodConfig().getName())) {
            isearcherSericeClass = "SearchByLuceneService";
        }
        _methContext.setValue("bInChannelsHost", bInChannelsHost);
        _methContext.setValue("objects", objects);
        _methContext.setValue("oQueryChannels", oQueryChannels);
        ISearcherService isearcherSerice = null;
        try {
            isearcherSerice = (ISearcherService)DreamFactory.createObjectById(isearcherSericeClass);
        }
        catch (Exception e) {
            logger.info((Object)"TRS_SEARCHER\u914d\u7f6e\u4fe1\u606f\u6709\u8bef");
            isearcherSerice = (ISearcherService)DreamFactory.createObjectById("SearchBySqlService");
        }
        logger.debug((Object)isearcherSerice);
        return isearcherSerice.search(_methContext);
    }

    private Channels makeChannelsWithRightOfChannels(User _loginUser, boolean _bAdminstrator, CMSBaseObjs _channels, int _nRightIndex, boolean _bContainsChildren) throws WCMException {
        Channels oQueryChannels = (Channels)_channels;
        for (int nRemoveChannelIndex = oQueryChannels.size() - 1; nRemoveChannelIndex >= 0; --nRemoveChannelIndex) {
            boolean bSuperManOnTheChannel;
            Channel channel = (Channel)oQueryChannels.getAt(nRemoveChannelIndex);
            if (channel == null) continue;
            boolean bl = bSuperManOnTheChannel = _bAdminstrator || _loginUser.getName().equals(channel.getCrUserName());
            if (bSuperManOnTheChannel) {
                if (!_bContainsChildren) continue;
                this.makeChildren(_loginUser, _bAdminstrator, _nRightIndex, oQueryChannels, channel);
                continue;
            }
            RightValue rightValue = AuthServer.getRightValue((CMSObj)channel, _loginUser);
            if (!rightValue.isHasRight(_nRightIndex)) {
                oQueryChannels.removeAt(nRemoveChannelIndex, false);
            }
            if (rightValue.getValue() <= 0L || !_bContainsChildren) continue;
            this.makeChildren(_loginUser, _bAdminstrator, _nRightIndex, oQueryChannels, channel);
        }
        return oQueryChannels;
    }

    private Channels makeChildChannelsWithRightOfSites(User _loginUser, boolean _bAdminstrator, int _nRightIndex, CMSBaseObjs _sites) throws WCMException {
        Channels oQueryChannels = new Channels(null, 200, 1);
        int nSize = _sites.size();
        for (int nSiteIndex = 0; nSiteIndex < nSize; ++nSiteIndex) {
            WebSite site = (WebSite)_sites.getAt(nSiteIndex);
            if (site == null) continue;
            WCMFilter filterChannels = null;
            String sLeafMode = ConfigServer.getServer().getSysConfigValue(sQueryLeafChannelMode, "false");
            if (sLeafMode.equalsIgnoreCase("true") || sLeafMode.equals("1")) {
                String sLeafChannelsWhere = "SiteId=? and not exists(select 1 from WCMChannel b where b.SiteId=? and b.ParentId = a.ChannelId)";
                filterChannels = new WCMFilter("WCMChannel a", sLeafChannelsWhere, "");
                filterChannels.addSearchValues(site.getId());
                filterChannels.addSearchValues(site.getId());
            } else {
                String sChannelsWhere = "SiteId = ?";
                filterChannels = new WCMFilter("", sChannelsWhere, "");
                filterChannels.addSearchValues(site.getId());
            }
            Channels channels = Channels.openWCMObjs(null, filterChannels);
            if (_bAdminstrator || _loginUser.getName().equals(site.getCrUserName())) {
                if (nSiteIndex == 0) {
                    oQueryChannels = channels;
                    continue;
                }
                oQueryChannels.addWith(channels);
                continue;
            }
            int nChannelsSize = channels.size();
            for (int nChannelIndex = 0; nChannelIndex < nChannelsSize; ++nChannelIndex) {
                Channel channel = (Channel)channels.getAt(nChannelIndex);
                if (channel == null || !AuthServer.hasRight(_loginUser, (CMSObj)channel, _nRightIndex) || channel.getStatus() < 0) continue;
                oQueryChannels.addElement(channel);
            }
        }
        return oQueryChannels;
    }

    public Relations queryRelations(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Document oDocument = null;
        int nDocId = _methodContext.getValue("DocumentId", 0);
        int iChnlDocId = _methodContext.getValue("ChnlDocId", 0);
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (iChnlDocId > 0) {
            ChnlDoc oChnlDoc = ChnlDoc.findById(iChnlDocId);
            oDocument = Document.findById(oChnlDoc.getDocId());
            if (nFlowDocId == 0 && !DocumentAuthServer.hasRight(loginUser, oChnlDoc, 34)) {
                throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label53", "\u60a8[{0}]\u5bf9\u6587\u6863[{1}]\u6ca1\u6709\u6743\u9650\u8fdb\u884c{2}"), new String[]{loginUser.toString(), nDocId + "", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label46", "\u83b7\u53d6\u76f8\u5173\u6587\u6863")}));
            }
        } else if (nDocId > 0) {
            oDocument = Document.findById(nDocId);
            Channel channel = oDocument.getChannel();
            if (nFlowDocId == 0 && !DocumentAuthServer.hasRight(loginUser, (BaseChannel)channel, oDocument, 34)) {
                throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label53", "\u60a8[{0}]\u5bf9\u6587\u6863[{1}]\u6ca1\u6709\u6743\u9650\u8fdb\u884c{2}"), new String[]{loginUser.toString(), nDocId + "", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label46", "\u83b7\u53d6\u76f8\u5173\u6587\u6863")}));
            }
        } else {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label47", "\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5,\u6ca1\u6709\u6307\u5b9aChnlDocId\u6216DocumentId"));
        }
        if (nFlowDocId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, oDocument, nFlowDocId, -1, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label46", "\u83b7\u53d6\u76f8\u5173\u6587\u6863"));
        }
        WCMFilter extraFilter = new WCMFilter(_methodContext.getQueryFilter());
        return this.m_oRelationMgr.getRelations(oDocument, extraFilter);
    }

    public Appendixes queryAppendixes(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Document oDocument = null;
        int nDocId = _methodContext.getValue("DocumentId", 0);
        int iChnlDocId = _methodContext.getValue("ChnlDocId", 0);
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (iChnlDocId > 0) {
            ChnlDoc oChnlDoc = ChnlDoc.findById(iChnlDocId);
            oDocument = Document.findById(oChnlDoc.getDocId());
            if (nFlowDocId == 0 && !DocumentAuthServer.hasRight(loginUser, oChnlDoc, 34)) {
                throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label53", "\u60a8[{0}]\u5bf9\u6587\u6863[{1}]\u6ca1\u6709\u6743\u9650\u8fdb\u884c{2}"), new String[]{loginUser.toString(), nDocId + "", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label48", "\u83b7\u53d6\u6587\u6863\u7684\u9644\u4ef6\u4fe1\u606f")}));
            }
        } else if (nDocId > 0) {
            oDocument = Document.findById(nDocId);
            Channel channel = oDocument.getChannel();
            if (nFlowDocId == 0 && !DocumentAuthServer.hasRight(loginUser, (BaseChannel)channel, oDocument, 34)) {
                throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label53", "\u60a8[{0}]\u5bf9\u6587\u6863[{1}]\u6ca1\u6709\u6743\u9650\u8fdb\u884c{2}"), new String[]{loginUser.toString(), nDocId + "", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label48", "\u83b7\u53d6\u6587\u6863\u7684\u9644\u4ef6\u4fe1\u606f")}));
            }
        } else {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label47", "\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5,\u6ca1\u6709\u6307\u5b9aChnlDocId\u6216DocumentId"));
        }
        if (nFlowDocId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, oDocument, nFlowDocId, -1, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label48", "\u83b7\u53d6\u6587\u6863\u7684\u9644\u4ef6\u4fe1\u606f"));
        }
        int nAppendixType = _methodContext.getValue("AppendixType", 60);
        nAppendixType = _methodContext.getValue("FilterType", nAppendixType);
        WCMFilter extraFilter = new WCMFilter(_methodContext.getQueryFilter());
        return this.m_oAppendixMgr.getAppendixes(oDocument, nAppendixType, extraFilter);
    }

    public ContentExtendValues queryExtendFields(MethodContext _methodContext) throws Throwable {
        Channel channel;
        User loginUser = this.getLoginUser();
        Document oDocument = null;
        int iDocId = _methodContext.getValue("DocumentId", 0);
        int iChnlDocId = _methodContext.getValue("ChnlDocId", 0);
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (iChnlDocId > 0) {
            if (nFlowDocId == 0) {
                this.validateRight(loginUser, String.valueOf(iChnlDocId), 34, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label49", "\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5"));
            }
            ChnlDoc oChnlDoc = ChnlDoc.findById(iChnlDocId);
            oDocument = Document.findById(oChnlDoc.getDocId());
        } else if (iDocId > 0) {
            oDocument = Document.findById(iDocId);
            channel = oDocument.getChannel();
            if (nFlowDocId == 0) {
                this.validateRight(loginUser, channel, 34, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label49", "\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5"));
            }
        } else {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label47", "\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5,\u6ca1\u6709\u6307\u5b9aChnlDocId\u6216DocumentId"));
        }
        if (nFlowDocId > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, oDocument, nFlowDocId, -1, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label49", "\u83b7\u53d6\u6269\u5c55\u5b57\u6bb5"));
        }
        if ((channel = oDocument.getChannel()) == null) {
            return new ContentExtendValues(loginUser);
        }
        WCMFilter filter = new WCMFilter(_methodContext.getQueryFilter());
        ContentExtFields extFields = this.m_oExtFieldMgr.getExtFields(channel, filter, false);
        ContentExtendValues extendValues = new ContentExtendValues(loginUser, extFields.size(), 1);
        int nSize = extFields.size();
        for (int i = 0; i < nSize; ++i) {
            ContentExtField extend = (ContentExtField)extFields.getAt(i);
            if (extend == null) continue;
            String sValue = oDocument.getPropertyAsString(extend.getName());
            String sTYpe = CMyString.filterForHTMLValue(extend.getAttributeValue("FIELDTYPE"));
            String[] arValues = null;
            if (sValue != null && sTYpe != null && "678".indexOf(sTYpe) != -1) {
                String sEValue = CMyString.filterForHTMLValue(extend.getAttributeValue("ENMVALUE"));
                if (CMyString.isEmpty(sEValue)) continue;
                arValues = sEValue.split("~");
                if (!CMyString.isEmpty(sValue)) {
                    String[] sDValue = sValue.split(",");
                    boolean bCheckBox = true;
                    int len = arValues.length;
                    for (int ix = 0; ix < len; ++ix) {
                        String[] arValue = this.pairSplit(arValues[ix]);
                        for (int ip = 0; ip < sDValue.length; ++ip) {
                            if (!sDValue[ip].trim().equalsIgnoreCase(arValue[1])) continue;
                            sValue = bCheckBox ? arValue[0] : sValue + "," + arValue[0];
                            bCheckBox = false;
                        }
                    }
                }
            }
            sValue = sValue + "~" + sTYpe;
            extendValues.addElement(i + 1, extend.getDesc(), extend.getName(), sValue);
        }
        return extendValues;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] pairSplit(String sPair) {
        String[] arValue = new String[]{"", ""};
        if (sPair.indexOf("`") != -1) {
            String[] tempArr = sPair.split("`");
            if (tempArr.length == 2) {
                arValue[0] = tempArr[0];
                arValue[1] = tempArr[1];
                return arValue;
            } else {
                if (tempArr.length != 1) return arValue;
                arValue[0] = arValue[1] = tempArr[0];
            }
            return arValue;
        } else {
            arValue[0] = sPair;
            arValue[1] = sPair;
        }
        return arValue;
    }

    public ViewDocuments queryRecycle(MethodContext _methContext) throws Exception {
        User loginUser = this.getLoginUser();
        CMSBaseObjs objects = null;
        String sChannelIds = _methContext.getValue("ChannelIds");
        String sSiteIds = _methContext.getValue("SiteIds");
        boolean bInChannelsHost = false;
        if (sChannelIds != null && sChannelIds.length() > 0) {
            objects = Channels.findByIds(loginUser, sChannelIds);
            bInChannelsHost = true;
        } else if (sSiteIds != null && sSiteIds.length() > 0) {
            objects = WebSites.findByIds(loginUser, sSiteIds);
        } else {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label45", "\u6ca1\u6709\u6307\u5b9a\u68c0\u7d22\u7684\u680f\u76ee[ChannelIds]\u6216\u8005\u68c0\u7d22\u7684\u7ad9\u70b9[SiteIds]\uff01"));
        }
        Channels oQueryChannels = null;
        boolean bAdminstrator = loginUser.isAdministrator();
        int nRightIndex = 30;
        if (bInChannelsHost) {
            boolean bContainsChildren = _methContext.getValue("ContainsChildren", false);
            oQueryChannels = this.makeChannelsWithRightOfChannels(loginUser, bAdminstrator, objects, nRightIndex, bContainsChildren);
        } else {
            oQueryChannels = this.makeChildChannelsWithRightOfSites(loginUser, bAdminstrator, nRightIndex, objects);
        }
        if (oQueryChannels.isEmpty()) {
            return new ViewDocuments(loginUser, 1, 1);
        }
        WCMFilter filter = new WCMFilter("", "", "");
        filter.mergeWith(_methContext.getExtraWCMFilter());
        filter.mergeWith(SearcherTool.makeTimeFilterByType(_methContext.getValue("CrTimeInterval", 0), "WCMChnlDoc.CrTime"));
        filter.mergeWith(SearcherTool.makeTimeFilterByType(_methContext.getValue("PubTimeInterval", 0), "WCMChnlDoc.DocPubTime"));
        int nFilterType = _methContext.getValue("FilterType", 0);
        filter.mergeWith(SearcherTool.makeFilterByType(loginUser, objects, nFilterType));
        ViewDocuments viewDocuments = new ViewDocuments(loginUser, 1, 1);
        viewDocuments.setSelectFields(_methContext.getValue("ChnlDocSelectFields"), _methContext.getValue("DocumentSelectFields"));
        viewDocuments.setFromRecycle(true);
        viewDocuments.setPageSize(_methContext.getPageSize());
        viewDocuments.setCurrPage(_methContext.getPageIndex());
        viewDocuments.setRightIndex(bInChannelsHost ? 33 : -1);
        if (bInChannelsHost) {
            viewDocuments.open(oQueryChannels, filter);
        } else if (loginUser.isAdministrator()) {
            viewDocuments.open(objects, filter);
        } else {
            viewDocuments.open(oQueryChannels, filter);
        }
        CPager pager = new CPager();
        pager.setItemCount(viewDocuments.size());
        pager.setPageSize(_methContext.getPageSize());
        pager.setCurrentPageIndex(_methContext.getPageIndex());
        for (int i = pager.getLastItemIndex() - 1; i >= pager.getFirstItemIndex() - 1; --i) {
            ViewDocument viewDocument = (ViewDocument)viewDocuments.getAt(i);
            if (viewDocument == null) continue;
            if (!viewDocument.hasRight(loginUser, 18) && viewDocument.hasRight(loginUser, 31) && !viewDocument.getCrUser().equals(loginUser)) {
                viewDocuments.removeAt(i, false);
            }
            if (bInChannelsHost || viewDocument.hasRight(loginUser, 33)) continue;
            viewDocuments.removeAt(i, false);
        }
        return viewDocuments;
    }

    public String preview(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sIsPhoto = _methodContext.getValue("isPhoto");
        String sIsVideo = _methodContext.getValue("isVideo");
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        String sEntryNameLower = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label19", "\u6587\u6863");
        if (sIsPhoto != null && sIsPhoto.trim().equals("true")) {
            sEntryNameLower = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label75", "\u56fe\u7247");
        } else if (sIsVideo != null && sIsVideo.trim().equals("true")) {
            sEntryNameLower = I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label77", "\u89c6\u9891");
        }
        ChnlDocs chnlDocs = ChnlDocs.findByIds(loginUser, _methodContext.getObjectIds());
        String[] pWarning = new String[1];
        HashMap<String, Object> hResult = new HashMap<String, Object>(2);
        int nURLCount = 0;
        Object[] pResult = new Object[chnlDocs.size()];
        HashMap<String, Object> hTemp = null;
        ChnlDoc chnlDoc = null;
        Document document = null;
        Channel channel = null;
        int nSize = chnlDocs.size();
        for (int i = 0; i < nSize; ++i) {
            block18: {
                document = null;
                hTemp = new HashMap<String, Object>(2);
                chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
                if (chnlDoc != null) {
                    document = chnlDoc.getDocument();
                    channel = chnlDoc.getChannel();
                }
                if (document == null) {
                    hTemp.put("Exception", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label50", "\u76f8\u5173\u6587\u6863[DocId=") + chnlDoc.getDocId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label25", "]\u6ca1\u6709\u627e\u5230!"));
                    hTemp.put("URLs", new String[0]);
                } else {
                    hTemp.put("Name", document.getTitle());
                    if (channel == null) {
                        hTemp.put("Exception", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label51", "\u76f8\u5173\u680f\u76ee[ChannelId=") + chnlDoc.getChannelId() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label25", "]\u6ca1\u6709\u627e\u5230!"));
                        hTemp.put("URLs", new String[0]);
                    } else if (nFlowDocId == 0 && !DocumentAuthServer.hasRight(loginUser, (BaseChannel)channel, document, 38)) {
                        hTemp.put("Exception", I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label52", "\u6ca1\u6709\u6743\u9650\u9884\u89c8\u6587\u6863"));
                        hTemp.put("URLs", new String[0]);
                    } else {
                        String[] pURL;
                        if (nFlowDocId > 0) {
                            try {
                                WCMProcessServiceHelper.validateWorkFlowRight(loginUser, document, nFlowDocId, -1, "\u9884\u89c8\u6587\u6863\u4fe1\u606f");
                            }
                            catch (WCMException e) {
                                hTemp.put("Exception", e.getMessage());
                                hTemp.put("URLs", new String[0]);
                                break block18;
                            }
                        }
                        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
                        IPublishContent content = PublishElementFactory.makeContentFrom(document, folder);
                        try {
                            pURL = new String[]{this.m_oPublishServer.previewContent(content, pWarning)};
                            PreviewURLSign.getUniqueSignedStrs(pURL, KEY_PRIVATE_PREVIEW_ACCESS);
                            if (pWarning[0] != null) {
                                hTemp.put("Warning", pWarning[0]);
                            }
                        }
                        catch (Exception e) {
                            pURL = new String[]{};
                            int nPos = e.getMessage().indexOf(10);
                            String sMessage = e.getMessage();
                            if (nPos > 0) {
                                sMessage = sMessage.substring(0, nPos);
                            }
                            hTemp.put("Exception", sMessage);
                            hTemp.put("ExceptionDetail", CMyException.getStackTraceText(e));
                        }
                        nURLCount += pURL.length;
                        hTemp.put("URLs", pURL);
                    }
                }
            }
            pResult[i] = hTemp;
        }
        hResult.put("Title", sEntryNameLower);
        hResult.put("URLCount", String.valueOf(nURLCount));
        hResult.put("Data", pResult);
        _methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(hResult, 0);
    }

    private boolean hasRight(User _loginUser, Channel _channel, Document _document, int _nRightIndex) throws WCMException {
        return DocumentAuthServer.hasRight(_loginUser, (BaseChannel)_channel, _document, _nRightIndex);
    }

    private boolean hasRight(User _loginUser, Channel _channel, int _nRightIndex) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return true;
        }
        return AuthServer.hasRight(_loginUser, (CMSObj)_channel, _nRightIndex);
    }

    private Channels findChannelsByChnlDocIds(User _loginUser, String _sChnlDocIds) throws WCMException {
        WCMFilter filter = new WCMFilter("WCMChnlDoc", "RecId in(" + _sChnlDocIds + ")", "", "ChnlId As ChannelId");
        return Channels.openWCMObjs(_loginUser, filter);
    }

    private Documents findDocumentsByChnlDocIds(User _loginUser, String _sChnlDocIds) throws WCMException {
        DBManager dbman = DBManager.getDBManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "select DOCID from WCMCHNLDOC where RECID=?";
        StringBuffer buff = new StringBuffer();
        try {
            conn = dbman.getConnection();
            pstmt = conn.prepareStatement(sql);
            int[] pRecIds = CMyString.splitToInt(_sChnlDocIds, ",");
            int len = pRecIds.length;
            for (int i = 0; i < len; ++i) {
                pstmt.setInt(1, pRecIds[i]);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    buff.append(',').append(rs.getInt(1));
                }
                rs.close();
            }
        }
        catch (SQLException ex) {
            throw new WCMException(40, "", ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    dbman.freeConnection(conn);
                }
                catch (Exception exception) {}
            }
        }
        if (buff.length() > 1) {
            return Documents.findByIds(_loginUser, buff.substring(1));
        }
        return new Documents(_loginUser);
    }

    private void validateRight(User _loginUser, String _sChnlDocIds, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (ViewDocuments.QUERY_ACCORD_DOCUMENT_RIGHT) {
            ViewDocuments viewDocuments = WCMDocumentHelper.findViewDocumentsByIds(_loginUser, _sChnlDocIds);
            int nSize = viewDocuments.size();
            for (int i = 0; i < nSize; ++i) {
                ViewDocument viewDocument = (ViewDocument)viewDocuments.getAt(i);
                if (viewDocument == null) continue;
                String sDocInfo = "DocId=" + viewDocument.getDocId();
                if (viewDocument.hasRight(_loginUser, _nRightIndex)) continue;
                throw new WCMException(CMyString.format(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label53", "\u60a8[{0}]\u5bf9\u6587\u6863[{1}]\u6ca1\u6709\u6743\u9650\u8fdb\u884c{2}"), new String[]{_loginUser.toString(), sDocInfo, _sOperDesc}));
            }
        } else {
            if (_loginUser.isAdministrator()) {
                return;
            }
            Channels channels = this.findChannelsByChnlDocIds(_loginUser, _sChnlDocIds);
            int nSize = channels.size();
            for (int i = 0; i < nSize; ++i) {
                Channel channel = (Channel)channels.getAt(i);
                if (channel == null) continue;
                this.validateRight(_loginUser, channel, _nRightIndex, _sOperDesc);
            }
        }
    }

    private void validateRight(User _loginUser, BaseChannel _oSiteOrChannel, int _nRightIndex, String _sOperDesc) throws WCMException {
        if (!AuthServer.hasRight(_loginUser, (CMSObj)_oSiteOrChannel, _nRightIndex)) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label56", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label57", "]\u6ca1\u6709\u6743\u9650\u5728(") + _oSiteOrChannel + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label58", ")\u4e0a\u6267\u884c[") + _sOperDesc + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label59", "]\u64cd\u4f5c\uff01"));
        }
    }

    private Channel findChannelById(int _nObjectId) throws WCMException {
        Channel channel = Channel.findById(_nObjectId);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label61", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=") + _nObjectId + "]\uff01");
        }
        return channel;
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    private void makeChildren(User _loginUser, boolean _bAdminstrator, int _nRightIndex, Channels _oRecordChannels, Channel _parent) throws WCMException {
        List<Channel> lChildren = _parent.getChildren(null);
        if (lChildren == null || lChildren.isEmpty()) {
            return;
        }
        int nSize = lChildren.size();
        for (int i = 0; i < nSize; ++i) {
            Channel child = lChildren.get(i);
            if (child == null) continue;
            if (_bAdminstrator || _loginUser.getName().equalsIgnoreCase(child.getCrUserName())) {
                _oRecordChannels.addElement(child);
                this.makeChildren(_loginUser, _bAdminstrator, _nRightIndex, _oRecordChannels, child);
                continue;
            }
            RightValue rightValue = AuthServer.getRightValue((CMSObj)child, _loginUser);
            if (rightValue.isHasRight(_nRightIndex)) {
                _oRecordChannels.addElement(child);
            }
            if (rightValue.getValue() <= 0L) continue;
            this.makeChildren(_loginUser, _bAdminstrator, _nRightIndex, _oRecordChannels, child);
        }
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel host = this.makeCurrChannelOrSite(_methodContext);
        ViewDocument viewDocument = ViewDocument.findById(host, _methodContext.getObjectId(), _methodContext.getValue("SelectFieldsOfChnlDoc"), _methodContext.getValue("SelectFieldsOfDocument"));
        if (viewDocument == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(_methodContext.getObjectId()), WCMTypes.getLowerObjName(605)}));
        }
        int nFlowDocId = _methodContext.getValue("FlowDocId", 0);
        if (nFlowDocId > 0 && _methodContext.getObjectId() > 0) {
            WCMProcessServiceHelper.validateWorkFlowRight(loginUser, Document.findById(viewDocument.getDocId()), nFlowDocId, -1, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label63", "\u67e5\u770b"));
        } else if (!viewDocument.hasRight(loginUser, 34)) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label56", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label57", "]\u6ca1\u6709\u6743\u9650\u5728(") + host + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label64", ")\u4e0a\u6267\u884c[\u6d4f\u89c8\u6587\u6863]\u64cd\u4f5c\uff01[RecId=") + viewDocument.getId() + "]");
        }
        return viewDocument;
    }

    public void restore(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        ChnlDocs oRestoreChnlDocs = null;
        BaseChannel oSiteOrChannel = null;
        boolean bRestoreAll = _methodContext.getValue("RestoreAll", false);
        if (bRestoreAll) {
            oSiteOrChannel = this.makeCurrChannelOrSite(_methodContext);
            this.validateRight(loginUser, oSiteOrChannel, 33, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label65", "\u6062\u590d\u56de\u6536\u7ad9\u7684\u6587\u6863"));
        } else {
            String sChnlDocIds = _methodContext.getObjectIds();
            this.validateRight(loginUser, sChnlDocIds, 33, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label65", "\u6062\u590d\u56de\u6536\u7ad9\u7684\u6587\u6863"));
            oRestoreChnlDocs = ChnlDocs.findByIds(loginUser, sChnlDocIds);
        }
        if (bRestoreAll) {
            this.m_oDocumentMgr.restoreAll(loginUser, oSiteOrChannel);
        } else {
            int nSize = oRestoreChnlDocs.size();
            for (int i = 0; i < nSize; ++i) {
                ChnlDoc chnldoc = (ChnlDoc)oRestoreChnlDocs.getAt(i);
                if (chnldoc == null || !chnldoc.isDeleted()) continue;
                this.m_oDocumentMgr.restore(chnldoc);
            }
        }
    }

    public void clearRecycle(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel oSiteOrChannel = this.makeCurrChannelOrSite(_methodContext);
        this.validateRight(loginUser, oSiteOrChannel, 33, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label66", "\u6e05\u7a7a\u56de\u6536\u7ad9\u7684\u6587\u6863"));
        this.m_oDocumentMgr.clearAll(loginUser, oSiteOrChannel);
    }

    private BaseChannel makeCurrChannelOrSite(MethodContext _methodContext) throws WCMException {
        int nSiteId = _methodContext.getValue("SiteID", 0);
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        if (nSiteId <= 0 && nChannelId <= 0) {
            return null;
        }
        if (nSiteId > 0 && nChannelId > 0) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label67", "\u6307\u5b9a\u7684\u53c2\u6570\u6709\u8bef\uff01\u540c\u65f6\u6307\u5b9a\u4e86\u7ad9\u70b9ID[") + nSiteId + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label68", "]\u548c\u680f\u76eeID[") + nChannelId + "]!");
        }
        BaseChannel channelOrSite = null;
        if (nSiteId > 0) {
            channelOrSite = WebSite.findById(nSiteId);
        }
        if (nChannelId > 0) {
            channelOrSite = Channel.findById(nChannelId);
            _methodContext.putContextCacheData("CurrChannel", channelOrSite);
        }
        if (channelOrSite == null) {
            throw new WCMException(I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label69", "\u6307\u5b9a\u7684\u53c2\u6570\u6709\u8bef\uff01\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u7ad9\u70b9[ID=") + nSiteId + I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label70", "]\u6216\u680f\u76ee[ID=") + nChannelId + "]!");
        }
        return channelOrSite;
    }

    public String getDocumentRefrences(MethodContext _methContext) throws Exception {
        String sDocids = "";
        String sChnlId = _methContext.getValue("ChannelIds");
        String sSiteId = _methContext.getValue("SiteIds");
        String sOperation = _methContext.getValue("operation");
        boolean bDrop = false;
        if (!CMyString.isEmpty(sOperation) && (sOperation.equalsIgnoreCase("_forcedelete") || sOperation.equalsIgnoreCase("_delete"))) {
            bDrop = true;
        }
        if (!CMyString.isEmpty(sChnlId) || !CMyString.isEmpty(sSiteId)) {
            ViewDocuments docs = this.queryRecycle(_methContext);
            if (docs == null || docs.size() == 0) {
                return null;
            }
            sDocids = docs.getIdListAsString(',');
        } else {
            sDocids = _methContext.getObjectIds();
        }
        _methContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(this.getReferencesByChnlDocIds(sDocids, bDrop), 0);
    }

    private HashMap getReferencesByChnlDocIds(String _sChnlDocIds, boolean drop) throws WCMException {
        User loginUser = this.getLoginUser();
        this.validateRight(loginUser, _sChnlDocIds, 34, I18NMessage.get(ViewDocumentServiceProvider.class, "ViewDocumentServiceProvider.label71", "\u6d4f\u89c8"));
        ChnlDocs chnldocs = ChnlDocs.findByIds(loginUser, _sChnlDocIds);
        HashMap<String, Object[]> hResult = new HashMap<String, Object[]>(1);
        Object[] pResult = new Object[chnldocs.size()];
        for (int i = 0; i < pResult.length; ++i) {
            Channel channel;
            Document document;
            ChnlDoc chnldoc = (ChnlDoc)chnldocs.getAt(i);
            if (chnldoc == null || (document = chnldoc.getDocument()) == null || (channel = document.getChannel()) == null) continue;
            Channels channels = this.m_oDocumentMgr.getQutoedChannels(document, 0, null, true);
            HashMap<String, Object> hValue = new HashMap<String, Object>(9);
            if (channels != null && !channels.isEmpty()) {
                String[] chnlDescs = new String[channels.size()];
                for (int j = 0; j < channels.size(); ++j) {
                    Channel refChnl = (Channel)channels.getAt(j);
                    if (refChnl == null) continue;
                    chnlDescs[j] = CMyString.filterForHTMLValue(refChnl.getDesc());
                }
                hValue.put("refchannels", chnlDescs);
            }
            hValue.put("docid", String.valueOf(document.getId()));
            hValue.put("doctitle", document.getTitle());
            hValue.put("docchnlid", chnldoc.getPropertyAsString("DOCCHANNEL"));
            hValue.put("channelid", chnldoc.getPropertyAsString("CHNLID"));
            hValue.put("channel", CMyString.filterForHTMLValue(channel.getDesc()));
            hValue.put("modal", String.valueOf(chnldoc.getModal()));
            WCMFilter filter = new WCMFilter("", "", "");
            if (drop && chnldoc.getModal() == 1) {
                filter.setWhere("RelatePhotoIds=?");
                filter.addSearchValues(0, String.valueOf(document.getId()));
                Appendixes appendixes = Appendixes.openWCMObjs(loginUser, filter);
                Appendix refApp = null;
                if (appendixes != null && !appendixes.isEmpty()) {
                    String[] docTitles = new String[appendixes.size()];
                    for (int j = 0; j < appendixes.size(); ++j) {
                        refApp = (Appendix)appendixes.getAt(j);
                        if (refApp == null) continue;
                        Document temp = Document.findById(refApp.getDocId());
                        docTitles[j] = CMyString.filterForHTMLValue(temp.getTitle());
                    }
                    hValue.put("refdocappendixs", docTitles);
                }
                IImageLibMgr m_libManager = (IImageLibMgr)DreamFactory.createObjectById("IImageLibMgr");
                Documents docs = m_libManager.getDocumentsQuoteImage(document.getId());
                Document doc = null;
                if (docs != null && !docs.isEmpty()) {
                    String[] docTitles = new String[docs.size()];
                    for (int j = 0; j < docs.size(); ++j) {
                        doc = (Document)docs.getAt(j);
                        if (doc == null) continue;
                        docTitles[j] = CMyString.filterForHTMLValue(doc.getTitle());
                    }
                    hValue.put("refdoccontents", docTitles);
                }
            }
            pResult[i] = hValue;
        }
        hResult.put("docinfo", pResult);
        return hResult;
    }

    public int findChnlDocId(MethodContext _methodContext) throws Throwable {
        int nChnlId;
        int nChnlDocId = _methodContext.getValue("ChnlDocId", 0);
        if (nChnlDocId != 0) {
            return nChnlDocId;
        }
        int nDocId = _methodContext.getValue("docId", 0);
        ChnlDoc chnlDoc = ChnlDoc.findByDocAndChnl(nDocId, nChnlId = _methodContext.getValue("channelId", 0));
        return chnlDoc != null ? chnlDoc.getId() : 0;
    }

    public Reports moveAll(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nFromChannelId = _methodContext.getValue("FromChannelId", 0);
        Channel fromChannel = this.findChannelById(nFromChannelId);
        Channel toChannel = this.findChannelById(_methodContext.getValue("ToChannelId", 0));
        if (toChannel.getStatus() < 0) {
            return null;
        }
        this.validateRight(loginUser, fromChannel, 56, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label37", "\u79fb\u52a8"));
        this.validateRight(loginUser, toChannel, 31, I18NMessage.get(DocumentServiceProvider.class, "DocumentServiceProvider.label38", "\u6dfb\u52a0"));
        Channels objects = Channels.findByIds(loginUser, nFromChannelId + "");
        WCMFilter currFilter = SearcherTool.getFilterFromList(_methodContext, objects);
        if (!CMyString.isEmpty(currFilter.getWhere())) {
            if (currFilter.getWhere().length() > 0) {
                currFilter.setWhere(currFilter.getWhere() + " and ( chnlId=" + nFromChannelId + ")");
            } else {
                currFilter.setWhere("( chnlId=" + nFromChannelId + ")");
            }
        }
        ViewDocuments viewDocuments = new ViewDocuments(loginUser, 1, 1);
        if (_methodContext.getPageSize() > 0) {
            viewDocuments.setPageSize(_methodContext.getPageSize());
        } else {
            viewDocuments.setPageSize(-1);
        }
        viewDocuments.open(fromChannel, currFilter);
        ContextParameters.set0(true);
        return this.m_oDocumentMgr.moveDocumentsToChannel(viewDocuments, fromChannel, toChannel);
    }

    public String cloneFile(MethodContext _methodContext) throws Throwable {
        String sSrc = _methodContext.getValue("Sourfile");
        return FilesMan.getFilesMan().copyWCMFile(sSrc, sSrc.substring(0, 2));
    }

    public String uploadImg(MethodContext _methodContext) throws Throwable {
        String _sImgSrc = _methodContext.getValue("Sourfile");
        try {
            FilesMan filesMan = FilesMan.getFilesMan();
            String sExt = CMyFile.extractFileExt(_sImgSrc);
            String sFilePathName = filesMan.getNextFilePathName("W0", sExt);
            CMy3WLib.getFile(_sImgSrc, sFilePathName);
            return filesMan.copyFile(sFilePathName, "W0", false);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public Object trsQuery(MethodContext _methContext) throws Exception {
        DatasFromTRSServer currServer = new DatasFromTRSServer();
        String sTitle = _methContext.getValue("docTitle");
        if (sTitle != null && !sTitle.trim().equals("")) {
            currServer.setWhere("IR_URLTITLE = %" + sTitle + "%");
        }
        return currServer.getDatasFromTRSServer(_methContext.getPageIndex(), _methContext.getPageSize());
    }

    public void saveTRSConfig(MethodContext _methContext) throws Exception {
        ConfigServer configServer = ConfigServer.getServer();
        configServer.updateConfigValue("TRSSERVER_HOST", _methContext.getValue("host"));
        configServer.updateConfigValue("TRSSERVER_PORT", _methContext.getValue("port"));
        configServer.updateConfigValue("TRSSERVER_USER", _methContext.getValue("user"));
        configServer.updateConfigValue("TRSSERVER_PWD", _methContext.getValue("pwd"));
        configServer.updateConfigValue("TRSSERVER_DB", _methContext.getValue("db"));
    }

    public Object queryForGroup(MethodContext _methContext) throws Exception {
        User user = this.getLoginUser();
        int nGroupId = _methContext.getValue("GroupId", 0);
        Group currGroup = Group.findById(nGroupId);
        ViewDocuments viewDocuments = new ViewDocuments(user, 1, 1);
        String sChannelIds = _methContext.getValue("ChannelIds");
        String sSiteIds = _methContext.getValue("SiteIds");
        int nSiteType = _methContext.getValue("SiteType", -1);
        CMSBaseObjs objects = null;
        int nRightIndex = 30;
        boolean bInChannelsHost = false;
        if (sChannelIds != null && sChannelIds.length() > 0) {
            objects = Channels.findByIds(user, sChannelIds);
            bInChannelsHost = true;
        } else {
            objects = sSiteIds != null && sSiteIds.length() > 0 ? WebSites.findByIds(user, sSiteIds) : (nSiteType >= 0 ? WebSiteHelper.getWebSitesByType(user, nSiteType, null) : WebSiteHelper.getWebSitesByRightIndex(user, nRightIndex, new WCMFilter(), null, true));
        }
        Channels oQueryChannels = null;
        boolean bAdminstrator = user.isAdministrator();
        if (bInChannelsHost) {
            boolean bContainsChildren = "TRUE".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("STAT_BY_CHANNELECUMULATIVE", "TRUE"));
            oQueryChannels = this.makeChannelsWithRightOfChannels(user, bAdminstrator, objects, nRightIndex, bContainsChildren);
        } else {
            oQueryChannels = this.makeChildChannelsWithRightOfSites(user, bAdminstrator, nRightIndex, objects);
        }
        if (oQueryChannels.isEmpty()) {
            return viewDocuments;
        }
        Users users = new Users(user);
        Groups oGroups = user.getGroups();
        String CrUser = _methContext.getValue("CrUser");
        if (CrUser != null && CrUser != "") {
            User oUser = User.findByName(CrUser);
            users.addElement(oUser);
        } else if (nGroupId == 0) {
            if (!user.isAdministrator()) {
                users.addElement(user);
            }
            for (int i = 0; i < oGroups.size(); ++i) {
                Group group = (Group)oGroups.getAt(i);
                if (!group.isAdministrator(user)) continue;
                users.addElements(SearcherTool.getAllUsers(group, user));
            }
        } else {
            boolean isParentGroupAdmin = false;
            for (Group parentGroup = currGroup.getParent(); parentGroup != null; parentGroup = parentGroup.getParent()) {
                if (!parentGroup.isAdministrator(user)) continue;
                isParentGroupAdmin = true;
                break;
            }
            if (currGroup.isAdministrator(user) || user.isAdministrator() || isParentGroupAdmin) {
                users = SearcherTool.getAllUsers(currGroup, user);
            } else {
                users.addElement(user);
            }
        }
        Users _users = new Users(user);
        for (int i = 0; i < users.size(); ++i) {
            if (users.getAt(i) == null) continue;
            _users.addElement(users.getAt(i));
        }
        users = _users;
        WCMFilter newFilter = new WCMFilter("", "", "");
        String sWhere = "WCMChnlDoc.DocStatus > 0 ";
        boolean bInStat = _methContext.getValue("IsInStat", false);
        if (bInStat) {
            sWhere = sWhere + "and Modal>0 and  WCMChnlDoc.SITEID>0 and  WCMChnlDoc.CHNLID>0 and WCMChnlDoc.DocStatus != 1028 ";
        }
        User currUser = null;
        if (users != null && users.size() > 0) {
            if (users.size() == 1) {
                currUser = (User)users.getAt(0);
                sWhere = sWhere + "and WCMChnlDoc.Cruser = ?";
                newFilter.setWhere(sWhere);
                User oTUser = User.findById(currUser.getId());
                newFilter.addSearchValues(0, oTUser.getName());
            } else {
                int nsize = users.size();
                for (int i = 0; i < nsize; ++i) {
                    currUser = (User)users.getAt(i);
                    sWhere = i == 0 ? sWhere + "and (WCMChnlDoc.CrUser = ? or " : (i != nsize - 1 ? sWhere + "WCMChnlDoc.CrUser = ? or " : sWhere + "WCMChnlDoc.CrUser = ?)");
                    newFilter.setWhere(sWhere);
                    User nTUser = User.findById(currUser.getId());
                    newFilter.addSearchValues(i, nTUser.getName());
                }
            }
        } else {
            newFilter.setWhere(sWhere);
        }
        WCMFilter filter = SearcherTool.getFilterFromList(_methContext, objects);
        WCMFilter extendFilter = SearcherTool.getFilterForCopyOnly(_methContext);
        filter.mergeWith(extendFilter);
        filter.mergeWith(newFilter);
        if (CMyString.isEmpty(filter.getOrder())) {
            filter.setOrder("WCMChnlDoc.CrUser asc");
        }
        viewDocuments.setSelectFields(_methContext.getValue("ChnlDocSelectFields"), _methContext.getValue("DocumentSelectFields"));
        viewDocuments.setPageSize(_methContext.getPageSize());
        viewDocuments.setCurrPage(_methContext.getPageIndex());
        viewDocuments.setRightIndex(64);
        viewDocuments.setNeedWithAuthFilter(user, true);
        viewDocuments.open(oQueryChannels, filter);
        return viewDocuments;
    }

    public void editDocuments(MethodContext _methContext) throws Exception {
        boolean bEditAll = _methContext.getValue("EditAll", false);
        String sChnlDocIds = "";
        if (bEditAll) {
            _methContext.setValue("PageSize", -1);
            sChnlDocIds = ((ViewDocuments)this.query(_methContext)).getIdListAsString();
        } else {
            sChnlDocIds = _methContext.getValue("ChnlDocIds");
        }
        if (CMyString.isEmpty(sChnlDocIds)) {
            return;
        }
        User loginUser = ContextHelper.getLoginUser();
        WCMFilter currFilter = new WCMFilter("", "recid in(?)", "");
        int[] ids = CMyString.splitToInt(sChnlDocIds, ",");
        String sWhere = "recid in(";
        for (int i = 0; i < ids.length; ++i) {
            sWhere = sWhere + "?";
            currFilter.addSearchValues(ids[i]);
            if (i >= ids.length - 1) continue;
            sWhere = sWhere + ",";
        }
        sWhere = sWhere + ")";
        currFilter.setWhere(sWhere);
        ChnlDocs chnlDocs = ChnlDocs.openWCMObjs(loginUser, currFilter);
        this.changeViewDocsProperties(chnlDocs, _methContext);
    }

    private void changeViewDocsProperties(ChnlDocs chnlDocs, MethodContext _methContext) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        if (chnlDocs == null) {
            return;
        }
        for (int i = 0; i < chnlDocs.size(); ++i) {
            ChnlDoc chnlDoc = (ChnlDoc)chnlDocs.getAt(i);
            if (chnlDoc == null || !this.hasRight(loginUser, chnlDoc, 32)) continue;
            String[] excludeFields = new String[]{"CHNLID"};
            Document doc = chnlDoc.getDocument();
            doc = (Document)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methContext, doc, excludeFields);
            doc.save(loginUser);
            chnlDoc = (ChnlDoc)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methContext, chnlDoc, excludeFields);
            chnlDoc.save(loginUser);
        }
    }

    private boolean hasRight(User _currUser, ChnlDoc _currChnlDoc, int rightIndex) throws WCMException {
        return DocumentAuthServer.hasRight(_currUser, (BaseChannel)_currChnlDoc.getChannel(), _currChnlDoc.getDocument(), rightIndex);
    }

    public void changeDocLevel(MethodContext _context) throws Throwable {
        DocLevel docLevel;
        String sDocIds = _context.getValue("DocumentIds");
        if (CMyString.isEmpty(sDocIds)) {
            throw new WCMException("\u6307\u5b9a\u7684DocumentIds\u4e3a\u7a7a");
        }
        int nDocLevel = _context.getValue("DocLevel", 0);
        if (nDocLevel > 0 && (docLevel = DocLevel.findById(nDocLevel)) == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u6587\u6863\u5bc6\u7ea7[id=" + nDocLevel + "]\u4e0d\u5b58\u5728");
        }
        User loginUser = this.getLoginUser();
        String[] pDocIds = sDocIds.split(",");
        for (int i = 0; i < pDocIds.length; ++i) {
            int docId = Integer.parseInt(pDocIds[i]);
            Document currDocument = Document.findById(docId);
            if (currDocument == null || !this.hasRight(loginUser, currDocument.getChannel(), currDocument, 61)) continue;
            currDocument.setDocLevel(nDocLevel);
            currDocument.save(loginUser);
        }
    }
}

