/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.PageOperatorsForServiceHelper;
import com.trs.ajaxservice.WCMDocumentHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.resource.Status;
import com.trs.components.wcm.resource.Statuses;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.wcm.config.PageOperators;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class StatusServiceProvider
implements IGlueServiceProvider {
    @Override
    public void delete(MethodContext _context) throws Throwable {
    }

    @Override
    public Object query(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        WCMFilter extraFilter = new WCMFilter(_methContext.getQueryFilter());
        return Statuses.openWCMObjs(loginUser, extraFilter);
    }

    @Override
    public int save(MethodContext _context) throws Throwable {
        return 0;
    }

    @Override
    public Object findById(MethodContext _context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext _context) throws Throwable {
        return null;
    }

    public PageOperators getOperators(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nObjectId = _methContext.getObjectId();
        if (nObjectId > 0) {
            Status channel = this.findByStatus(nObjectId);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "status", channel);
        }
        String sObjectIds = _methContext.getObjectIds();
        if (sObjectIds != null && sObjectIds.length() > 0) {
            Statuses statuss = Statuses.findByIds(loginUser, sObjectIds);
            if (statuss.isEmpty()) {
                throw new WCMException(I18NMessage.get(StatusServiceProvider.class, "StatusServiceProvider.label1", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u72b6\u6001\u96c6\u5408[ObjectIds=") + sObjectIds + "]\uff01");
            }
            if (statuss.size() == 1) {
                return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "channel", (CMSObj)statuss.getAt(0));
            }
            return PageOperatorsForServiceHelper.makeCMSBaseObjsOpertators(loginUser, "statuss", statuss);
        }
        throw new WCMException(I18NMessage.get(StatusServiceProvider.class, "StatusServiceProvider.label2", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public Statuses queryDocumentStatuses(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nChannelId = _methContext.getValue("ChannelId", 0);
        boolean bCaseSiteEdit = _methContext.getValue("isFromSite", false);
        Channels currChannels = null;
        Channel currChannel = null;
        if (nChannelId > 0) {
            currChannel = this.findChannelById(nChannelId);
        } else {
            currChannels = Channels.findByIds(loginUser, _methContext.getValue("ChannelIds"));
        }
        String sChnlDocIds = _methContext.getValue("ChnlDocIds");
        BaseObjs viewDocuments = null;
        if (sChnlDocIds != null && sChnlDocIds.length() > 0) {
            viewDocuments = WCMDocumentHelper.findViewDocumentsByIds(loginUser, sChnlDocIds);
        }
        if (viewDocuments != null && viewDocuments.isEmpty()) {
            throw new WCMException(I18NMessage.get(StatusServiceProvider.class, "StatusServiceProvider.label3", "\u6307\u5b9a\u7684\u6587\u6863\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u53ef\u64cd\u4f5c\uff01[RecIds=") + sChnlDocIds + "]");
        }
        WCMFilter oFilter = new WCMFilter("", "STYPE IN (?, ?)", "");
        oFilter.addSearchValues(1);
        oFilter.addSearchValues(3);
        String sQuoteStatusPublished = ConfigServer.getServer().getSysConfigValue("Document_QuoteStatus_IsPublished", "false");
        boolean bQuoteStatusPublished = "true".equalsIgnoreCase(sQuoteStatusPublished);
        if (!bQuoteStatusPublished || !bCaseSiteEdit) {
            WCMFilter extraFilter = new WCMFilter(_methContext.getQueryFilter());
            oFilter.mergeWith(extraFilter);
        }
        Statuses statuses = Statuses.openWCMObjs(loginUser, oFilter);
        if (viewDocuments == null) {
            if (loginUser.isAdministrator()) {
                return statuses;
            }
            for (int i = statuses.size() - 1; i >= 0; --i) {
                Status status = (Status)statuses.getAt(i);
                if (status != null && this.hasRight(loginUser, currChannel, currChannels, status.getRightIndex())) continue;
                statuses.removeAt(i, false);
            }
        } else {
            for (int i = statuses.size() - 1; i >= 0; --i) {
                Status status = (Status)statuses.getAt(i);
                if (status != null && this.hasRight(loginUser, (ViewDocuments)viewDocuments, status.getRightIndex())) continue;
                statuses.removeAt(i, false);
            }
        }
        return statuses;
    }

    private boolean hasRight(User _loginUser, Channel _currChannel, Channels _currChannels, int _nRightIndex) throws WCMException {
        if (_currChannel != null) {
            return AuthServer.hasRight(_loginUser, (CMSObj)_currChannel, _nRightIndex);
        }
        int nSize = _currChannels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)_currChannels.getAt(i);
            if (channel == null || AuthServer.hasRight(_loginUser, (CMSObj)channel, _nRightIndex)) continue;
            return false;
        }
        return true;
    }

    private boolean hasRight(User _loginUser, ViewDocuments _vDocuments, int _nRightIndex) throws WCMException {
        int nSize = _vDocuments.size();
        for (int i = 0; i < nSize; ++i) {
            ViewDocument viewDocument = (ViewDocument)_vDocuments.getAt(i);
            if (viewDocument == null || viewDocument.hasRight(_loginUser, _nRightIndex)) continue;
            return false;
        }
        return true;
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    private Status findByStatus(int _nObjectId) throws WCMException {
        Status status = Status.findById(_nObjectId);
        if (status == null) {
            throw new WCMException(I18NMessage.get(StatusServiceProvider.class, "StatusServiceProvider.label4", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u72b6\u6001[ID=") + _nObjectId + "]\uff01");
        }
        return status;
    }

    private Channel findChannelById(int _nChannelId) throws WCMException {
        if (_nChannelId <= 0) {
            throw new WCMException(I18NMessage.get(StatusServiceProvider.class, "StatusServiceProvider.label5", "\u6307\u5b9a\u7684\u53c2\u6570\u6709\u8bef\uff01\u65e0\u6548\u680f\u76eeID[") + _nChannelId + "]!");
        }
        Channel channelOrSite = Channel.findById(_nChannelId);
        if (channelOrSite == null) {
            throw new WCMException(I18NMessage.get(StatusServiceProvider.class, "StatusServiceProvider.label6", "\u6307\u5b9a\u7684\u53c2\u6570\u6709\u8bef\uff01\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ID=") + _nChannelId + "]!");
        }
        return channelOrSite;
    }
}

