/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.PageOperatorsForServiceHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.resource.Source;
import com.trs.components.wcm.resource.Sources;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.wcm.config.PageOperators;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class SourceServiceProvider
implements IGlueServiceProvider {
    @Override
    public void delete(MethodContext _methContext) throws Throwable {
    }

    @Override
    public Object query(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        WCMFilter extraFilter = new WCMFilter(_methContext.getQueryFilter());
        return Sources.openWCMObjs(loginUser, extraFilter);
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Source source = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId == 0) {
            source = new Source();
        } else if (nObjectId == -1) {
            String sSrcName = _methodContext.getValue("SrcName");
            WCMFilter filter = new WCMFilter("WCMSource", "SrcName=?", "", "SourceId");
            filter.addSearchValues(sSrcName);
            int nSourceId = DBManager.getDBManager().sqlExecuteIntQuery(filter);
            if (nSourceId > 0) {
                return nSourceId;
            }
            source = new Source();
            source.setName(sSrcName);
            source.setDesc(sSrcName);
        } else {
            source = Source.findById(nObjectId);
            if (source == null) {
                throw new WCMException(I18NMessage.get(SourceServiceProvider.class, "SourceServiceProvider.label1", "\u6307\u5b9a\u7684\u6587\u6863\u4e0d\u5b58\u5728![ObjectId=") + _methodContext.getObjectId() + "]");
            }
        }
        if (nObjectId != -1) {
            String[] pLogicFields = new String[]{"ObjectId"};
            source = (Source)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, source, pLogicFields);
        }
        source.save(loginUser);
        return source.getId();
    }

    @Override
    public Object findById(MethodContext _methContext) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext _methContext) throws Throwable {
        return null;
    }

    public PageOperators getOperators(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nObjectId = _methContext.getObjectId();
        if (nObjectId > 0) {
            Source channel = this.findBySource(nObjectId);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "source", channel);
        }
        String sObjectIds = _methContext.getObjectIds();
        if (sObjectIds != null && sObjectIds.length() > 0) {
            Sources sources = Sources.findByIds(loginUser, sObjectIds);
            if (sources.isEmpty()) {
                throw new WCMException(I18NMessage.get(SourceServiceProvider.class, "SourceServiceProvider.label2", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ObjectIds=") + sObjectIds + "]\uff01");
            }
            if (sources.size() == 1) {
                return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "channel", (CMSObj)sources.getAt(0));
            }
            return PageOperatorsForServiceHelper.makeCMSBaseObjsOpertators(loginUser, "sources", sources);
        }
        throw new WCMException(I18NMessage.get(SourceServiceProvider.class, "SourceServiceProvider.label3", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    private Source findBySource(int _nObjectId) throws WCMException {
        Source source = Source.findById(_nObjectId);
        if (source == null) {
            throw new WCMException(I18NMessage.get(SourceServiceProvider.class, "SourceServiceProvider.label4", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u6765\u6e90[ID=") + _nObjectId + "]\uff01");
        }
        return source;
    }
}

