/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.scene.parser.SceneConnector;
import com.trs.scene.parser.SceneNode;
import com.trs.scene.parser.ScenePathsParser;
import com.trs.scene.parser.SceneXMLParser;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;

public class SceneServiceProvider
implements ISelfDefinedServiceProvider {
    public Documents cloneFromOtherFlow(MethodContext _methodContext) throws Exception {
        DocumentMgr documentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        Channel channel = Channel.findById(nChannelId);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(SceneServiceProvider.class, "SceneServiceProvider.label1", "\u6307\u5b9a\u7684\u680f\u76ee\u4e0d\u5b58\u5728\uff01"));
        }
        int nSrcNodeId = _methodContext.getValue("SrcNodeId", 0);
        int nTempDstNodeId = _methodContext.getValue("DstNodeId", 0);
        int[] pDstNodeId = null;
        if (nTempDstNodeId <= 0) {
            pDstNodeId = this.makeDstNodeId(channel, nSrcNodeId);
            if (pDstNodeId.length == 0) {
                throw new WCMException(I18NMessage.get(SceneServiceProvider.class, "SceneServiceProvider.label2", "\u6307\u5b9a\u7684\u540c\u540d\u8282\u70b9\u4e0d\u5b58\u5728\uff01"));
            }
        } else {
            pDstNodeId = new int[]{nTempDstNodeId};
        }
        WCMFilter filter = new WCMFilter("", "WCMChnlDoc.NodeId=?", "");
        filter.addSearchValues(nSrcNodeId);
        Documents documents = documentMgr.getDocuments(channel, filter);
        Documents newDocuments = new Documents(null);
        for (int nNodeIndex = 0; nNodeIndex < pDstNodeId.length; ++nNodeIndex) {
            int nDstNodeId = pDstNodeId[nNodeIndex];
            for (int i = documents.size() - 1; i >= 0; --i) {
                Document document = (Document)documents.getAt(i);
                if (document == null) continue;
                Document newDocument = (Document)document.cloneToNewWCMObj();
                newDocument.setProperty("NodeId", nDstNodeId);
                documentMgr.save(newDocument);
                newDocuments.addElement(newDocument);
            }
        }
        return newDocuments;
    }

    private int[] makeDstNodeId(Channel _channel, int _nSrcNodeId) throws WCMException {
        SceneXMLParser parser = new SceneXMLParser(_channel.getPropertyAsString("fluencexml"));
        SceneNode firstNode = parser.parse();
        ScenePathsParser pathsParser = new ScenePathsParser(firstNode);
        SceneConnector[][] pResult = pathsParser.parse();
        String sNodeName = "";
        for (int i = 0; i < pResult.length; ++i) {
            SceneConnector[] path = pResult[i];
            if (path[path.length - 1].getNextNode().getId() != _nSrcNodeId) continue;
            sNodeName = path[path.length - 1].getNextNode().getName().trim();
            break;
        }
        int[] pNodeId = new int[]{};
        for (int i = 0; i < pResult.length; ++i) {
            SceneConnector[] path = pResult[i];
            String sCurrNodeName = path[path.length - 1].getNextNode().getName().trim();
            if (path[path.length - 1].getNextNode().getId() == _nSrcNodeId || !sCurrNodeName.equalsIgnoreCase(sNodeName)) continue;
            int[] pNodeIdTemp = new int[pNodeId.length + 1];
            pNodeIdTemp[pNodeId.length] = path[path.length - 1].getNextNode().getId();
            if (pNodeId.length > 0) {
                System.arraycopy(pNodeId, 0, pNodeIdTemp, 0, pNodeId.length);
            }
            pNodeId = pNodeIdTemp;
        }
        return pNodeId;
    }
}

