/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.ajaxservice.ServiceConstants;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.individuation.CustomSiteCheckedInfo;
import com.trs.components.wcm.individuation.CustomSiteCheckedInfos;
import com.trs.components.wcm.individuation.Individuation;
import com.trs.components.wcm.individuation.IndividuationMgr;
import com.trs.components.wcm.individuation.Individuations;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;

public class IndividuationServiceProvider
implements ISelfDefinedServiceProvider,
IGlueServiceProvider {
    @Override
    public Object query(MethodContext _methContext) throws WCMException {
        User loginUser = this.getLoginUser();
        WCMFilter queryFilter = new WCMFilter();
        queryFilter = _methContext.getExtraWCMFilter();
        return Individuations.openWCMObjs(loginUser, queryFilter);
    }

    public Object queryCustomSite(MethodContext _methContext) throws WCMException {
        User loginUser = this.getLoginUser();
        WCMFilter queryFilter = new WCMFilter();
        queryFilter = "customSite".equals(_methContext.getValue("ParamName")) ? this.makeQueryCustomeSiteFillter(Integer.parseInt(_methContext.getValue("userId")), loginUser) : _methContext.getExtraWCMFilter();
        return Individuations.openWCMObjs(loginUser, queryFilter);
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    @Override
    public Object findByIds(MethodContext _methodContext) throws Throwable {
        return null;
    }

    @Override
    public Object findById(MethodContext _methodContext) throws Throwable {
        return null;
    }

    @Override
    public void delete(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Individuations individuations = Individuations.findByIds(loginUser, _methodContext.getObjectIds());
        int nSize = individuations.size();
        for (int i = 0; i < nSize; ++i) {
            Individuation individuation = (Individuation)individuations.getAt(i);
            if (individuation == null || individuation.getUserId() != loginUser.getId()) continue;
            individuation.delete();
        }
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int objectId = _methodContext.getObjectId();
        int nUserId = loginUser.getId();
        Individuation individuation = null;
        if (_methodContext.getValue("isShared") != null && "1".equals(_methodContext.getValue("isShared")) && !loginUser.isAdministrator()) {
            throw new WCMException(I18NMessage.get(IndividuationServiceProvider.class, "IndividuationServiceProvider.label4", "\u60a8\u6ca1\u6709\u6743\u9650\u5171\u4eab\u4e2a\u6027\u5316\u7ad9\u70b9"));
        }
        boolean bForSystem = false;
        if (_methodContext.getValue("isSystem") != null && "1".equals(_methodContext.getValue("isSystem"))) {
            bForSystem = true;
            nUserId = -1;
            if (!loginUser.isAdministrator()) {
                throw new WCMException(I18NMessage.get(IndividuationServiceProvider.class, "IndividuationServiceProvider.label4", "\u60a8\u6ca1\u6709\u6743\u9650\u8bbe\u7f6e\u7cfb\u7edf\u7ea7\u7684\u4e2a\u6027\u5316\u914d\u7f6e"));
            }
        }
        if (objectId == 0) {
            individuation = new Individuation();
        } else {
            individuation = Individuation.findById(objectId);
            if (individuation == null) {
                throw new WCMException(I18NMessage.get(IndividuationServiceProvider.class, "IndividuationServiceProvider.label1", "\u6307\u5b9a\u7684\u4e2a\u6027\u5316\u8bbe\u7f6e\u5b57\u6bb5\u4e0d\u5b58\u5728![ObjectId=") + _methodContext.getObjectId() + "]");
            }
            if (!bForSystem && individuation.getUserId() != loginUser.getId()) {
                throw new WCMException(I18NMessage.get(IndividuationServiceProvider.class, "IndividuationServiceProvider.label2", "\u60a8\u6ca1\u6709\u6743\u9650\u4fee\u6539\u8fd9\u4e2a\u81ea\u5b9a\u4e49\u8bbe\u7f6e[ParamName=") + individuation.getParamName() + ",Id=" + individuation.getId() + "]\uff01");
            }
        }
        individuation.setUserId(nUserId);
        String[] pLogicFields = new String[]{"ObjectId"};
        if (bForSystem) {
            String[] pLogicFields1 = new String[]{"ObjectId", "isSystem"};
            individuation = (Individuation)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, individuation, pLogicFields1);
        } else {
            individuation = (Individuation)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, individuation, pLogicFields);
        }
        individuation.save(loginUser);
        if (individuation.getParamName().equals("customSite")) {
            this.synchronizeCustomSiteCheckInfo(individuation, loginUser);
        }
        return individuation.getId();
    }

    public String getPageInfo(MethodContext _methodContext) throws Throwable {
        int objType = _methodContext.getValue("objType", 605);
        switch (objType) {
            case 605: {
                String[][] PageFilters = ServiceConstants.FILTERS_DOCUMENTS_DEFAULT;
                StringBuffer returnJson = new StringBuffer("{PageFilters : [");
                for (int i = 0; i < PageFilters.length; ++i) {
                    returnJson.append("{desc : '" + PageFilters[i][0] + "', value : " + PageFilters[i][1] + "}");
                    if (i + 1 >= PageFilters.length) continue;
                    returnJson.append(",");
                }
                _methodContext.setReturnJSON(true);
                return returnJson.append("]}").toString();
            }
        }
        throw new Exception(I18NMessage.get(IndividuationServiceProvider.class, "IndividuationServiceProvider.label3", "\u5c1a\u672a\u5b9e\u73b0\u6b64\u8fc7\u6ee4\u5668"));
    }

    public boolean setIsChecked(MethodContext _methodContext) throws Throwable {
        Individuation oIndividuation;
        User loginUser = this.getLoginUser();
        String excludeIds = _methodContext.getValue("excludeIds");
        String includeIds = _methodContext.getValue("includeIds");
        if (excludeIds != null) {
            Individuations excludeIndividuations = Individuations.findByIds(loginUser, excludeIds);
            for (int i = 0; i < excludeIndividuations.size(); ++i) {
                CustomSiteCheckedInfo currCustomSiteCheckedInfo;
                oIndividuation = (Individuation)excludeIndividuations.getAt(i);
                if (oIndividuation == null || (currCustomSiteCheckedInfo = CustomSiteCheckedInfo.getCustomSiteCheckInfo(oIndividuation.getId(), loginUser)) == null) continue;
                currCustomSiteCheckedInfo.delete(loginUser);
            }
        }
        if (includeIds != null) {
            Individuations includeIndividuations = Individuations.findByIds(loginUser, includeIds);
            for (int k = 0; k < includeIndividuations.size(); ++k) {
                oIndividuation = (Individuation)includeIndividuations.getAt(k);
                if (oIndividuation == null) continue;
                this.addCustomSiteCheckedData(oIndividuation.getId(), loginUser);
            }
        }
        if (_methodContext.getValue("refreshCustomSiteSession", false)) {
            _methodContext.getServiceContext().getRequest().getSession().setAttribute("customSite", (Object)new IndividuationMgr().getObjectIdsHashtable(103));
        }
        return true;
    }

    private void setIsChecked(Individuations individuations, boolean isChecked, User loginUser) throws Throwable {
        int nSize = individuations.size();
        for (int i = 0; i < nSize; ++i) {
            Individuation element = (Individuation)individuations.getAt(i);
            if (element == null) continue;
            if (element.getUserId() == loginUser.getId()) {
                element.setIsChecked(isChecked);
            }
            element.save();
        }
    }

    private void synchronizeCustomSiteCheckInfo(Individuation individuation, User loginUser) throws WCMException {
        if (individuation == null || !individuation.getParamName().equals("customSite")) {
            return;
        }
        int individuationId = individuation.getId();
        CustomSiteCheckedInfo currCustomSiteCheckedInfo = CustomSiteCheckedInfo.getCustomSiteCheckInfo(individuationId, loginUser);
        if (!individuation.isIsShared()) {
            this.removeCustomSiteCheckedDataOfOtherUsers(individuationId, loginUser);
        }
        if (individuation.isIsChecked()) {
            if (currCustomSiteCheckedInfo != null) {
                return;
            }
            this.addCustomSiteCheckedData(individuationId, loginUser);
        } else {
            if (currCustomSiteCheckedInfo == null) {
                return;
            }
            currCustomSiteCheckedInfo.delete(loginUser);
        }
    }

    private void addCustomSiteCheckedData(int individuationId, User loginUser) throws WCMException {
        CustomSiteCheckedInfo currCustomSiteCheckedInfo = new CustomSiteCheckedInfo();
        currCustomSiteCheckedInfo.setIndividuationId(individuationId);
        currCustomSiteCheckedInfo.setCheckedUser(loginUser.getId());
        currCustomSiteCheckedInfo.save();
    }

    private void removeCustomSiteCheckedDataOfOtherUsers(int individuationId, User loginUser) throws WCMException {
        CustomSiteCheckedInfos needDeleteObjs = CustomSiteCheckedInfo.getCustomSiteCheckInfoByIndividuationId(individuationId, loginUser);
        for (int i = 0; i < needDeleteObjs.size(); ++i) {
            CustomSiteCheckedInfo element = (CustomSiteCheckedInfo)needDeleteObjs.getAt(i);
            element.delete(loginUser);
        }
    }

    private WCMFilter makeQueryCustomeSiteFillter(int _nUserId, User _oLoginUser) {
        WCMFilter oCustomeFilter = new WCMFilter();
        StringBuffer str = new StringBuffer();
        str.append("ParamName ='customSite' and");
        if (_nUserId > 0) {
            str.append(" (UserId =" + _nUserId);
        } else {
            str.append(" (UserId =" + _oLoginUser.getId());
        }
        str.append(" or isShared = 1)");
        oCustomeFilter.setWhere(str.toString());
        return oCustomeFilter;
    }
}

