/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.interact.agent.ClientTransferManager;
import java.util.ArrayList;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class MBeanRegisiter {
    private static final Logger LOG = Logger.getLogger(MBeanRegisiter.class);

    static ObjectInstance registerSocketHostManagerMBean(ClientTransferManager clientTransferManager) {
        MBeanServer server;
        try {
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
            server = servers.size() > 0 ? (MBeanServer)servers.get(0) : MBeanServerFactory.createMBeanServer();
        }
        catch (SecurityException e) {
            LOG.error((Object)"fail to get MBeanServer", (Throwable)e);
            return null;
        }
        ObjectName objName = null;
        ObjectInstance objInstance = null;
        try {
            objName = new ObjectName("com.trs.idm.mbeans:type=ClientTransferManager");
            objInstance = server.registerMBean(clientTransferManager, objName);
            LOG.info((Object)("Registered mbean " + objName.getCanonicalName() + " successfully; objInstance=" + objInstance));
        }
        catch (MalformedObjectNameException e) {
            LOG.error((Object)("fail to registerMBean:" + e.getMessage()), (Throwable)e);
        }
        catch (NullPointerException e) {
            LOG.error((Object)("fail to registerMBean " + objName.getCanonicalName()), (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            LOG.error((Object)("fail to registerMBean " + objName.getCanonicalName()), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            LOG.error((Object)("fail to registerMBean " + objName.getCanonicalName()), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            LOG.error((Object)("fail to registerMBean " + objName.getCanonicalName()), (Throwable)e);
        }
        return objInstance;
    }
}

