/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.saml.interact.impl.simple.request;

import com.trs.idm.exception.ServiceProviderException;
import com.trs.idm.saml.interact.IResponse;
import com.trs.idm.saml.interact.RequestBase;
import com.trs.idm.saml.sp.core.IServiceProvider;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.RequestUtil;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SimpleAuthnRequest
extends RequestBase {
    private static final Logger LOG = Logger.getLogger(SimpleAuthnRequest.class);
    private String relayState;
    private String base64relayState;
    private String queryString;
    private String base64QueryString;
    private String originalPostParameters;

    public SimpleAuthnRequest(IServiceProvider sp, HttpServletRequest request) {
        this.requestType = "SimpleAuthnRequest";
        this.originalPostParameters = RequestUtil.getPostParametersAsString(request);
        this.relayState = request.getRequestURL().toString();
        this.base64relayState = Base64Util.encode(this.relayState);
        this.addNameValue("RelayState", this.base64relayState);
        this.serviceProvider = sp;
        this.queryString = request.getQueryString();
        if (!StringHelper.isEmpty(this.queryString)) {
            this.base64QueryString = Base64Util.encode(this.queryString);
            this.addNameValue("queryString", this.base64QueryString);
        }
        this.isDebug = RequestUtil.getParameterAsBool(request, "isDebug", false);
        LOG.debug((Object)("original queryString is: " + this.queryString));
        LOG.debug((Object)("original postParameters: " + this.originalPostParameters));
        LOG.debug((Object)("base64 queryString is: " + this.base64QueryString));
    }

    public boolean validate() {
        return true;
    }

    public IResponse doRequest(HttpServletRequest request, HttpServletResponse response) throws ServiceProviderException {
        LOG.debug((Object)("is about to forward to: " + this.serviceProvider.getAutoSubmitPage()));
        request.setAttribute("request_type", (Object)this.requestType);
        request.setAttribute("postParameters", (Object)Base64Util.encode(this.originalPostParameters));
        request.setAttribute("targetURL", (Object)Base64Util.encode(this.serviceProvider.getIDPUrl()));
        request.setAttribute("coAppName", (Object)this.serviceProvider.getCoAppName());
        request.setAttribute("coSessionId", (Object)request.getSession().getId());
        request.setAttribute("RelayState", (Object)this.base64relayState);
        if (!StringHelper.isEmpty(this.base64QueryString)) {
            request.setAttribute("queryString", (Object)this.base64QueryString);
        }
        if (this.isDebug) {
            request.setAttribute("isDebug", (Object)new Boolean(this.isDebug).toString());
        }
        try {
            request.getRequestDispatcher(this.serviceProvider.getAutoSubmitPage()).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (ServletException e) {
            LOG.error((Object)"error while redicect to autoSubmit page", (Throwable)e);
            throw new ServiceProviderException("\u91cd\u5b9a\u5411\u5230" + this.serviceProvider.getAutoSubmitPage() + "\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u8def\u5f84\u662f\u5426\u6b63\u786e!", e);
        }
        catch (IOException e) {
            LOG.error((Object)"error while redicect to autoSubmit page", (Throwable)e);
            throw new ServiceProviderException("\u91cd\u5b9a\u5411\u5230" + this.serviceProvider.getAutoSubmitPage() + "\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u786e\u8ba4\u8def\u5f84\u662f\u5426\u6b63\u786e!", e);
        }
        return null;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public IServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }
}

