/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.interact.agent;

import com.trs.idm.interact.agent.ClientTransferManager;
import com.trs.idm.interact.agent.IClientTransfer;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ClientTransferProxy {
    public static final String PROXY_TYPE_TEMP = "temp";
    public static final String PROXY_TYPE_PERM = "perm";
    private static final Logger LOG = Logger.getLogger(ClientTransferProxy.class);
    private IClientTransfer client = null;
    private ClientTransferManager manager = null;
    private long lastAccessTime = 0L;
    private long lastInitedTime = 0L;
    private long creationTime = 0L;
    private long processTime = 0L;
    private long initedTimes = 0L;
    private Throwable lastError = null;
    private boolean isValid;
    private volatile boolean isInitializing;
    private volatile boolean isClosing;
    private long lastActivedTime = 0L;
    private String type = "perm";
    private int idleCount = 0;
    private int triedCount = 0;
    private int activeCount = 0;

    public ClientTransferProxy(ClientTransferManager manager, IClientTransfer client) {
        this(manager, client, PROXY_TYPE_PERM);
    }

    public ClientTransferProxy(ClientTransferManager manager, IClientTransfer client, String type) {
        if (client == null) {
            throw new NullPointerException("ClientTransfer is null!");
        }
        this.client = client;
        this.manager = manager;
        this.creationTime = System.currentTimeMillis();
        this.type = type;
    }

    public boolean isSocketAlive() {
        return this.client.isSocketAlive();
    }

    public boolean init() {
        if (this.isInitializing) {
            return false;
        }
        this.isInitializing = true;
        try {
            try {
                this.client.init();
                this.manager.successOnInitialized(this);
            }
            catch (IOException e) {
                LOG.error((Object)"Error inited:", (Throwable)e);
                this.manager.failOnInitialized(this);
                this.lastError = e;
                this.isClosing = false;
                this.lastInitedTime = System.currentTimeMillis();
                ++this.initedTimes;
                this.isInitializing = false;
                return false;
            }
        }
        finally {
            this.isClosing = false;
            this.lastInitedTime = System.currentTimeMillis();
            ++this.initedTimes;
            this.isInitializing = false;
        }
        return true;
    }

    public boolean close() {
        if (this.isClosing) {
            return false;
        }
        this.isClosing = true;
        this.client.close();
        this.lastError = null;
        this.isClosing = false;
        return true;
    }

    public byte[] getResponse(byte[] request) throws IOException {
        if (request == null) {
            throw new IllegalArgumentException("request bytes is null!");
        }
        this.lastAccessTime = System.currentTimeMillis();
        byte[] response = null;
        try {
            try {
                response = this.client.getResponse(request);
                this.manager.successOnResponse(this);
            }
            catch (IOException e) {
                LOG.error((Object)("Error getResponse:" + StringHelper.toString(request)), (Throwable)e);
                this.manager.failOnResponse(this);
                throw e;
            }
        }
        finally {
            this.lastActivedTime = System.currentTimeMillis() - this.lastAccessTime;
            this.processTime += this.lastActivedTime;
        }
        return response;
    }

    public ClientTransferManager getManager() {
        return this.manager;
    }

    public void setManager(ClientTransferManager manager) {
        this.manager = manager;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long getLastInitedTime() {
        return this.lastInitedTime;
    }

    public void setLastInitedTime(long lastInitedTime) {
        this.lastInitedTime = lastInitedTime;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public long getProcessTime() {
        return this.processTime;
    }

    public void setProcessTime(long processTime) {
        this.processTime = processTime;
    }

    public long getInitedTimes() {
        return this.initedTimes;
    }

    public void setInitedTimes(long initedTimes) {
        this.initedTimes = initedTimes;
    }

    public Throwable getLastError() {
        return this.lastError;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        sb.append(super.toString());
        sb.append(";client=").append(this.client);
        sb.append(";activeCount=").append(this.activeCount);
        return sb.toString();
    }

    public IClientTransfer getClient() {
        return this.client;
    }

    public synchronized void onTry() {
        ++this.triedCount;
    }

    public synchronized void onRefresh() {
        ++this.idleCount;
    }

    public synchronized void onActive() {
        ++this.activeCount;
    }

    public String getType() {
        return this.type;
    }

    public synchronized void onIdle() {
        this.idleCount = 0;
    }

    public void onError() {
        this.triedCount = 0;
    }

    public int getIdleCount() {
        return this.idleCount;
    }

    public int getTriedCount() {
        return this.triedCount;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public void endIdle() {
        this.idleCount = 0;
    }

    public void reinit() {
        boolean initResult = this.init();
        if (!initResult) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"run error while init, so need not to init coApp config");
            }
            return;
        }
        this.initCoAppConfig();
    }

    public void endError() {
        this.triedCount = 0;
    }

    public void initCoAppConfig() {
        this.lastAccessTime = System.currentTimeMillis();
        try {
            try {
                this.client.initCoAppConfig();
                LOG.debug((Object)("successOnResponse while init coAppConfig by client[" + this.client + "], currentIdleSize[" + this.manager.currentIdleSize() + "], currentErrorSize[" + this.manager.currentErrorSize() + "]"));
            }
            catch (IOException e) {
                this.manager.failOnInitialized(this);
                this.lastError = e;
                LOG.error((Object)("failOnResponse while init coAppConfig by client[" + this.client + "], currentIdleSize[" + this.manager.currentIdleSize() + "], currentErrorSize[" + this.manager.currentErrorSize() + "]"), (Throwable)e);
                this.lastActivedTime = System.currentTimeMillis() - this.lastAccessTime;
                this.processTime += this.lastActivedTime;
                LOG.info((Object)("init coApp config, update lastAccessTime[" + this.lastAccessTime + "], lastActivedTime[" + this.lastActivedTime + "], processTime[" + this.processTime + "]"));
            }
        }
        finally {
            this.lastActivedTime = System.currentTimeMillis() - this.lastAccessTime;
            this.processTime += this.lastActivedTime;
            LOG.info((Object)("init coApp config, update lastAccessTime[" + this.lastAccessTime + "], lastActivedTime[" + this.lastActivedTime + "], processTime[" + this.processTime + "]"));
        }
    }
}

