/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.http;

import com.trs.idm.http.Response;
import com.trs.idm.util.ArrayUtil;
import com.trs.idm.util.Base64Util;
import com.trs.idm.util.PropertyUtil;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.log4j.Logger;

public class PureClient {
    private static final Logger LOG = Logger.getLogger(PureClient.class);
    private static final int CONN_TIMEOUT = 20000;
    private static final int LINGER_TIME = 10000;
    private static HttpClient client;
    private static HttpConnectionManager httpConnMgr;

    static {
        PureClient.init();
    }

    public static Response getHttpResponse(String url, Map headers, HttpState state) {
        return PureClient.getHttpResponse(url, headers, state, true);
    }

    public static Response getHttpResponse(String url, Map headers, HttpState state, boolean followRedirect) {
        GetMethod method = new GetMethod(url);
        method.setFollowRedirects(followRedirect);
        return PureClient.getResponseInternal(url, (HttpMethod)method, headers, state);
    }

    public static Response headHttpResponse(String url, Map headers, HttpState state, NameValuePair[] parametersBody) {
        return PureClient.headHttpResponse(url, headers, state, parametersBody, true);
    }

    public static Response headHttpResponse(String url, Map headers, HttpState state, NameValuePair[] parametersBody, boolean followRedirect) {
        HeadMethod method = new HeadMethod(url);
        method.setFollowRedirects(followRedirect);
        return PureClient.getResponseInternal(url, (HttpMethod)method, headers, state);
    }

    public static Response postHttpRequest(String url, Map headers, HttpState state, String requestBody, String contentType, String encoding) {
        PostMethod method = new PostMethod(url);
        if (!StringHelper.isEmpty(requestBody)) {
            try {
                method.setRequestEntity((RequestEntity)new StringRequestEntity(requestBody, contentType, encoding));
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)("failed to set request entity for method [" + method + "] with requestBody [" + requestBody + "] by charSet [UTF-8] ."), (Throwable)e);
            }
        }
        return PureClient.getResponseInternal(url, (HttpMethod)method, headers, state);
    }

    public static Response postHttpRequest(String url, Map headers, HttpState state, NameValuePair[] parametersBody, String encoding) {
        PostMethod method = new PostMethod(url);
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + encoding);
        if (parametersBody != null) {
            method.setRequestBody(parametersBody);
        }
        return PureClient.getResponseInternal(url, (HttpMethod)method, headers, state);
    }

    public static Response postHttpRequest(String url, Map headers, HttpState state, NameValuePair[] parametersBody) {
        return PureClient.postHttpRequest(url, headers, state, parametersBody, "GBK");
    }

    static Response getResponseInternal(String url, HttpMethod method, Map headers, HttpState state) {
        HttpClient httpClient = PureClient.buildHttpClient();
        return PureClient.getResponseInternal(httpClient, url, method, headers, state);
    }

    static Response getResponseInternal(HttpClient httpClient, String url, HttpMethod method, Map headers, HttpState state) {
        Response res;
        block13: {
            HttpMethodParams params = method.getParams();
            if (params != null) {
                params.setCookiePolicy("compatibility");
            }
            method.setRequestHeader("Connection", "Close");
            res = new Response(url);
            if (headers != null) {
                for (Map.Entry e : headers.entrySet()) {
                    method.setRequestHeader((String)e.getKey(), (String)e.getValue());
                }
            }
            if (state != null) {
                httpClient.setState(state);
            }
            HostConfiguration hostCfg = httpClient.getHostConfiguration();
            String proxyHost = PureClient.getHttpClientProxyHost();
            int proxyPort = PureClient.getHttpClientProxyPort();
            if (StringHelper.isNotEmpty(proxyHost) && proxyPort > 0 && proxyPort < 65536) {
                hostCfg = (HostConfiguration)hostCfg.clone();
                hostCfg.setProxy(proxyHost, proxyPort);
            }
            try {
                try {
                    int respCode = httpClient.executeMethod(method);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[Request]" + method.getName() + " " + method.getPath() + " [Response]" + method.getStatusLine() + "\n" + hostCfg));
                    }
                    res.setStatusCode(respCode);
                    res.setStatusText(method.getStatusText());
                    res.setActualPath(method.getPath());
                    Header[] respHeaders = method.getResponseHeaders();
                    int i = 0;
                    while (i < respHeaders.length) {
                        res.addResponseHeader(respHeaders[i].getName(), respHeaders[i].getValue());
                        ++i;
                    }
                    if (res.statusCodeIsFine()) {
                        res.setResponseBody(method.getResponseBody());
                        break block13;
                    }
                    LOG.warn((Object)("respCode=" + respCode + "! url=" + url));
                }
                catch (Throwable e) {
                    LOG.error((Object)("httpClient.executeMethod failed! url=" + url), e);
                    res.setFail(true);
                    res.setError(e);
                    method.releaseConnection();
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        return res;
    }

    static Response getResponse(String url, HttpMethod method, Map headers, HttpState state) {
        Response res;
        block11: {
            HttpMethodParams params;
            res = new Response(url);
            if (headers != null) {
                for (Map.Entry e : headers.entrySet()) {
                    method.setRequestHeader((String)e.getKey(), (String)e.getValue());
                }
            }
            if ((params = method.getParams()) != null) {
                params.setCookiePolicy("compatibility");
            }
            client.setState(state == null ? new HttpState() : state);
            try {
                try {
                    int respCode = client.executeMethod(method);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[Request]" + method.getName() + " " + method.getPath() + " [Response]" + method.getStatusLine()));
                    }
                    res.setStatusCode(respCode);
                    res.setStatusText(method.getStatusText());
                    res.setActualPath(method.getPath());
                    Header[] respHeaders = method.getResponseHeaders();
                    int i = 0;
                    while (i < respHeaders.length) {
                        res.addResponseHeader(respHeaders[i].getName(), respHeaders[i].getValue());
                        ++i;
                    }
                    if (res.statusCodeIsFine()) {
                        res.setResponseBody(method.getResponseBody());
                        break block11;
                    }
                    LOG.warn((Object)("respCode=" + respCode + "! url=" + url));
                }
                catch (Throwable e) {
                    LOG.error((Object)("httpClient.executeMethod failed! url=" + url), e);
                    res.setFail(true);
                    res.setError(e);
                    method.releaseConnection();
                }
            }
            finally {
                method.releaseConnection();
            }
        }
        return res;
    }

    private static void init() {
        httpConnMgr = new MultiThreadedHttpConnectionManager();
        HttpConnectionManagerParams mgrParams = PureClient.buildManagerParams();
        httpConnMgr.setParams(mgrParams);
        client = new HttpClient(httpConnMgr);
    }

    static HttpConnectionManagerParams buildManagerParams() {
        HttpConnectionManagerParams mgrParams = new HttpConnectionManagerParams();
        mgrParams.setSoTimeout(20000);
        mgrParams.setTcpNoDelay(true);
        mgrParams.setConnectionTimeout(20000);
        mgrParams.setLinger(10000);
        return mgrParams;
    }

    public static String[] postHttpRequest(String url, Map parameters) {
        String[] info = new String[2];
        PostMethod methodPost = new PostMethod(url);
        String[] PARAMS_RESERVED = new String[]{"method", "type", "appName", "secretKey", "idsServiceType", "manageServiceTag", "charset"};
        for (String key : parameters.keySet()) {
            if (StringHelper.isEmpty(key) || "_".equals(key)) continue;
            String value = (String)parameters.get(key);
            if (ArrayUtil.contain(PARAMS_RESERVED, key)) {
                methodPost.addParameter(key, value);
                continue;
            }
            methodPost.addParameter(key, Base64Util.encode(value));
        }
        HttpClient httpClient = PureClient.buildHttpClient();
        try {
            try {
                httpClient.executeMethod((HttpMethod)methodPost);
                info[1] = new String(methodPost.getResponseBody(), "utf-8");
            }
            catch (HttpException e) {
                LOG.error((Object)"error while doPostRequest ", (Throwable)e);
                info[1] = e.getMessage();
                methodPost.releaseConnection();
            }
            catch (IOException e) {
                LOG.error((Object)"error while doPostRequest ", (Throwable)e);
                info[1] = e.getMessage();
                methodPost.releaseConnection();
            }
        }
        finally {
            methodPost.releaseConnection();
        }
        return info;
    }

    private static HttpClient buildHttpClient() {
        HttpClient httpClient = new HttpClient();
        HttpConnectionManager httpConnManager = httpClient.getHttpConnectionManager();
        if (httpConnManager != null) {
            HttpConnectionManagerParams mgrParams = new HttpConnectionManagerParams();
            mgrParams.setSoTimeout(20000);
            mgrParams.setTcpNoDelay(true);
            mgrParams.setConnectionTimeout(20000);
            mgrParams.setLinger(0);
            mgrParams.setStaleCheckingEnabled(false);
            httpConnManager.setParams(mgrParams);
        }
        return httpClient;
    }

    public static Response postHttpRequest(HttpClient httpClient, String url, Map headers, HttpState state, NameValuePair[] parametersBody, String encoding) {
        PostMethod method = new PostMethod(url);
        if (StringHelper.isEmpty(encoding)) {
            encoding = "GBK";
        }
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + encoding);
        if (parametersBody != null) {
            method.setRequestBody(parametersBody);
        }
        return PureClient.getResponseInternal(httpClient, url, (HttpMethod)method, headers, state);
    }

    public static Response postHttpRequest(HttpClient httpClient, String url, Map headers, HttpState state, NameValuePair[] parametersBody) {
        return PureClient.postHttpRequest(httpClient, url, headers, state, parametersBody, "GBK");
    }

    public static String getHttpClientProxyHost() {
        String proxy = System.getProperty("trsdev4.httpClient.proxyHost");
        return proxy;
    }

    public static int getHttpClientProxyPort() {
        return PropertyUtil.getPropertyAsInt(System.getProperties(), "trsdev4.httpClient.proxyPort", -1);
    }
}

