/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.searcher;

import com.trs.client.ClassInfo;
import com.trs.client.TRSConnection;
import com.trs.client.TRSDataBase;
import com.trs.client.TRSException;
import com.trs.client.TRSResultSet;
import com.trs.dev4.jdk16.dao.Condition;
import com.trs.dev4.jdk16.dao.GroupByResult;
import com.trs.dev4.jdk16.dao.PagedList;
import com.trs.dev4.jdk16.dao.SearchFilter;
import com.trs.dev4.jdk16.exception.DAOException;
import com.trs.dev4.jdk16.utils.StringHelper;
import com.trs.dev4.searcher.ISearchable;
import com.trs.dev4.searcher.ISearcher;
import com.trs.dev4.searcher.ISearcherProvider;
import com.trs.dev4.searcher.constant.SearchConst;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TRSSearcher
implements ISearcher {
    private String serverIP;
    private String serverPort;
    private String userName;
    private String password;
    private String charset;
    private int iCutsize = 200;
    private String strHitColor;
    private List<String> keywordFileds;
    private static final Logger LOG = Logger.getLogger(TRSSearcher.class);

    public TRSSearcher(String serverIP, String serverPort, String userName, String password, String charset) {
        this.serverIP = serverIP;
        this.serverPort = serverPort;
        this.userName = userName;
        this.password = password;
        this.charset = charset;
    }

    public TRSSearcher(String serverIP, String serverPort, String userName, String password) {
        this(serverIP, serverPort, userName, password, null);
    }

    public TRSSearcher() {
    }

    @Override
    public PagedList<ISearchable> search(SearchFilter searchFilter, ISearcherProvider searcherProvider) {
        int pageIndex = 0;
        int records = 0;
        PagedList<ISearchable> results = new PagedList<ISearchable>(new LinkedList(), pageIndex, searchFilter.getMaxResults(), records);
        TRSConnection conn = null;
        TRSResultSet rtst = null;
        String strStat = null;
        String dbName = searcherProvider.getSearcherDatabase();
        if (StringHelper.isEmpty(dbName)) {
            return results;
        }
        String trser = this.buildSearchExpression(searchFilter);
        String defaultFields = searchFilter.getDefaultFields();
        try {
            try {
                conn = this.getConnection();
                TRSDataBase base = this.getDatabase(conn, dbName);
                LOG.info((Object)("TRSDataBase " + dbName + " encoding: " + base.getProperty("LANGUAGE") + "; TRSConnection encoding: " + TRSConnection.getCharset((boolean)false) + "; defaultEncoding:" + TRSConnection.getCharset((boolean)true)));
                rtst = conn.executeSelect(dbName, trser, searchFilter.getOrderBy(), strStat, defaultFields, 4097, 115, this.isSecondSearch(searchFilter));
                LOG.debug((Object)("TRSDBName:" + dbName + ",expression:" + trser + ",defaultFields:" + defaultFields + ",rtst.size():" + rtst.getRecordCount()));
                String groupBy = searchFilter.getGroupBy();
                List<GroupByResult.GroupByRecord> crs = this.categoryRecordFactory(rtst, groupBy, searchFilter.getOrderBy());
                GroupByResult cbr = new GroupByResult(groupBy, crs);
                LOG.debug((Object)("GroupBy:" + groupBy + ",GroupByResult-size:" + cbr.getRecords().size()));
                if (LOG.isDebugEnabled()) {
                    for (GroupByResult.GroupByRecord groupByRecord : cbr.getRecords()) {
                        LOG.debug((Object)("GroupByRecord(" + groupBy + "):" + groupByRecord.getFieldValue() + "," + groupByRecord.getRecordCount()));
                    }
                }
                rtst.setBufferSize(searchFilter.getStartPos() / searchFilter.getMaxResults(), searchFilter.getMaxResults());
                results = this.buildResultPage(rtst, searchFilter, searcherProvider);
                results.setGroupByResult(cbr);
            }
            catch (TRSException ex) {
                StringBuilder sb = new StringBuilder();
                sb.append("TRS\u5168\u6587\u68c0\u7d22\u51fa\u73b0\u5f02\u5e38\uff1a").append(ex.getMessage()).append(this.serverIP).append(":").append(this.serverPort).append(", ").append(this.userName).append("@").append(dbName).append("; \u68c0\u7d22\u8bed\u53e5\uff1a").append(trser).append(", \u9ed8\u8ba4\u68c0\u7d22\u5b57\u6bb5\uff1a").append(defaultFields);
                LOG.error((Object)sb.toString(), (Throwable)ex);
                throw new DAOException(ex);
            }
        }
        finally {
            this.cleanConnection(conn);
        }
        return results;
    }

    TRSDataBase getDatabase(TRSConnection conn, String dbName) throws TRSException {
        TRSDataBase[] arrDb = conn.getDataBases(dbName);
        if (arrDb == null || arrDb.length == 0) {
            return null;
        }
        return arrDb[0];
    }

    private List<GroupByResult.GroupByRecord> categoryRecordFactory(TRSResultSet rtst, String groupby, String orderBy) throws TRSException {
        LinkedList<GroupByResult.GroupByRecord> records = new LinkedList<GroupByResult.GroupByRecord>();
        if (StringHelper.isEmpty(groupby) || 0L == rtst.getRecordCount()) {
            return records;
        }
        int iPruneStore = 0;
        String groupValue = "";
        boolean orderby = false;
        int iClassNum = rtst.classResult(groupby, groupValue, iPruneStore, orderBy, orderby, 1);
        LOG.debug((Object)("Group by (" + groupby + "," + orderBy + ") classNum:" + iClassNum));
        int i = 0;
        while (i < iClassNum) {
            ClassInfo classInfo = rtst.getClassInfo(i);
            String fieldValue = classInfo.strValue;
            int recordCount = classInfo.iRecordNum;
            GroupByResult.GroupByRecord cr = new GroupByResult.GroupByRecord(fieldValue, recordCount);
            LOG.debug((Object)("Group by (" + groupby + "," + orderBy + ") classInfo(" + i + "):" + classInfo.toString() + ",fieldValue:" + fieldValue + ",recordNum:" + recordCount));
            records.add(cr);
            ++i;
        }
        return records;
    }

    Map<String, String> processSearchResult(TRSResultSet rtst) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (rtst == null) {
            return result;
        }
        int columns = 0;
        long recordID = 0L;
        try {
            columns = rtst.getColumnCount();
            recordID = rtst.getRecordID();
            result.put("recordId", String.valueOf(recordID));
        }
        catch (TRSException e) {
            LOG.error((Object)("GetColumnCount error:" + e.getMessage()), (Throwable)e);
        }
        int i = 0;
        while (i < columns) {
            try {
                String columnName = rtst.getColumnName(i);
                String columnValue = this.columnValueBuilder(rtst, i, columnName);
                result.put(columnName, columnValue);
            }
            catch (TRSException e) {
                LOG.error((Object)("Record(" + recordID + ")'s GetColumnName( " + i + ") error \uff1a" + e.getMessage()), (Throwable)e);
            }
            ++i;
        }
        return result;
    }

    protected String columnValueBuilder(TRSResultSet rtst, int i, String columnName) throws TRSException {
        if (StringHelper.isEmpty(columnName)) {
            return "";
        }
        String value = rtst.getString(i);
        if (this.keywordFileds == null || this.keywordFileds.size() == 0) {
            return value;
        }
        if (this.keywordFileds.contains(columnName)) {
            return rtst.getStringWithCutsize(i, this.iCutsize, this.strHitColor);
        }
        return value;
    }

    PagedList<ISearchable> buildResultPage(TRSResultSet rtst, SearchFilter searchFilter, ISearcherProvider searcherProvider) throws TRSException {
        int pageSize = searchFilter.getMaxResults();
        int pageIndex = searchFilter.getStartPos() / searchFilter.getMaxResults();
        if (0L == rtst.getValidCount()) {
            return new PagedList<ISearchable>(new LinkedList(), pageIndex, pageSize, 0);
        }
        LinkedList<ISearchable> itemList = new LinkedList<ISearchable>();
        rtst.moveTo(0, (long)searchFilter.getStartPos());
        int count = 0;
        while (count < pageSize) {
            ISearchable searchable = searcherProvider.buildSearchedObject(this.processSearchResult(rtst));
            itemList.add(searchable);
            if (!rtst.moveNext()) break;
            ++count;
        }
        PagedList<ISearchable> pagedList = new PagedList<ISearchable>(itemList, pageIndex, pageSize, (int)rtst.getRecordCount());
        return pagedList;
    }

    String strFormer(List<String> strs, String formStr) {
        if (strs == null || strs.size() == 0) {
            return "";
        }
        if (StringHelper.isEmpty(formStr)) {
            formStr = ";";
        }
        StringBuffer sb = new StringBuffer();
        int size = strs.size();
        int i = 0;
        while (i < size) {
            sb.append(strs.get(i).trim());
            if (i != size - 1) {
                sb.append(formStr);
            }
            ++i;
        }
        return sb.toString();
    }

    TRSConnection getConnection() throws TRSException {
        TRSConnection conn = new TRSConnection();
        conn.connect(this.serverIP, this.serverPort, this.userName, this.password);
        if (!StringHelper.isEmpty(this.charset)) {
            try {
                TRSConnection.setCharset((int)this.getCharset(this.charset), (boolean)true);
            }
            catch (Throwable e) {
                LOG.error((Object)("TRSConnection.setCharset to " + this.charset + " failed"), e);
            }
        }
        return conn;
    }

    private int getCharset(String charset) {
        int iCharset = 0;
        if (StringHelper.isEmpty(charset)) {
            charset = SearchConst.DEFAULT_CHARSET;
        }
        iCharset = (charset = charset.toUpperCase()).equalsIgnoreCase("GBK") ? 1 : 3;
        return iCharset;
    }

    public void cleanConnection(TRSConnection conn) {
        if (conn != null) {
            conn.clean();
        }
    }

    String buildSearchExpression(SearchFilter searchFilter) {
        if (searchFilter == null) {
            return null;
        }
        int totalCount = searchFilter.getTotalConditions();
        StringBuilder sb = new StringBuilder();
        if (!this.isConditionEmpty(totalCount)) {
            sb.append("(");
        }
        int i = 0;
        while (i < totalCount) {
            Condition condition = searchFilter.getCondition(i);
            this.conditionBuilder(sb, condition);
            if (totalCount > 1 && i < totalCount - 1) {
                sb.append(" and ");
            }
            ++i;
        }
        if (!this.isConditionEmpty(totalCount)) {
            sb.append(")");
        }
        String defaultKeyWord = searchFilter.getDefaultKeyword();
        if (this.isConditionEmpty(totalCount)) {
            return defaultKeyWord;
        }
        if (!StringHelper.isEmpty(defaultKeyWord)) {
            sb.append(" and ").append(defaultKeyWord);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("search filter is--:" + sb.toString()));
        }
        return sb.toString();
    }

    private boolean isConditionEmpty(int totalCount) {
        return totalCount == 0;
    }

    void conditionBuilder(StringBuilder sb, Condition condition) {
        sb.append("(");
        sb.append(condition.getField()).append(' ');
        if (condition.isLikeCondition()) {
            sb.append(" = ").append(this.formatSearchWord(condition.getValue().toString()));
        } else if (condition.isBetweenCondition()) {
            sb.append('(').append(condition.getField()).append(" >= ").append(this.formatSearchWord(condition.getValue().toString())).append(')');
            sb.append(" and (").append(condition.getField()).append(" <= ").append(this.formatSearchWord(condition.getValue2().toString())).append(")");
        } else if (condition.needBindCollectionParam()) {
            List values = (List)condition.getValue();
            int j = 0;
            while (j < values.size()) {
                sb.append(this.formatSearchWord(((String)values.get(j)).toString()));
                if (j != values.size() - 1) {
                    sb.append(',');
                }
                ++j;
            }
        } else {
            sb.append(condition.getOp()).append(' ');
            sb.append(this.formatSearchWord(condition.getValue().toString()));
        }
        sb.append(")");
    }

    private String formatSearchWord(String sw) {
        sw = sw.trim();
        sw = this.squeezeWhiteSpace(sw);
        sw = this.replaceString(sw, "\\", "\\\\");
        sw = this.replaceString(sw, "'", "\\'");
        sw = this.replaceString(sw, "%", "\\%");
        sw = this.replaceString(sw, "?", "\\?");
        StringBuffer sb = new StringBuffer();
        sb.append("'").append(sw).append("'");
        return sb.toString();
    }

    private String replaceString(String str, String substr, String restr) {
        if (str == null) {
            return null;
        }
        if (substr == null || substr.length() == 0) {
            return str;
        }
        String[] tmp = this.splitString(str, substr);
        String returnstr = null;
        if (tmp.length != 0) {
            returnstr = tmp[0];
            int i = 0;
            while (i < tmp.length - 1) {
                returnstr = String.valueOf(this.dealNull(returnstr)) + restr + tmp[i + 1];
                ++i;
            }
        }
        return this.dealNull(returnstr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String[] splitString(String toSplit, String delimiter) {
        int div_length;
        int intIdex;
        int intIdx;
        int arynum;
        block10: {
            if (toSplit == null) {
                return new String[0];
            }
            arynum = 0;
            intIdx = 0;
            intIdex = 0;
            div_length = delimiter.length();
            if (toSplit.compareTo("") != 0) {
                if (toSplit.indexOf(delimiter) != -1) {
                    intIdx = toSplit.indexOf(delimiter);
                    int intCount = 1;
                    while (true) {
                        if (toSplit.indexOf(delimiter, intIdx + div_length) == -1) {
                            arynum += 2;
                            break block10;
                        }
                        intIdx = toSplit.indexOf(delimiter, intIdx + div_length);
                        arynum = intCount++;
                    }
                }
                arynum = 1;
            } else {
                arynum = 0;
            }
        }
        intIdx = 0;
        intIdex = 0;
        String[] returnStr = new String[arynum];
        if (toSplit.compareTo("") == 0) return returnStr;
        if (toSplit.indexOf(delimiter) != -1) {
            intIdx = toSplit.indexOf(delimiter);
            returnStr[0] = toSplit.substring(0, intIdx);
            int intCount = 1;
            while (true) {
                if (toSplit.indexOf(delimiter, intIdx + div_length) != -1) {
                    intIdex = toSplit.indexOf(delimiter, intIdx + div_length);
                    returnStr[intCount] = toSplit.substring(intIdx + div_length, intIdex);
                    intIdx = toSplit.indexOf(delimiter, intIdx + div_length);
                    ++intCount;
                    continue;
                }
                break;
            }
        } else {
            returnStr[0] = toSplit.substring(0, toSplit.length());
            return returnStr;
        }
        returnStr[intCount] = toSplit.substring(intIdx + div_length, toSplit.length());
        return returnStr;
    }

    private String squeezeWhiteSpace(String str) {
        str = this.dealNull(str);
        StringBuffer sb = new StringBuffer(str);
        StringBuffer sb2 = new StringBuffer();
        boolean flag = false;
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            if (c != ' ' && c != '\t') {
                if (flag) {
                    sb2.append(' ');
                    flag = false;
                }
                sb2.append(c);
            } else {
                flag = true;
            }
            ++i;
        }
        return sb2.toString().trim();
    }

    private String dealNull(String str) {
        String returnstr = null;
        returnstr = str == null ? "" : str;
        return returnstr;
    }

    private boolean isSecondSearch(SearchFilter searchFilter) {
        boolean isSecondSearch = false;
        return isSecondSearch;
    }

    public void setServerIP(String serverIP) {
        this.serverIP = serverIP;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    @Override
    public void setICutsize(int iCutsize) {
        this.iCutsize = iCutsize;
    }

    @Override
    public void setStrHitColor(String strHitColor) {
        this.strHitColor = strHitColor;
    }

    @Override
    public void setKeywordFileds(List<String> keywordFileds) {
        this.keywordFileds = keywordFileds;
    }
}

