/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.wordfilter;

import com.trs.dev4.jdk16.utils.NumberUtil;
import com.trs.dev4.jdk16.wordfilter.Dictionary;
import com.trs.dev4.jdk16.wordfilter.IWordFilter;
import com.trs.dev4.jdk16.wordfilter.Word;
import com.trs.dev4.jdk16.wordfilter.WordFilterImpl;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Visitor;
import org.dom4j.VisitorSupport;

public class WordVisitorSupport
extends VisitorSupport {
    protected static final Logger LOG = Logger.getLogger(WordVisitorSupport.class);
    LinkedList<String> groupNames = new LinkedList();
    LinkedList<String> groupNamesWithSystem = new LinkedList();
    Element root;
    IWordFilter wordFilter;
    Map<String, Dictionary> dicMap = new HashMap<String, Dictionary>();

    public WordVisitorSupport(Element root, IWordFilter wordFilter) {
        this.root = root;
        this.wordFilter = wordFilter;
        root.accept((Visitor)this);
    }

    public void visit(Element element) {
        if (element.getName().equalsIgnoreCase(Word.WORD_SYSTEM_GROUP)) {
            this.dicMap.put("system", this.XML2Dictionary(this.wordFilter.getSystemDictionary(), this.root, element));
            this.groupNamesWithSystem.addLast("system");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"\u52a0\u8f7d\u7cfb\u7edf\u8fc7\u6ee4\u8bcd\u5178:system");
            }
        }
        if (element.getName().equalsIgnoreCase(Word.WORD_GROUP)) {
            String keyId = element.attributeValue(Word.WORD_ID);
            this.dicMap.put(keyId, this.XML2Dictionary(new Dictionary(keyId), this.root, element));
            this.groupNames.addLast(keyId);
            this.groupNamesWithSystem.addLast(keyId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("\u52a0\u8f7d\u81ea\u5b9a\u4e49\u8fc7\u6ee4\u8bcd\u5178:" + keyId));
            }
        }
    }

    private Dictionary XML2Dictionary(Dictionary dic, Element root, Element element) {
        Iterator iter = element.elementIterator();
        while (iter.hasNext()) {
            Element iElement = (Element)iter.next();
            String level = iElement.attributeValue(Word.WORD_LEVEL);
            String word = iElement.getText();
            String color = iElement.attributeValue(Word.WORD_COLOR);
            if (word == null) {
                LOG.warn((Object)("detected a null filterword:" + word + "; dictionary:" + dic.toString()));
                continue;
            }
            StringBuffer sb = new StringBuffer(word.length() * 2);
            int i = 0;
            while (i < word.length()) {
                char c = word.charAt(i);
                if (c < '\uffff' && !this.wordFilter.ingoreChar(c)) {
                    sb.append(c);
                }
                ++i;
            }
            if (WordFilterImpl.isBlank(color)) {
                color = element.attributeValue(Word.WORD_COLOR);
            }
            if (WordFilterImpl.isBlank(color)) {
                color = root.attributeValue(Word.WORD_COLOR);
            }
            if (WordFilterImpl.isBlank(color)) {
                color = "red";
            }
            dic.addWord(sb.toString(), NumberUtil.parseInt(level), color);
        }
        return dic;
    }

    public Map<String, Dictionary> getDicMap() {
        return this.dicMap;
    }

    public LinkedList<String> getGroupNames() {
        return this.groupNames;
    }

    public LinkedList<String> getGroupNamesWithSystem() {
        return this.groupNamesWithSystem;
    }
}

