/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.utils.FailInfoUtil;
import com.trs.dev4.jdk16.utils.FileUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

class TRSFTPClient {
    private FTPClient ftp;

    TRSFTPClient() {
    }

    boolean login(String host, int port, String userName, String password, String controlEncoding) throws RuntimeException {
        boolean loginResult = false;
        this.ftp = new FTPClient();
        try {
            if (controlEncoding != null && controlEncoding.trim().length() != 0) {
                this.ftp.setControlEncoding(controlEncoding);
            }
            this.ftp.connect(host, port);
        }
        catch (IOException e) {
            String errorMessage = FailInfoUtil.getConnetFailInfo(host, port, controlEncoding);
            throw new RuntimeException(errorMessage, e);
        }
        try {
            this.ftp.setFileType(2);
        }
        catch (IOException e) {
            if (this.ftp.isConnected()) {
                this.logout();
            }
            String errorMessage = FailInfoUtil.getSetFileTypeFailInfo("BINARY_FILE_TYPE");
            throw new RuntimeException(errorMessage, e);
        }
        try {
            loginResult = this.ftp.login(userName, password);
        }
        catch (Exception e) {
            if (this.ftp.isConnected()) {
                this.logout();
            }
            String errorMessage = FailInfoUtil.getLoginFailInfo(userName, password);
            throw new RuntimeException(errorMessage, e);
        }
        return loginResult;
    }

    void logout() {
        this.closeFTPConnection(this.ftp);
    }

    private void uploadFile(String localFilePath, String remoteFileName, boolean ignoreSameFile) throws RuntimeException {
        FileInputStream input = null;
        try {
            input = new FileInputStream(localFilePath);
        }
        catch (FileNotFoundException f) {
            String errorMessage = FailInfoUtil.getFileNoExistInfo(localFilePath);
            throw new RuntimeException(errorMessage, f);
        }
        try {
            if (!this.isFileExist(remoteFileName)) {
                this.ftp.storeFile(remoteFileName, (InputStream)input);
            } else if (!ignoreSameFile) {
                this.ftp.storeFile(remoteFileName, (InputStream)input);
            }
        }
        catch (IOException e) {
            String errorMessage = FailInfoUtil.getUploadFailInfo(localFilePath);
            throw new RuntimeException(errorMessage, e);
        }
    }

    void upload(String localFilePath, boolean ignoreSameFile) throws RuntimeException {
        String[] remoteFileNameSplit = StringHelper.split(localFilePath, "\\\\");
        String remoteFileName = remoteFileNameSplit[remoteFileNameSplit.length - 1];
        this.uploadFile(localFilePath, remoteFileName, ignoreSameFile);
    }

    void upload(String localFilePath, String destPath, boolean ignoreSameFile) throws RuntimeException {
        this.createDirectoryOnFTPServer(destPath);
        this.changeFTPServerWorkingDirectory(destPath);
        String[] remoteFileNameSplit = StringHelper.split(localFilePath, "\\\\");
        String remoteFileName = remoteFileNameSplit[remoteFileNameSplit.length - 1];
        this.uploadFile(localFilePath, remoteFileName, ignoreSameFile);
    }

    void delete(String fileName) throws RuntimeException {
        try {
            this.ftp.deleteFile(fileName);
        }
        catch (IOException e) {
            String errorMessage = FailInfoUtil.getDeleteFailInfo(fileName);
            throw new RuntimeException(errorMessage, e);
        }
    }

    boolean deleteEmptyFolder(String folderName) throws RuntimeException {
        boolean removeDirectoryResult = false;
        try {
            removeDirectoryResult = this.ftp.removeDirectory(folderName);
        }
        catch (IOException e) {
            String errorMessage = FailInfoUtil.getDeleteEmptyFolder(folderName);
            throw new RuntimeException(errorMessage, e);
        }
        return removeDirectoryResult;
    }

    void delete(String destPath, String fileName) throws RuntimeException {
        this.changeFTPServerWorkingDirectory(destPath);
        this.delete(fileName);
    }

    @Deprecated
    List<String> list() throws RuntimeException {
        ArrayList<String> listFileName = new ArrayList<String>();
        FTPFile[] listFiles = null;
        try {
            this.ftp.setControlEncoding("utf-8");
            listFiles = this.ftp.listFiles();
        }
        catch (IOException e) {
            String errorMessage = FailInfoUtil.getListFilesFailInfo();
            throw new RuntimeException(errorMessage, e);
        }
        int i = 2;
        while (i < listFiles.length) {
            listFileName.add(listFiles[i].getName());
            ++i;
        }
        return listFileName;
    }

    String[] getFileNames(String[] exts) throws RuntimeException {
        String[] fileNames = null;
        try {
            fileNames = this.ftp.listNames();
        }
        catch (IOException e) {
            String errorMessage = FailInfoUtil.getListFilesFailInfo();
            throw new RuntimeException(errorMessage, e);
        }
        if (fileNames != null && exts != null) {
            fileNames = this.getFileNamesByExts(fileNames, exts);
        }
        return fileNames;
    }

    FTPFile[] getFiles(String[] exts) throws RuntimeException {
        FTPFile[] ftpfiles;
        try {
            ftpfiles = this.ftp.listFiles();
        }
        catch (IOException e) {
            String errorMessage = FailInfoUtil.getListFilesFailInfo();
            throw new RuntimeException(errorMessage, e);
        }
        if (ftpfiles != null) {
            // empty if block
        }
        return ftpfiles;
    }

    private String[] getFileNamesByExts(String[] fileNames, String[] exts) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        int i = 0;
        while (i < fileNames.length) {
            fileNameList.add(fileNames[i]);
            ++i;
        }
        i = 0;
        while (i < fileNameList.size()) {
            boolean flag = false;
            String fileName = (String)fileNameList.get(i);
            String[] stringArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                String ext = stringArray[n2];
                if (ext.equals(this.getFileNameExtension(fileName))) {
                    flag = true;
                }
                ++n2;
            }
            if (!flag) {
                fileNameList.remove(fileNameList.get(i));
                --i;
            }
            ++i;
        }
        int len = fileNameList.size();
        String[] newFileNames = new String[len];
        int i2 = 0;
        while (i2 < len) {
            newFileNames[i2] = (String)fileNameList.get(i2);
            ++i2;
        }
        return newFileNames;
    }

    private String getFileNameExtension(String fileName) {
        return FileUtil.getFileExtension(new File(fileName));
    }

    @Deprecated
    List<String> list(String destPath) throws RuntimeException {
        this.changeFTPServerWorkingDirectory(destPath);
        return this.list();
    }

    String[] getFileNames(String destPath, String[] exts) throws RuntimeException {
        this.changeFTPServerWorkingDirectory(destPath);
        return this.getFileNames(exts);
    }

    FTPFile[] getfiles(String destPath, String[] exts) {
        this.changeFTPServerWorkingDirectory(destPath);
        return this.getFiles(exts);
    }

    String getUploadloadTime() throws RuntimeException {
        return "";
    }

    int getUploadAmount(String srcDir) throws RuntimeException {
        File fileDir = new File(srcDir);
        String[] uploadFiles = fileDir.list();
        return uploadFiles.length;
    }

    private void createDirectoryOnFTPServer(String WorkingDirectory) throws RuntimeException {
        try {
            this.ftp.makeDirectory(WorkingDirectory);
        }
        catch (IOException e) {
            String errorMessage = FailInfoUtil.getCreateDirectoryFailInfo(WorkingDirectory);
            throw new RuntimeException(errorMessage, e);
        }
    }

    void changeFTPServerWorkingDirectory(String WorkingDirectory) throws RuntimeException {
        try {
            this.ftp.changeWorkingDirectory(WorkingDirectory);
        }
        catch (IOException e) {
            String errorMessage = FailInfoUtil.getChangeWorkingDirectoryFailInfo(WorkingDirectory);
            throw new RuntimeException(errorMessage, e);
        }
    }

    private boolean isFileExist(String fileName) throws RuntimeException {
        List<String> listFiles = this.list();
        boolean isFileExist = false;
        int i = 0;
        while (i < listFiles.size()) {
            if (listFiles.get(i).equals(fileName)) {
                isFileExist = true;
                return isFileExist;
            }
            ++i;
        }
        return isFileExist;
    }

    private void closeFTPConnection(FTPClient ftp) {
        try {
            ftp.disconnect();
        }
        catch (IOException e) {
            String errorMessage = "error on close FTPClient, ignored!";
            throw new RuntimeException(errorMessage, e);
        }
    }

    void copyFile(String srcFile, String destFile) {
        FileOutputStream fos = null;
        try {
            try {
                File file = new File(destFile);
                fos = new FileOutputStream(file);
                this.ftp.retrieveFile(srcFile, (OutputStream)fos);
            }
            catch (FileNotFoundException fnfex) {
                String errorMessage = FailInfoUtil.getFileNotFoundInfo(destFile);
                throw new RuntimeException(errorMessage, fnfex);
            }
            catch (IOException ioe) {
                String errorMessage = FailInfoUtil.getIOExceptionInfo(ioe.getMessage());
                throw new RuntimeException(errorMessage, ioe);
            }
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e) {
                String errorMessage = "error on close FileOutputStream, ignored!";
                throw new RuntimeException(errorMessage, e);
            }
        }
    }
}

