/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.exception.WrappedException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class SortedProperties
extends Properties {
    public SortedProperties() {
    }

    public SortedProperties(Properties props) {
        if (props == null) {
            return;
        }
        Set<Object> keys = props.keySet();
        for (Object key : keys) {
            this.put(key, props.get(key));
        }
    }

    @Override
    public synchronized Enumeration keys() {
        Vector<Object> v = new Vector<Object>(this.keySet());
        Collections.sort(v);
        return v.elements();
    }

    @Override
    public void list(PrintStream out) {
        try {
            super.store(out, "-- listing properties --");
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        int max = this.size() - 1;
        if (max == -1) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int i = 0;
        SortedProperties sortedProperties = this;
        synchronized (sortedProperties) {
            Enumeration e = this.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                sb.append(key).append('=').append(this.get(key));
                if (i == max) {
                    return sb.append('}').toString();
                }
                ++i;
                sb.append(", ");
            }
        }
        return sb.toString();
    }
}

