/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.utils.StringHelper;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class NumberUtil {
    private static final int STORE_UNITS = 1024;
    private static final String K_NUITS = "K";
    private static final String M_NUITS = "M";
    private static final String G_NUITS = "G";
    private static final String BYTE_NUITS = "BYTE";

    public static int parseInt(String str) {
        return NumberUtil.parseInt(str, 0);
    }

    public static int parseInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        if ((str = str.trim()).indexOf(46) > 0) {
            try {
                return (int)Float.parseFloat(str);
            }
            catch (Exception e) {
                return defaultValue;
            }
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int parseInt(Object obj, int defVal) {
        if (obj == null) {
            return defVal;
        }
        if (obj instanceof String) {
            return NumberUtil.parseInt((String)obj, defVal);
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        return defVal;
    }

    public static long parseLong(String str) {
        return NumberUtil.parseLong(str, 0L);
    }

    public static long parseLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        str = str.trim();
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double transLongToDouble(long value) {
        return new Long(value).doubleValue();
    }

    public static String getFormatFromDouble(double doubleValue, String pattern) {
        DecimalFormat nf = new DecimalFormat(pattern.trim());
        if (0.0 == Math.abs(doubleValue)) {
            return String.valueOf(0) + nf.format(doubleValue);
        }
        if (doubleValue > 0.0 && 0.0 == Math.floor(doubleValue)) {
            return String.valueOf(0) + nf.format(doubleValue);
        }
        if (doubleValue < 0.0 && 0.0 == Math.ceil(doubleValue)) {
            return "-0" + nf.format(Math.abs(doubleValue));
        }
        return nf.format(doubleValue);
    }

    public static String getSpaceAsUnits(long count, String units, String pattern) {
        if (StringHelper.isEmpty(units) || StringHelper.isEmpty(pattern)) {
            return String.valueOf(count) + BYTE_NUITS;
        }
        units = units.trim();
        pattern = pattern.trim();
        if (K_NUITS.equals(units)) {
            return String.valueOf(NumberUtil.getFormatFromDouble(NumberUtil.transLongToDouble(count) / 1024.0, pattern)) + K_NUITS;
        }
        if (M_NUITS.equals(units)) {
            return String.valueOf(NumberUtil.getFormatFromDouble(NumberUtil.transLongToDouble(count) / Math.pow(1024.0, 2.0), pattern)) + M_NUITS;
        }
        if (G_NUITS.equals(units)) {
            return String.valueOf(NumberUtil.getFormatFromDouble(NumberUtil.transLongToDouble(count) / Math.pow(1024.0, 3.0), pattern)) + G_NUITS;
        }
        return String.valueOf(count) + BYTE_NUITS;
    }

    public static double getPercentage(double dividend, double divisor) {
        if (0.0 == divisor) {
            throw new IllegalArgumentException("divisor is 0!");
        }
        return dividend / divisor * 100.0;
    }

    public static int getPercentageAsInt(long dividend, long divisor) {
        if (divisor == 0L) {
            return 0;
        }
        return (int)((double)dividend / (double)divisor * 100.0);
    }

    public static int getMin(int a, int b) {
        return a > b ? b : a;
    }

    public static int getMax(int a, int b) {
        return a < b ? b : a;
    }

    public static double[] sequential(double duration, int total) {
        double[] result = new double[total];
        int i = 1;
        while (i <= result.length) {
            result[i - 1] = duration * (double)i / (double)total;
            ++i;
        }
        return result;
    }

    public static double roundHalfUp(double origin, int bitsAfterDot) {
        BigDecimal b = new BigDecimal(origin);
        return b.setScale(bitsAfterDot, 4).doubleValue();
    }

    public static double dividedAndHalfUp(int dividend, int divisor, int bitsAfterDot) {
        return NumberUtil.roundHalfUp((double)dividend / (double)divisor, bitsAfterDot);
    }
}

