/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.exception.RemoteException;
import com.trs.dev4.jdk16.exception.WrappedException;
import com.trs.dev4.jdk16.file.IFile;
import com.trs.dev4.jdk16.file.IProgressListener;
import com.trs.dev4.jdk16.file.impl.FtpFileImpl;
import com.trs.dev4.jdk16.utils.CloseUtil;
import com.trs.dev4.jdk16.utils.FileUtil;
import com.trs.dev4.jdk16.utils.IOUtil;
import com.trs.dev4.jdk16.utils.PropertyUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import com.trs.dev4.jdk16.utils.TRSFTPClient;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.apache.log4j.Logger;

public class FTPUtil {
    private static final Logger LOG = Logger.getLogger(FTPUtil.class);

    public static String tryConnectAndLogin(String host, int port, String userName, String passwd) {
        FTPClient ftp = FTPUtil.makeFTPSession(host, port, userName, passwd, null);
        return ftp.getReplyString();
    }

    public static String tryConnect(String host, int port) {
        FTPClient ftp = FTPUtil.makeFTPSession(host, port);
        return ftp.getReplyString();
    }

    static FTPClient makeFTPSession(String host, int port, String userName, String passwd, String encoding) {
        FTPClient ftp = FTPUtil.makeFTPSession(host, port);
        ftp.setControlEncoding(StringHelper.avoidEmpty(encoding, "UTF-8"));
        if (!StringHelper.isEmpty(userName)) {
            boolean loginSuccess;
            try {
                loginSuccess = ftp.login(userName, passwd);
            }
            catch (IOException e) {
                throw new WrappedException(e);
            }
            if (!loginSuccess) {
                throw new WrappedException("FTP\u767b\u5f55\u5931\u8d25: " + ftp.getReplyString());
            }
        }
        return ftp;
    }

    private static boolean inDebugMode() {
        return PropertyUtil.getSysPropertyAsBool("dev4.infra.ftp.isDebug");
    }

    static void enterDebugMode() {
        System.setProperty("dev4.infra.ftp.isDebug", "true");
    }

    static void leaveDebugMode() {
        System.setProperty("dev4.infra.ftp.isDebug", "");
    }

    static FTPClient makeFTPSession(String host, int port) {
        FTPClient ftp = new FTPClient();
        if (FTPUtil.inDebugMode()) {
            ftp.addProtocolCommandListener(new ProtocolCommandListener(){

                public void protocolReplyReceived(ProtocolCommandEvent event) {
                    System.out.print("Reply: " + event.getReplyCode() + " - " + event.getMessage());
                }

                public void protocolCommandSent(ProtocolCommandEvent event) {
                    System.out.print("FTP> " + event.getCommand() + " - " + event.getMessage());
                }
            });
        }
        int timeout = 10000;
        ftp.setDefaultTimeout(10000);
        ftp.setDataTimeout(10000);
        try {
            ftp.connect(host, port);
        }
        catch (IOException e) {
            throw new RemoteException("connect ftp://" + host + ":" + port + " fail.", e);
        }
        try {
            ftp.setSoTimeout(10000);
        }
        catch (SocketException e) {
            LOG.warn((Object)"setSoTimeout failed.");
        }
        return ftp;
    }

    public static List<IFile> list(String host, int port, String userName, String passwd, String encoding) {
        return FTPUtil.list(host, port, userName, passwd, encoding, "/", new String[0]);
    }

    public static List<IFile> list(String host, int port, String userName, String passwd, String encoding, String remoteDir, final String ... exts) {
        FTPFile[] files;
        FTPClient ftp = FTPUtil.makeFTPSession(host, port, userName, passwd, encoding);
        ftp.setListHiddenFiles(true);
        ftp.enterLocalPassiveMode();
        String encodedDir = StringHelper.getStringByEncoding(remoteDir, encoding, "ISO8859-1");
        try {
            files = ftp.listFiles(encodedDir, new FTPFileFilter(){

                public boolean accept(FTPFile ftpFile) {
                    String fileName = ftpFile.getName();
                    if (fileName.equals(".") || fileName.equals("..")) {
                        return false;
                    }
                    if (exts.length == 0) {
                        return true;
                    }
                    String[] stringArray = exts;
                    int n = exts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String ext = stringArray[n2];
                        if (fileName.endsWith(ext)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            });
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
        ArrayList<IFile> list = new ArrayList<IFile>(files.length);
        FTPFile[] fTPFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            FTPFile ftpFile = fTPFileArray[n2];
            FtpFileImpl ff = new FtpFileImpl(ftpFile);
            list.add(ff);
            ++n2;
        }
        return list;
    }

    static long getFileSize(FTPClient ftp, String remoteDir, final String srcFile, String encoding) {
        ftp.setListHiddenFiles(true);
        String encodedDir = StringHelper.getStringByEncoding(remoteDir, encoding, "ISO8859-1");
        try {
            FTPFile[] files = ftp.listFiles(encodedDir, new FTPFileFilter(){

                public boolean accept(FTPFile ftpFile) {
                    String name = ftpFile.getName();
                    return name.equals(srcFile);
                }
            });
            if (files == null || files.length == 0) {
                throw new WrappedException("file not exist: " + srcFile + "; FTPSession encoding: " + ftp.getControlEncoding());
            }
            return files[0].getSize();
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
    }

    public static File download(String host, int port, String userName, String passwd, String remoteDir, String remoteFile, String encoding, String localDir, IProgressListener listener) {
        return FTPUtil.download(host, port, userName, passwd, remoteDir, remoteFile, encoding, localDir, null, listener);
    }

    public static File download(String host, int port, String userName, String passwd, String remoteDir, String remoteFile, String encoding, String localDir, String localFile, IProgressListener listener) {
        InputStream is;
        FileOutputStream os;
        FTPClient ftp = FTPUtil.makeFTPSession(host, port, userName, passwd, encoding);
        ftp.enterLocalPassiveMode();
        try {
            ftp.setFileType(2);
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
        localDir = StringHelper.avoidEmpty(localDir, FileUtil.getCurrentWorkingDir());
        localFile = StringHelper.avoidEmpty(localFile, remoteFile);
        File resultFile = new File(localDir, localFile);
        try {
            os = new FileOutputStream(resultFile);
        }
        catch (FileNotFoundException e) {
            throw new WrappedException(e);
        }
        long srcSize = FTPUtil.getFileSize(ftp, remoteDir, remoteFile, encoding);
        String remotePath = String.valueOf(StringHelper.smartAppendSlashToEnd(remoteDir)) + remoteFile;
        try {
            String fileName = StringHelper.getStringByEncoding(remotePath, encoding, "ISO8859-1");
            is = ftp.retrieveFileStream(fileName);
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
        if (is == null) {
            throw new WrappedException("the remote file not exist: " + remotePath + "; FTP Code: " + ftp.getReplyString());
        }
        try {
            try {
                IOUtil.copy(is, os, listener, srcSize);
            }
            catch (IOException e) {
                throw new WrappedException(e);
            }
        }
        finally {
            CloseUtil.closeInputStream(is);
            CloseUtil.closeOutputStream(os);
        }
        return resultFile;
    }

    static void releaseSession(FTPClient ftp, String promptWhenErr) {
        try {
            if (!ftp.completePendingCommand()) {
                ftp.logout();
                ftp.disconnect();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"releaseSession failed: ", (Throwable)e);
        }
    }

    public static boolean testConnection(String host, int port, String userName, String password, String controlEncoding) {
        boolean testResult = false;
        TRSFTPClient ftpClient = new TRSFTPClient();
        try {
            testResult = ftpClient.login(host, port, userName, password, controlEncoding);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ftpClient.logout();
        return testResult;
    }

    public static void uploadFile(String host, String userName, String password, String localFilePath, String controlEncoding, boolean ignoreSameFile) throws RuntimeException {
        FTPUtil.uploadFile(host, 21, userName, password, localFilePath, controlEncoding, ignoreSameFile);
    }

    public static void uploadFile(String host, int port, String userName, String password, String localFilePath, String controlEncoding, boolean ignoreSameFile) throws RuntimeException {
        TRSFTPClient ftpClient = new TRSFTPClient();
        ftpClient.login(host, port, userName, password, controlEncoding);
        ftpClient.upload(localFilePath, ignoreSameFile);
        ftpClient.logout();
    }

    public static void uploadFile(String host, String userName, String password, String localFilePath, String destPath, String controlEncoding, boolean ignoreSameFile) throws RuntimeException {
        FTPUtil.uploadFile(host, 21, userName, password, localFilePath, destPath, controlEncoding, ignoreSameFile);
    }

    public static void uploadFile(String host, int port, String userName, String password, String localFilePath, String destPath, String controlEncoding, boolean ignoreSameFile) throws RuntimeException {
        TRSFTPClient ftpClient = new TRSFTPClient();
        ftpClient.login(host, port, userName, password, controlEncoding);
        ftpClient.upload(localFilePath, destPath, ignoreSameFile);
        ftpClient.logout();
    }

    public static void deleteFile(String host, String userName, String password, String fileName, String controlEncoding) throws RuntimeException {
        FTPUtil.deleteFile(host, 21, userName, password, fileName, controlEncoding);
    }

    public static void deleteFile(String host, int port, String userName, String password, String fileName, String controlEncoding) throws RuntimeException {
        TRSFTPClient ftpClient = new TRSFTPClient();
        ftpClient.login(host, port, userName, password, controlEncoding);
        ftpClient.delete(fileName);
        ftpClient.logout();
    }

    public static void deleteFile(String host, String userName, String password, String destPath, String fileName, String controlEncoding) throws RuntimeException {
        FTPUtil.deleteFile(host, 21, userName, password, destPath, fileName, controlEncoding);
    }

    public static void deleteFile(String host, int port, String userName, String password, String destPath, String fileName, String controlEncoding) throws RuntimeException {
        TRSFTPClient ftpClient = new TRSFTPClient();
        ftpClient.login(host, port, userName, password, controlEncoding);
        ftpClient.delete(destPath, fileName);
        ftpClient.logout();
    }
}

