/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.exception.WrappedException;
import com.trs.dev4.jdk16.utils.ArrayUtil;
import com.trs.dev4.jdk16.utils.FileUtil;
import de.schlichtherle.io.FileInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.mozilla.intl.chardet.nsDetector;
import org.mozilla.intl.chardet.nsICharsetDetectionObserver;

public class EncodingDetector {
    private static final Logger LOG = Logger.getLogger(EncodingDetector.class);
    private boolean found = false;
    private String result;
    private int lang;

    public static String getMostProbableCharset(File file) {
        FileInputStream is;
        String encoding = "UNABLE_DETECT";
        FileUtil.assertFileNotEmpty(file);
        try {
            is = new FileInputStream(file);
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
        Object[] probableSet = EncodingDetector.detectAll((InputStream)is);
        if (ArrayUtil.isEmpty(probableSet)) {
            return encoding;
        }
        return probableSet[0];
    }

    public static String[] detectAll(InputStream is) {
        Object[] probableSet;
        try {
            probableSet = new EncodingDetector().detectAllCharset(is);
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("probable encoding: " + ArrayUtil.toString(probableSet)));
        }
        return probableSet;
    }

    public String[] detectChineseCharset(InputStream in) throws IOException {
        String[] prob;
        int len;
        this.lang = 2;
        nsDetector det = new nsDetector(this.lang);
        det.Init(new nsICharsetDetectionObserver(){

            public void Notify(String charset) {
                EncodingDetector.this.found = true;
                EncodingDetector.this.result = charset;
            }
        });
        BufferedInputStream imp = new BufferedInputStream(in);
        byte[] buf = new byte[1024];
        boolean isAscii = true;
        while ((len = imp.read(buf, 0, buf.length)) != -1) {
            if (isAscii) {
                isAscii = det.isAscii(buf, len);
            }
            if (!isAscii && det.DoIt(buf, len, false)) break;
        }
        imp.close();
        in.close();
        det.DataEnd();
        if (isAscii) {
            this.found = true;
            prob = new String[]{"ASCII"};
        } else {
            prob = this.found ? new String[]{this.result} : det.getProbableCharsets();
        }
        return prob;
    }

    public String[] detectAllCharset(InputStream in) throws IOException {
        this.lang = 0;
        return this.detectChineseCharset(in);
    }
}

