/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.tunning;

import com.trs.dev4.jdk16.tunning.Stepper;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class PerformanceTimer {
    private static final Logger logger = Logger.getLogger(PerformanceTimer.class);
    private long beginTimeInMillis;
    private long stepBeginTimeInMillis;
    private List<Stepper> steppes;
    private String title;
    private long durationTheshold;

    public String getTitle() {
        return this.title;
    }

    public List<Stepper> getSteppes() {
        return this.steppes;
    }

    public PerformanceTimer() {
        this.stepBeginTimeInMillis = this.beginTimeInMillis = System.currentTimeMillis();
        this.steppes = new ArrayList<Stepper>();
        this.title = "PerformanceTimer";
        this.durationTheshold = 1000L;
    }

    public PerformanceTimer(String title) {
        this.stepBeginTimeInMillis = this.beginTimeInMillis = System.currentTimeMillis();
        this.steppes = new ArrayList<Stepper>();
        this.title = "PerformanceTimer";
        this.durationTheshold = 1000L;
        this.title = title;
    }

    public PerformanceTimer(String title, long durationTheshold) {
        this.stepBeginTimeInMillis = this.beginTimeInMillis = System.currentTimeMillis();
        this.steppes = new ArrayList<Stepper>();
        this.title = "PerformanceTimer";
        this.durationTheshold = 1000L;
        this.title = title;
        this.durationTheshold = durationTheshold;
    }

    public void stop(String name, String description) {
        long duration = this.getDuration();
        if (this.isSlow(duration)) {
            logger.debug((Object)("Action(" + name + ") consumed (" + duration + ") ms."));
        }
        this.steppes.add(new Stepper(name, description, duration));
    }

    public void stop(String name) {
        this.stop(name, "");
    }

    public void stop() {
        this.stop(this.title, "");
    }

    public void step(String name, String description) {
        long duration = this.getDuration();
        if (this.isSlow(duration)) {
            logger.debug((Object)("Action(" + name + "-" + description + ") consumed (" + duration + ") ms."));
        }
        this.steppes.add(new Stepper(name, description, duration));
    }

    public void step(String name) {
        this.step(name, "");
    }

    private boolean isSlow(long duration) {
        return duration > this.durationTheshold;
    }

    public long getDuration() {
        long duration = System.currentTimeMillis() - this.stepBeginTimeInMillis;
        this.stepBeginTimeInMillis = System.currentTimeMillis();
        return duration;
    }
}

