/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.session.impl;

import com.trs.dev4.jdk16.model.IModuleLifecycle;
import com.trs.dev4.jdk16.session.ISessionUser;
import com.trs.dev4.jdk16.session.impl.ApplicationSession;
import com.trs.dev4.jdk16.session.impl.BaseSessionHandler;
import com.trs.dev4.jdk16.thread.DaemonThreadControllor;
import com.trs.dev4.jdk16.thread.IThreadWorkload;
import com.trs.dev4.jdk16.utils.DateUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class LocalSessionHandler<T extends ISessionUser>
extends BaseSessionHandler<T>
implements IModuleLifecycle {
    private static final Logger logger = Logger.getLogger(LocalSessionHandler.class);
    protected Map<String, List<String>> loginedUserNames = new HashMap<String, List<String>>();
    private DaemonThreadControllor sessionTimeoutThread;
    protected TimestampCounter hourlyLoginedUsers = new TimestampCounter();
    protected TimestampCounter hourlyVisitedUsers = new TimestampCounter();
    protected TimestampCounter dailyLoginedUsers = new TimestampCounter();
    protected TimestampCounter dailyVisitedUsers = new TimestampCounter();
    protected Map<String, ApplicationSession> applicationSessions = new ConcurrentHashMap<String, ApplicationSession>();
    protected Map<String, String> consoleSessions = new ConcurrentHashMap<String, String>();
    private DaemonThreadControllor hourlyTimer;
    private DaemonThreadControllor dailyTimer;

    @Override
    public int countLoginedUsers() {
        return this.loginedUserNames.size();
    }

    @Override
    public int countTotalUsers() {
        return this.applicationSessions.size();
    }

    @Override
    protected T getUser(String userName) {
        return null;
    }

    @Override
    protected void userLogout(T user, ApplicationSession applicationSession) {
        this.removeLoginedUserName(applicationSession);
        logger.debug((Object)("User (" + user.getNickName() + ") logouted."));
    }

    @Override
    protected void applicationSessionUpdated(ApplicationSession as) {
        logger.debug((Object)("ApplicationSession (" + as + ") updated."));
    }

    @Override
    public boolean isOnline(String userName) {
        return this.isLogined(userName);
    }

    @Override
    public ApplicationSession getApplicationSession(String ucsid) {
        ApplicationSession as = this.applicationSessions.get(ucsid);
        logger.info((Object)("Found ApplicationSession(" + as + ") with ucsid(" + ucsid + ")."));
        return as;
    }

    @Override
    public Map<String, Object> statistic() {
        HashMap<String, Object> statistic = new HashMap<String, Object>();
        statistic.put("totalUsers", this.applicationSessions.size());
        statistic.put("applicationSessions", this.applicationSessions);
        statistic.put("loginedUserNames", this.loginedUserNames);
        statistic.put("dailyLoginedUsers", this.dailyLoginedUsers);
        statistic.put("dailyVisitedUsers", this.dailyVisitedUsers);
        statistic.put("hourlyLoginedUsers", this.hourlyLoginedUsers);
        statistic.put("hourlyVisitedUsers", this.hourlyVisitedUsers);
        return statistic;
    }

    @Override
    protected void userLogin(T user, ApplicationSession applicationSession) {
        this.updateLoginedUserName(applicationSession);
        this.hourlyLoginedUsers.count();
        this.dailyLoginedUsers.count();
    }

    @Override
    protected void applicationSessionCreated(ApplicationSession as) {
        this.applicationSessions.put(as.getId(), as);
        this.hourlyVisitedUsers.count();
        this.dailyVisitedUsers.count();
    }

    @Override
    protected void applicationSessionDeleted(ApplicationSession as) {
        if (as == null) {
            return;
        }
        this.applicationSessions.remove(as.getId());
        List<String> applicationSessionIds = this.loginedUserNames.get(as.getUserName());
        if (applicationSessionIds != null) {
            applicationSessionIds.remove(as.getId());
            if (applicationSessionIds.size() <= 0) {
                this.loginedUserNames.remove(as.getUserName());
            }
        }
        logger.debug((Object)("ApplicationSession (" + as.toString() + ") removed."));
    }

    protected boolean isRunning() {
        return true;
    }

    protected long getAnonymousTTL() {
        return 30L;
    }

    protected long getLoginedTTL() {
        return 120L;
    }

    private void removeLoginedUserName(ApplicationSession applicationSession) {
        List<String> applicationSessionIds = this.loginedUserNames.get(applicationSession.getUserName());
        if (applicationSessionIds != null) {
            applicationSessionIds.remove(applicationSession.getId());
            if (applicationSessionIds.size() <= 0) {
                this.loginedUserNames.remove(applicationSession.getUserName());
            }
        }
        if (applicationSession.isConsole()) {
            this.consoleSessions.remove(applicationSession.getId());
        }
    }

    private void updateLoginedUserName(ApplicationSession applicationSession) {
        String userName = applicationSession.getUserName();
        List<String> applicationSessionIds = this.loginedUserNames.get(userName);
        if (applicationSessionIds == null) {
            applicationSessionIds = new ArrayList<String>();
            this.loginedUserNames.put(userName, applicationSessionIds);
        }
        applicationSessionIds.add(applicationSession.getId());
        logger.debug((Object)("UserName(" + userName + ") put to loginedUserNames."));
        if (applicationSession.isConsole() && this.consoleSessions.get(applicationSession.getId()) == null) {
            this.consoleSessions.put(applicationSession.getId(), applicationSession.getUserName());
        }
    }

    protected void timeout(ApplicationSession applicationSession) {
        this.applicationSessions.remove(applicationSession.getId());
        this.removeLoginedUserName(applicationSession);
    }

    protected long getTTLUnit() {
        return 60000L;
    }

    protected void applicationSessionTimeout() {
        ApplicationSession[] applicationSessions = this.applicationSessions.values().toArray(new ApplicationSession[0]);
        long timeoutSessionCount = 0L;
        long beginTimeout = DateUtil.getCurrentTimeMillis();
        long anonymousTTL = this.getAnonymousTTL() * this.getTTLUnit();
        long loginedTTL = this.getLoginedTTL() * this.getTTLUnit();
        ApplicationSession[] applicationSessionArray = applicationSessions;
        int n = applicationSessions.length;
        int n2 = 0;
        while (n2 < n) {
            ApplicationSession applicationSession = applicationSessionArray[n2];
            if (applicationSession.isTimeouted(anonymousTTL, loginedTTL)) {
                this.timeout(applicationSession);
                ++timeoutSessionCount;
                logger.debug((Object)("ApplicationSession (" + applicationSession + ") timeouted."));
            } else {
                logger.debug((Object)("ApplicationSession (" + applicationSession + ") continue lived."));
            }
            ++n2;
        }
        long timeoutDuration = DateUtil.getCurrentTimeMillis() - beginTimeout;
        logger.debug((Object)("Have(" + timeoutSessionCount + ")sessions timeouted elapsed (" + timeoutDuration + ")ms of (" + applicationSessions.length + ") sessions."));
    }

    @Override
    public String getModuleName() {
        return "localSessionHandler";
    }

    @Override
    public void start() {
        this.sessionTimeoutThread = new DaemonThreadControllor();
        this.sessionTimeoutThread.start("Session.Timeout.Thread", 60, new IThreadWorkload(){

            @Override
            public void onExecute() {
                LocalSessionHandler.this.applicationSessionTimeout();
            }
        });
        this.hourlyTimer = new DaemonThreadControllor();
        this.hourlyTimer.start("Session.HourlyEvent.Thread", 3600, this.getHourlyDelay(), new IThreadWorkload(){

            @Override
            public void onExecute() {
                Calendar current = Calendar.getInstance();
                LocalSessionHandler.this.hourlyEvent(DateUtil.format2String(current.getTime(), "yyyy-MM-dd"), current.get(11));
            }
        });
        this.dailyTimer = new DaemonThreadControllor();
        this.dailyTimer.start("Session.DailyEvent.Thread", 86400, this.getDailyDelay(), new IThreadWorkload(){

            @Override
            public void onExecute() {
                LocalSessionHandler.this.dailyEvent(DateUtil.format2String(Calendar.getInstance().getTime(), "yyyy-MM-dd"));
            }
        });
    }

    private long getDailyDelay() {
        long dayDuration = DateUtil.getDayDurationAsMillis(1);
        logger.debug((Object)("Day delay (" + dayDuration + ") ms."));
        return dayDuration;
    }

    private long getHourlyDelay() {
        long hourDuration = DateUtil.getHourDurationAsMillis(1);
        logger.debug((Object)("Hour delay (" + hourDuration + ") ms."));
        return hourDuration;
    }

    @Override
    public void stop() {
        if (this.sessionTimeoutThread != null) {
            this.sessionTimeoutThread.stop();
        }
        if (this.hourlyTimer != null) {
            this.hourlyTimer.stop();
        }
        if (this.dailyTimer != null) {
            this.dailyTimer.stop();
        }
    }

    @Override
    public void restart() {
    }

    protected void dailyEvent(String day) {
        logger.debug((Object)("dailyVisitedUsers(" + this.dailyVisitedUsers + ") and dailyLoginedUsers(" + this.dailyLoginedUsers + ") rotated by daily."));
        this.dailyLoginedUsers.rotate();
        this.dailyVisitedUsers.rotate();
    }

    protected void hourlyEvent(String day, int hour) {
        logger.debug((Object)("hourlyLoginedUsers(" + this.hourlyLoginedUsers + ") and hourlyVisitedUsers(" + this.hourlyVisitedUsers + ") rotated by hourly."));
        this.hourlyLoginedUsers.rotate();
        this.hourlyVisitedUsers.rotate();
    }

    @Override
    public boolean isLogined(String userName) {
        if (StringHelper.isEmpty(userName)) {
            return false;
        }
        return this.loginedUserNames.get(userName) != null;
    }

    @Override
    public List<ApplicationSession> listApplicationSessions(String userName) {
        ArrayList<ApplicationSession> applicationSessions = new ArrayList<ApplicationSession>();
        if (StringHelper.isEmpty(userName)) {
            return applicationSessions;
        }
        List<String> applicationSessionIds = this.loginedUserNames.get(userName);
        for (String applicationSessionId : applicationSessionIds) {
            applicationSessions.add(this.getApplicationSession(applicationSessionId));
        }
        return applicationSessions;
    }

    @Override
    public int countConsoleUsers() {
        return this.consoleSessions.size();
    }

    @Override
    public int getSessionLimit() {
        return 20000;
    }

    @Override
    public int countFreeSessions(boolean consoleInclude) {
        if (consoleInclude) {
            return this.getSessionLimit() - this.applicationSessions.size();
        }
        return this.getSessionLimit() - this.countTotalUsers() + this.countConsoleUsers();
    }

    protected class BackgroundProcessorSession
    implements Runnable {
        protected BackgroundProcessorSession() {
        }

        @Override
        public void run() {
            while (!LocalSessionHandler.this.isRunning()) {
                try {
                    LocalSessionHandler.this.applicationSessionTimeout();
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                try {
                    Thread.sleep(60000000L);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)"interrrupted when sleep in BackgroundProcessorLogin.");
                }
            }
        }
    }

    class DailyTrigger
    extends TimerTask {
        DailyTrigger() {
        }

        @Override
        public void run() {
            LocalSessionHandler.this.dailyEvent(DateUtil.format2String(Calendar.getInstance().getTime(), "yyyy-MM-dd"));
            logger.debug((Object)"Daily event Triggered.");
        }
    }

    class HourlyTrigger
    extends TimerTask {
        HourlyTrigger() {
        }

        @Override
        public void run() {
            Calendar current = Calendar.getInstance();
            LocalSessionHandler.this.hourlyEvent(DateUtil.format2String(current.getTime(), "yyyy-MM-dd"), current.get(11));
            logger.debug((Object)"Hourly event Triggered.");
        }
    }

    protected class TimestampCounter {
        private long counterValue = 0L;
        private long timestamp = 0L;

        protected TimestampCounter() {
        }

        public void count() {
            ++this.counterValue;
            this.timestamp = DateUtil.getCurrentTimeMillis();
        }

        public void rotate() {
            this.counterValue = 0L;
            this.timestamp = 0L;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public long getCounterValue() {
            return this.counterValue;
        }

        public String toString() {
            return "TimestampCounter [counterValue=" + this.counterValue + ", timestamp=" + this.timestamp + "]";
        }
    }
}

