/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.session.impl;

import com.trs.dev4.jdk16.session.ApplicationSessionException;
import com.trs.dev4.jdk16.session.ISessionHandler;
import com.trs.dev4.jdk16.session.impl.ApplicationSession;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ApplicationSessionFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(ApplicationSessionFilter.class);
    protected ApplicationContext applicationContext;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        ISessionHandler sessionHandler = (ISessionHandler)this.applicationContext.getBean("sessionHandler");
        logger.debug((Object)("Found ISessionHandler(" + sessionHandler + ") with applicationContext(" + this.applicationContext + ")."));
        if (sessionHandler == null) {
            filterChain.doFilter(request, response);
            return;
        }
        if (sessionHandler.ignoreUrl((HttpServletRequest)request, (HttpServletResponse)response)) {
            filterChain.doFilter(request, response);
            return;
        }
        ApplicationSession as = null;
        try {
            as = sessionHandler.getApplicationSession((HttpServletRequest)request, (HttpServletResponse)response, true);
        }
        catch (ApplicationSessionException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            ((HttpServletResponse)response).sendRedirect(ex.getRedirectUrl());
        }
        if (as != null) {
            sessionHandler.updateLastModified(as);
        }
        filterChain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)filterConfig.getServletContext());
        logger.debug((Object)("Found ApplicationContext(" + this.applicationContext + ")."));
    }
}

