/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.session;

import com.trs.dev4.jdk16.servlet24.RequestUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import javax.servlet.http.HttpServletRequest;

public class RequestContext {
    private String userName;
    private int userId;
    private String clientIP;
    private String proxyIPs;
    private String uri;
    private String queryStr;
    private String userAgent;
    private String sysFlag;
    private String callerStackBrief;

    RequestContext() {
    }

    public boolean isLogined() {
        return this.userName != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestContext [");
        if (this.uri != null) {
            sb.append("uri=").append(this.uri);
            if (this.queryStr != null) {
                sb.append("?").append(this.queryStr);
            }
        }
        if (this.clientIP != null) {
            sb.append(", ").append("clientIP=").append(this.clientIP);
        }
        if (this.userName != null) {
            sb.append(", ").append("loginUserName=").append(this.userName);
        }
        if (this.userAgent != null) {
            sb.append(", ").append("userAgent=").append(this.userAgent);
        }
        if (this.proxyIPs != null) {
            sb.append(", ").append("proxyIPs=").append(this.proxyIPs);
        }
        sb.append("]");
        return sb.toString();
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public String getProxyIPs() {
        return this.proxyIPs;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUri() {
        return this.uri;
    }

    public int getUserId() {
        return this.userId;
    }

    public String getSysFlag() {
        return this.sysFlag;
    }

    public String getCallerStackBrief() {
        return this.callerStackBrief;
    }

    public static RequestContext getLocalRequestContext() {
        RequestContext requestContext = new RequestContext();
        requestContext.setUserName("TRSAAA.SYSTEM");
        requestContext.setClientIP("localhost");
        return requestContext;
    }

    public static RequestContext getWebRequestContext(HttpServletRequest request) {
        RequestContext requestContext = new RequestContext();
        requestContext.setClientIP(RequestUtil.getClientIP(request));
        requestContext.setProxyIPs(request.getHeader("X-Forwarded-For"));
        requestContext.uri = request.getRequestURI();
        requestContext.queryStr = request.getQueryString();
        requestContext.userAgent = request.getHeader("user-agent");
        return requestContext;
    }

    public boolean isWebRequest() {
        return !StringHelper.isEmpty(this.userAgent);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setProxyIPs(String proxyIPs) {
        this.proxyIPs = proxyIPs;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public void setSysFlag(String sysFlag) {
        this.sysFlag = sysFlag;
    }

    public void setCallerStackBrief(String callerStackBrief) {
        this.callerStackBrief = callerStackBrief;
    }
}

