/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.servlet24;

import com.trs.dev4.jdk16.utils.CloseUtil;
import com.trs.dev4.jdk16.utils.FileUtil;
import com.trs.dev4.jdk16.utils.IOUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ResponseUtil {
    private static final Logger LOG = Logger.getLogger(ResponseUtil.class);

    private ResponseUtil() {
    }

    public static void clearCache(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache");
        response.addHeader("Cache-Control", "no-store");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", -1L);
        response.setDateHeader("max-age", 0L);
    }

    public static void setCacheExpire(HttpServletResponse response, long ms) {
        long curTime = System.currentTimeMillis();
        response.setDateHeader("Last-Modified", curTime);
        response.setDateHeader("Expires", curTime + ms);
    }

    public static void download(HttpServletResponse response, String fileName, String text) throws IOException {
        response.setContentType("application/x-download");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Content_Length", StringHelper.int2String(text.length()));
        response.getWriter().write(text);
    }

    public static void download(HttpServletResponse response, String fileName, File file) throws IOException {
        FileUtil.assertFileCanRead(file);
        response.setContentType("application/x-download");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
        response.setContentLength((int)file.length());
        ServletOutputStream os = response.getOutputStream();
        IOUtil.copy(file, (OutputStream)os);
    }

    public static void json(HttpServletResponse response, String json) throws IOException {
        ResponseUtil.response(response, json, "UTF-8", null);
    }

    public static void response(HttpServletResponse response, String textPlain) throws IOException {
        response.setContentType("text/plain; charset=UTF-8");
        response.getWriter().write(textPlain);
    }

    public static void response(HttpServletResponse response, String textPlain, String encoding, String contentType) throws IOException {
        if (contentType != null) {
            response.setContentType(contentType);
        } else {
            response.setContentType("text/plain");
        }
        if (encoding != null) {
            response.setCharacterEncoding(encoding);
        }
        response.getWriter().write(textPlain);
        response.flushBuffer();
    }

    public static void responseStream(HttpServletResponse response, String contentType, File file) {
        block9: {
            if (!file.exists()) {
                try {
                    response.sendError(404, "File(" + file.getAbsolutePath() + ") not found!");
                }
                catch (IOException e) {
                    LOG.error((Object)("File not found!" + e.getMessage()), (Throwable)e);
                }
                return;
            }
            response.setContentType(contentType);
            FileInputStream in = null;
            ServletOutputStream out = null;
            try {
                try {
                    response.setContentLength((int)file.length());
                    in = new FileInputStream(file);
                    out = response.getOutputStream();
                    int count = 0;
                    byte[] buf = new byte[4096];
                    while ((count = in.read(buf)) >= 0) {
                        out.write(buf, 0, count);
                    }
                    out.flush();
                }
                catch (Exception e) {
                    LOG.error((Object)("File get fail!" + e.getMessage()), (Throwable)e);
                    CloseUtil.closeInputStream(in);
                    CloseUtil.closeOutputStream((OutputStream)out);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                CloseUtil.closeInputStream(in);
                CloseUtil.closeOutputStream(out);
                throw throwable;
            }
            CloseUtil.closeInputStream(in);
            CloseUtil.closeOutputStream((OutputStream)out);
        }
    }
}

