/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.file.impl;

import com.trs.dev4.jdk16.file.IFile;
import com.trs.dev4.jdk16.file.IFileResource;
import com.trs.dev4.jdk16.utils.DateUtil;
import com.trs.dev4.jdk16.utils.FileUtil;
import com.trs.dev4.jdk16.utils.JSONBuilder;

public abstract class BaseFile
implements IFile {
    @Override
    public String getExtensionName() {
        return FileUtil.getFileExtension(this.getName());
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + ": " + this.toJSON();
    }

    @Override
    public String toJSON() {
        return BaseFile.toJSON(this);
    }

    static String toJSON(IFileResource fileResource) {
        JSONBuilder builder = new JSONBuilder();
        builder.add("name", fileResource.getName());
        builder.add("lastModified", DateUtil.formatMillis(fileResource.lastModified()));
        if (fileResource instanceof IFile) {
            IFile file = (IFile)fileResource;
            builder.add("size", file.length());
        }
        return builder.toJSONObjString();
    }
}

