/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.exec;

import com.trs.dev4.jdk16.utils.CloseUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

class StreamRunner
extends Thread {
    private InputStream is;
    private List<String> output = new ArrayList<String>();
    private boolean finished = false;
    private boolean successReadComplete = false;
    private String encoding;
    private String actualEncoding;

    StreamRunner(InputStream is) {
        this.is = is;
    }

    @Override
    public void run() {
        InputStreamReader isr = new InputStreamReader(this.is);
        this.actualEncoding = isr.getEncoding();
        BufferedReader br = new BufferedReader(isr);
        try {
            try {
                String line = br.readLine();
                while (line != null) {
                    this.output.add(line);
                    line = br.readLine();
                }
                this.successReadComplete = true;
            }
            catch (IOException iOException) {
                CloseUtil.closeReader(br);
                this.finished = true;
            }
        }
        finally {
            CloseUtil.closeReader(br);
            this.finished = true;
        }
    }

    public List<String> getOutput() {
        return this.output;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isSuccessReadComplete() {
        return this.successReadComplete;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getActualEncoding() {
        return this.actualEncoding;
    }
}

