/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.exception;

import com.trs.dev4.jdk16.utils.StringHelper;

public class ExceptionUtil {
    public static String getStackTrace(Throwable t) {
        return ExceptionUtil.getStackTrace(t, null);
    }

    public static String getStackTraceOnlyTRS(Throwable t) {
        return ExceptionUtil.getStackTrace(t, "com.trs.");
    }

    public static String getStackTrace(Throwable t, String prefixInclude) {
        if (t == null) {
            return "";
        }
        StackTraceElement[] stacks = t.getStackTrace();
        StringBuilder sb = new StringBuilder(stacks.length * 64);
        int i = 0;
        while (i < stacks.length) {
            if (i < stacks.length - 1) {
                if (prefixInclude == null) {
                    sb.append(stacks[i]);
                } else if (stacks[i].getClassName().startsWith(prefixInclude)) {
                    sb.append(stacks[i]);
                } else {
                    sb.append("...");
                }
                sb.append(" <- ");
            } else {
                sb.append(stacks[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getBrief(Throwable exception) {
        if (exception == null) {
            return "";
        }
        String message = exception.getMessage();
        String topTrace = ExceptionUtil.getMainCaller(exception, 1);
        String simpleExName = exception.getClass().getSimpleName();
        message = message == null || message.trim().length() == 0 ? simpleExName : String.valueOf(simpleExName) + ": " + message;
        return String.valueOf(message) + " at " + topTrace;
    }

    public static String getMainCaller() {
        return ExceptionUtil.getMainCaller(1);
    }

    public static String getMainCaller(int amount) {
        Exception currStackTrace = new Exception();
        return ExceptionUtil.getMainCaller((Throwable)currStackTrace, amount);
    }

    public static String getMainCaller(Throwable exception, int topNum) {
        return ExceptionUtil.subStackTraceAsStr(exception, topNum, new Class[0]);
    }

    public static String getMainCaller(Throwable exception, Class<?> ... classes) {
        return ExceptionUtil.subStackTraceAsStr(exception, 1, classes);
    }

    public static String subStackTraceAsStr(Throwable exception, int topNum, Class<?> ... classes) {
        if (exception == null) {
            return "";
        }
        StackTraceElement[] stacks = exception.getStackTrace();
        StringBuilder sb = new StringBuilder(topNum * 64);
        String topClass = stacks[0].getClassName();
        int startIndex = 0;
        if (topClass.equals(ExceptionUtil.class.getName())) {
            int i = 0;
            while (i < stacks.length) {
                String currClassName = stacks[i].getClassName();
                if (!currClassName.equals(ExceptionUtil.class.getName())) {
                    startIndex = i;
                    break;
                }
                ++i;
            }
        }
        if (stacks.length <= startIndex) {
            return "No stacks after trimming.";
        }
        String targetClass = stacks[startIndex].getClassName();
        int j = 0;
        while (j < classes.length) {
            Class<?> clazz = classes[j];
            String trimTarget = clazz == null ? targetClass : clazz.getName();
            int i = startIndex;
            while (i < stacks.length) {
                String currClassName = stacks[i].getClassName();
                if (!currClassName.startsWith(trimTarget)) {
                    startIndex = i;
                    break;
                }
                ++i;
            }
            ++j;
        }
        int endIndex = stacks.length < startIndex + topNum ? stacks.length : startIndex + topNum;
        int i = startIndex;
        while (i < endIndex - 1) {
            sb.append(stacks[i]);
            sb.append(" <- ");
            ++i;
        }
        sb.append(stacks[endIndex - 1]);
        return sb.toString();
    }

    public static String friendlyShow(Throwable exception) {
        if (exception == null) {
            return "";
        }
        String message = exception.getLocalizedMessage();
        if (StringHelper.isNotEmpty(message)) {
            return message;
        }
        String friendlyInfo = exception.getClass().getName();
        StackTraceElement[] stacks = exception.getStackTrace();
        friendlyInfo = String.valueOf(friendlyInfo) + "(" + stacks[0].getFileName() + ":" + stacks[0].getLineNumber() + ")";
        return friendlyInfo;
    }
}

