/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.debug.impl;

import com.trs.dev4.jdk16.debug.Debuglog;
import com.trs.dev4.jdk16.debug.IDebuglogManager;
import com.trs.dev4.jdk16.model.BaseManager;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class MemoryDebuglogManager
extends BaseManager<Debuglog>
implements IDebuglogManager {
    private static final Logger logger = Logger.getLogger(MemoryDebuglogManager.class);
    private Debuglog[] debuglogs = new Debuglog[200];
    private static final int SIZE = 200;
    private int currentIndex = 0;

    public MemoryDebuglogManager() {
        int i = 0;
        while (i < this.debuglogs.length) {
            this.debuglogs[i] = new Debuglog();
            ++i;
        }
    }

    @Override
    public List<Debuglog> listAllObjects() {
        return Arrays.asList(this.debuglogs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveOrUpdate(Debuglog debuglog) {
        Debuglog[] debuglogArray = this.debuglogs;
        synchronized (this.debuglogs) {
            this.currentIndex %= 200;
            logger.debug((Object)("CurrentIndex(" + this.currentIndex + ")'s log:" + debuglog));
            this.debuglogs[this.currentIndex] = debuglog;
            ++this.currentIndex;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

