/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.cms.impl;

import com.trs.dev4.jdk16.cms.ICMSPublisher;
import com.trs.dev4.jdk16.tunning.PerformanceTimer;
import com.trs.dev4.jdk16.utils.FileUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityPublisher
implements ICMSPublisher {
    private static final Logger logger = Logger.getLogger(VelocityPublisher.class);
    private String propertiesFile;
    private String templateDirectory;

    @Override
    public void publish(String templateName, Map<String, Object> inputObjects, String outputFile) {
        PerformanceTimer pTimer = new PerformanceTimer();
        FileUtil.saveFile(outputFile, this.merge(templateName, inputObjects));
        logger.debug((Object)("File(" + outputFile + ") merged and output with template(" + templateName + "),elapsed(" + pTimer.getDuration() + ")ms."));
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    public String merge(String templateName, Map<String, Object> inputObjects) {
        if (StringHelper.isEmpty(this.templateDirectory)) {
            this.templateDirectory = String.valueOf(this.getClass().getClassLoader().getResource("").getPath()) + "velocity_templates/";
            logger.info((Object)("TemplateDirectory is null with template(" + templateName + "),use default (" + this.templateDirectory + ")."));
        }
        if (!FileUtil.dirExists(this.templateDirectory)) {
            logger.info((Object)("TemplateDirectory not exists with template(" + templateName + ") ."));
            return "";
        }
        PerformanceTimer pTimer = new PerformanceTimer();
        logger.debug((Object)("PropertiesFile:" + this.propertiesFile + ",templateDirectory:" + this.templateDirectory));
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("file.resource.loader.path", (Object)this.templateDirectory);
        if (FileUtil.fileExists(this.propertiesFile)) {
            ve.init(this.propertiesFile);
        } else {
            ve.init();
        }
        if (!FileUtil.fileExists(String.valueOf(StringHelper.smartAppendSlashToEnd(this.templateDirectory)) + templateName)) {
            logger.info((Object)("TemplateName(" + templateName + ") not exists in directory(" + this.templateDirectory + ")."));
            return "";
        }
        Template t = ve.getTemplate(templateName);
        VelocityContext context = new VelocityContext();
        if (inputObjects != null) {
            for (String key : inputObjects.keySet()) {
                context.put(key, inputObjects.get(key));
                logger.debug((Object)("Put inputObject to VelocityContext with key(" + key + ")."));
            }
        }
        StringWriter writer = new StringWriter();
        t.merge((Context)context, (Writer)writer);
        String content = writer.toString();
        logger.debug((Object)("Content(" + content + ") merged with template(" + templateName + "),elapsed(" + pTimer.getDuration() + ")ms."));
        return content;
    }
}

