/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.cms.impl;

public class ScanContext {
    private String m_sText;
    private int m_iLineNo = 1;
    private int m_iColumn = 1;
    private int m_iOffset;
    private int m_iMarkedLineNo;
    private int m_iMarkedColumn;
    private int m_iMarkedOffset;

    public ScanContext(String s) {
        if (s == null || s.length() <= 0) {
            throw new IllegalArgumentException("\u6a21\u677f\u6b63\u6587\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.m_sText = s;
    }

    public boolean hasChar() {
        return this.m_iOffset < this.m_sText.length();
    }

    public char getChar() {
        return this.m_sText.charAt(this.m_iOffset);
    }

    public char prevChar() {
        return this.m_sText.charAt(this.m_iOffset - 1);
    }

    public void skipChar() {
        char c;
        if (this.m_iOffset >= this.m_sText.length()) {
            return;
        }
        if ((c = this.m_sText.charAt(this.m_iOffset++)) == '\n') {
            ++this.m_iLineNo;
            this.m_iColumn = 1;
        } else {
            ++this.m_iColumn;
        }
    }

    public int getColumn() {
        return this.m_iColumn;
    }

    public int getLineNo() {
        return this.m_iLineNo;
    }

    public int getOffset() {
        return this.m_iOffset;
    }

    public int getLength() {
        return this.m_sText.length();
    }

    public void mark() {
        this.m_iMarkedLineNo = this.m_iLineNo;
        this.m_iMarkedColumn = this.m_iColumn;
        this.m_iMarkedOffset = this.m_iOffset;
    }

    public void reset() {
        this.m_iLineNo = this.m_iMarkedLineNo;
        this.m_iColumn = this.m_iMarkedColumn;
        this.m_iOffset = this.m_iMarkedOffset;
    }

    public String lookAround(int iStartPos) {
        return this.lookAround(iStartPos, this.m_iOffset);
    }

    public String lookAround(int iStartPos, int iClosePos) {
        StringBuffer sb = new StringBuffer(256);
        sb.append('(');
        sb.append("\u884c=").append(this.getLineNo()).append(',');
        sb.append("\u5217=").append(this.getColumn()).append(',');
        sb.append("\u504f\u79fb=").append(this.getOffset()).append(',');
        sb.append("\u6e90\u7801=");
        if (iClosePos >= this.m_sText.length()) {
            iClosePos = this.m_sText.length();
        }
        if (iClosePos - iStartPos < 160) {
            sb.append(this.m_sText.substring(iStartPos, iClosePos));
        } else {
            sb.append(this.m_sText.substring(iStartPos, iStartPos + 79));
            sb.append("...");
            sb.append(this.m_sText.substring(iClosePos - 79, iClosePos));
        }
        sb.append(')');
        return sb.toString();
    }
}

